/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Authentication;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.Application.XProperties;
import au.com.aemo.Common.Authentication.KeyListenerInt;
import au.com.aemo.Common.Authentication.KeyTypeEnum;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Java.propertiesFileEntry;
import au.com.aemo.Common.Java.propertiesFileUpdater;
import au.com.aemo.Common.Logging.Util_Logger;
import java.io.File;
import java.io.FileInputStream;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyManager {
    public static final String PROPERTY_KEY_FILE = "pdr_key.properties";
    private static Logger logger = LoggerFactory.getLogger(KeyManager.class);
    private Properties Keys;
    private Map<KeyTypeEnum, List<KeyListenerInt>> Listeners = new HashMap<KeyTypeEnum, List<KeyListenerInt>>();
    private Date keyFileLastModifiedDate;

    private KeyManager() {
    }

    public static KeyManager getInstance() {
        return SingletonHolder.instance;
    }

    private File getKeyFile() throws URISyntaxException {
        File file = null;
        File file2 = new File("/run/secrets/pdr_key");
        if (file2.exists()) {
            file = file2;
        } else {
            URL uRL = ClassLoader.getSystemResource(PROPERTY_KEY_FILE);
            if (uRL != null) {
                file = new File(uRL.toURI());
            }
        }
        return file;
    }

    public synchronized void loadKeyConfiguration() throws ApplicationException {
        block13: {
            try {
                File file = this.getKeyFile();
                if (file != null) {
                    Properties properties = this.Keys;
                    try (FileInputStream fileInputStream = new FileInputStream(file);){
                        this.Keys = new XProperties();
                        this.Keys.load(fileInputStream);
                    }
                    this.keyFileLastModifiedDate = new Date(file.lastModified());
                    if (this.Listeners != null) {
                        for (Map.Entry entry : this.Keys.entrySet()) {
                            List<KeyListenerInt> list;
                            boolean bl;
                            boolean bl2 = bl = properties == null;
                            if (!bl) {
                                boolean bl3 = bl = !entry.getValue().toString().equalsIgnoreCase(Util.noNull(properties.getProperty(entry.getKey().toString())));
                            }
                            if (!bl || (list = this.Listeners.get((Object)KeyTypeEnum.valueOf(entry.getKey().toString().toUpperCase()))) == null) continue;
                            for (KeyListenerInt keyListenerInt : list) {
                                keyListenerInt.updatedKey(entry.getValue().toString(), this.keyFileLastModifiedDate);
                            }
                        }
                    }
                    break block13;
                }
                throw new Exception("Missing file");
            }
            catch (Exception exception) {
                Util_Logger.error(logger, "Unable to load key configuration from [pdr_key.properties]: " + exception.getMessage());
            }
        }
    }

    public void addListener(KeyListenerInt keyListenerInt) throws ApplicationException {
        List<KeyListenerInt> list = this.Listeners.get((Object)keyListenerInt.getKeyType());
        if (list == null) {
            list = new ArrayList<KeyListenerInt>();
            this.Listeners.put(keyListenerInt.getKeyType(), list);
        }
        list.add(keyListenerInt);
        for (Map.Entry<Object, Object> entry : this.Keys.entrySet()) {
            if (!entry.getKey().toString().equalsIgnoreCase(keyListenerInt.getKeyType().toString())) continue;
            keyListenerInt.updatedKey(entry.getValue().toString(), this.keyFileLastModifiedDate);
        }
    }

    public String getHMACKey() throws Exception {
        String string = this.Keys.getProperty(KeyTypeEnum.HMAC.toString().toLowerCase());
        if (Util.isBlank(string)) {
            throw new Exception("Missing HMAC key");
        }
        return string;
    }

    public Date getKeyFileLastModifiedDate() {
        return this.keyFileLastModifiedDate;
    }

    public static String generateKey() {
        return KeyManager.generateKey(64);
    }

    public static String generateKey(int n2) {
        SecureRandom secureRandom = new SecureRandom();
        return String.format("%0" + n2 / 4 + "X", new BigInteger(n2, secureRandom));
    }

    public synchronized void updateHMACKey(String string) throws ApplicationException {
        try {
            String string2;
            File file = this.getKeyFile();
            if (file != null) {
                string2 = KeyTypeEnum.HMAC.toString().toLowerCase();
                String string3 = this.Keys.getProperty(string2);
                if (string3.length() != string.length()) {
                    throw new Exception("Invalid key length [" + string.length() + "], key must be [" + string3.length() + "] hex characters");
                }
            } else {
                throw new Exception("Missing file");
            }
            propertiesFileEntry propertiesFileEntry2 = new propertiesFileEntry();
            propertiesFileEntry2.Name = string2;
            propertiesFileEntry2.Value = string;
            propertiesFileUpdater propertiesFileUpdater2 = new propertiesFileUpdater();
            propertiesFileUpdater2.run(file.getPath(), Arrays.asList(propertiesFileEntry2));
            this.loadKeyConfiguration();
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Unable to rotate HMAC key: " + exception.getMessage());
        }
    }

    private static class SingletonHolder {
        private static KeyManager instance = new KeyManager();

        private SingletonHolder() {
        }
    }
}

