/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.DataVault;

import au.com.aemo.Common.DataVault.ApplicationDataVaultProviderInt;
import au.com.aemo.Common.DataVault.ApplicationDataVaultToken;
import au.com.aemo.Common.DataVault.DataVault;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebClient;
import au.com.aemo.Common.Web.WebClientAuthNone;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebHelper;
import au.com.aemo.Common.Web.WebHttpResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationDataVaultProviderConjur
implements ApplicationDataVaultProviderInt {
    private static Logger logger = LoggerFactory.getLogger(ApplicationDataVaultProviderConjur.class);
    private static final String ID = "CONJUR";
    private DataVault Config;
    private ApplicationDataVaultToken Token;
    private String itsAccount;
    private String itsURL;
    private String itsAuthLogin;
    private String itsAuthAPIKey;
    private Integer itsExpirySeconds;

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void initialise(DataVault dataVault) throws Exception {
        if (Util.isBlank(dataVault.ServiceContext)) {
            Util_Logger.error(logger, "ServiceContext (Account) is not defined for Conjur Key Vault [" + dataVault.Name + "]");
        }
        if (Util.isBlank(dataVault.Reference)) {
            Util_Logger.error(logger, "URL reference is not defined for Conjur Key Vault [" + dataVault.Name + "]");
        }
        if (Util.isBlank(dataVault.AuthLogin)) {
            Util_Logger.error(logger, "AuthLogin is not defined for Conjur Key Vault [" + dataVault.Name + "]");
        }
        if (Util.isBlank(dataVault.API_Key)) {
            Util_Logger.error(logger, "API_Key is not defined for Conjur Key Vault [" + dataVault.Name + "]");
        }
        if (dataVault.ExpirySeconds == null) {
            Util_Logger.error(logger, "ExpirySeconds is not defined for Conjur Key Vault [" + dataVault.Name + "]");
        }
        this.Config = dataVault;
        this.itsAccount = dataVault.ServiceContext;
        this.itsURL = dataVault.Reference;
        this.itsAuthLogin = dataVault.AuthLogin;
        this.itsAuthAPIKey = dataVault.API_Key;
        this.itsExpirySeconds = dataVault.ExpirySeconds;
        this.Token = this.getToken();
        if (this.Token == null) {
            throw new Exception("Failed to intialise Conjur Key Vault [" + this.Config.Name + "]");
        }
    }

    private ApplicationDataVaultToken getToken() {
        ApplicationDataVaultToken applicationDataVaultToken = null;
        try {
            String string = this.itsURL + "/authn/" + this.itsAccount + "/" + WebHelper.encode(this.itsAuthLogin) + "/authenticate";
            Util_Logger.debug(logger, "Conjur authentication URL is : " + string);
            WebClient webClient = new WebClient().setTimeoutConnectionSecs(10).setTimeoutTransferSecs(10).setUseDefaultSSLContext(false).setAuthProvider(new WebClientAuthNone());
            WebHttpResponse webHttpResponse = webClient.doPost(string, null, WebContent.MediaType.TEXT_PLAIN, this.itsAuthAPIKey);
            if (webHttpResponse.ReturnCode != 200) {
                throw new Exception(webHttpResponse.Body);
            }
            applicationDataVaultToken = new ApplicationDataVaultToken(webHttpResponse.Body, Util.dateOffset(new Date(), this.itsExpirySeconds, 13));
            Util_Logger.info(logger, "Successfully retrieved Conjur access token");
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error requesting access token for Conjur: " + exception.getMessage(), exception);
        }
        return applicationDataVaultToken;
    }

    @Override
    @SuppressFBWarnings(value={"NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"}, justification="Objects populated by JSON serialisation")
    public String getValue(String string) {
        String string2 = null;
        if (this.Token == null) {
            this.Token = this.getToken();
        } else if (this.Token.isExpired()) {
            this.Token = this.getToken();
        }
        if (this.Token == null) {
            Util_Logger.errorNoRaise(logger, "Unable to extract Conjur secret [" + string + "] as authorisation token is unavailable");
        } else {
            try {
                String string3 = this.itsURL + "/secrets/" + this.itsAccount + "/variable/" + WebHelper.encode(string);
                Util_Logger.debug(logger, "Conjur authentication URL is : " + string3);
                WebClient webClient = new WebClient().setTimeoutConnectionSecs(10).setTimeoutTransferSecs(10).setUseDefaultSSLContext(false).setAuthProvider(new WebClientAuthNone());
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("Content-Type", "application/json");
                String string4 = Base64.getEncoder().encodeToString(this.Token.getToken().getBytes());
                hashMap.put("Authorization", "Token token=\"" + string4 + "\"");
                WebHttpResponse webHttpResponse = webClient.doGet(string3, hashMap);
                if (webHttpResponse.ReturnCode != 200) {
                    throw new Exception(webHttpResponse.Body);
                }
                string2 = webHttpResponse.Body;
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Unable to extract Conjur secret [" + string + "]: " + exception.getMessage(), exception);
            }
        }
        Util_Logger.trace(logger, "Resolved Conjur secret [" + string + "] to [" + string2 + "]");
        return string2;
    }
}

