/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Database;

import au.com.aemo.Common.Application.ConfigurationValueResolver;
import au.com.aemo.Common.Application.XProperties;
import au.com.aemo.Common.Database.DbHandler;
import au.com.aemo.Common.Database.DbManager;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"DE_MIGHT_IGNORE"}, justification="Ignore exception when rolling back database under error conditions, it gets rolled back anyway when application terminates and DB connection is closed")
public abstract class AppDatabaseUpgrade {
    private static Logger logger = LoggerFactory.getLogger(AppDatabaseUpgrade.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean processUpgrade(String[] stringArray) throws Exception {
        Object object;
        XProperties xProperties;
        Boolean bl;
        boolean bl2;
        String string;
        boolean bl3;
        boolean bl4;
        String string2;
        String string3;
        DbHandler dbHandler;
        boolean bl5;
        block41: {
            bl5 = false;
            Options options = new Options();
            options.addOption("s", "script", true, "The SQL script to run");
            options.addOption("d", "ddl", false, "Flag to indicate whether this script is DDL");
            options.addOption("m", "dml", false, "Flag to indicate whether this script is DML");
            options.addOption("n", "not-exists", true, "The database structure check, either TABLE or TABLE.COLUMN. If not detected the script is run");
            options.addOption("t", "terminator", true, "The terminator for a statement in the script");
            options.addOption("i", "ignore-pk-violations", false, "Flag set to ignore primary key violations");
            options.addOption("v", "variables", true, "The file containing variables to merge into the query");
            options.addOption("a", "autocommit", true, "Flag set to autocommit mode");
            OptionGroup optionGroup = new OptionGroup();
            optionGroup.setRequired(true);
            optionGroup.addOption(options.getOption("ddl"));
            optionGroup.addOption(options.getOption("dml"));
            options.addOptionGroup(optionGroup);
            DefaultParser defaultParser = new DefaultParser();
            CommandLine commandLine = null;
            try {
                commandLine = defaultParser.parse(options, stringArray);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                HelpFormatter helpFormatter = new HelpFormatter();
                helpFormatter.printHelp("AppPdrLoaderDatabaseUpgrade", options);
                System.exit(1);
            }
            dbHandler = DbManager.getDbHandler();
            string3 = commandLine.getOptionValue("script", null);
            string2 = commandLine.getOptionValue("not-exists", null);
            bl4 = commandLine.hasOption("ddl");
            bl3 = commandLine.hasOption("dml");
            string = commandLine.getOptionValue("terminator", dbHandler.getScriptDelimiter());
            String string4 = commandLine.getOptionValue("variables", null);
            bl2 = commandLine.hasOption("ignore-pk-violations");
            bl = null;
            if (commandLine.hasOption("autocommit")) {
                bl = commandLine.getOptionValue("autocommit", "false").equalsIgnoreCase("true");
            }
            xProperties = new XProperties();
            try {
                if (Util.isBlank(string4)) break block41;
                object = new FileInputStream(new File(string4));
                try {
                    xProperties.load((InputStream)object);
                }
                finally {
                    ((FileInputStream)object).close();
                }
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Error preparing variables : " + exception.getMessage(), exception);
                System.exit(1);
            }
        }
        object = null;
        if (!xProperties.isEmpty()) {
            object = new ConfigurationValueResolver(){

                @Override
                public String resolveExternalVariable(String string, int n2) {
                    return xProperties.getProperty(string);
                }
            };
        }
        Connection connection = null;
        try {
            boolean bl6;
            block42: {
                connection = DbManager.getDbConnection();
                bl6 = true;
                if (Util.isBlank(string2) && bl4) {
                    throw new Exception("Missing check parameter for DDL operation");
                }
                if (bl4) {
                    connection.setAutoCommit(true);
                }
                boolean bl7 = Util.isBlank(string2);
                if (!Util.isBlank(string2)) {
                    if (string2.trim().toLowerCase().startsWith("select ")) {
                        String string5 = object != null ? ((ConfigurationValueResolver)object).resolveValue(string2, false) : string2;
                        try (Statement statement = connection.createStatement();
                             ResultSet resultSet = statement.executeQuery(string5);){
                            if (!resultSet.next()) {
                                bl6 = false;
                            }
                            break block42;
                        }
                    }
                    String[] stringArray2 = Util.getColumns(string2, '.');
                    if (stringArray2.length == 1) {
                        bl6 = dbHandler.checkTableExists(connection, null, stringArray2[0]) == bl7;
                    } else {
                        boolean bl8 = bl6 = dbHandler.checkColumnExists(connection, null, stringArray2[0], stringArray2[1]) == bl7;
                    }
                }
            }
            if (Util.isBlank(string3)) {
                bl5 = bl6;
                Util_Logger.info(logger, "Completed check for '" + string2 + "', result : " + bl5);
                return bl5;
            }
            if (bl6) {
                Util_Logger.info(logger, "Commencing database upgrade using script " + string3);
                DbManager.runScript(connection, string3, string, bl, bl2, null, false);
                if (bl3) {
                    connection.commit();
                }
                bl5 = true;
                Util_Logger.info(logger, "Successfully upgraded database using script " + string3);
                return bl5;
            }
            Util_Logger.info(logger, "Detected check '" + string2 + "' did not pass, skipping database upgrade script");
            return bl5;
        }
        catch (Exception exception) {
            try {
                if (connection != null) {
                    connection.rollback();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Util_Logger.error(logger, "Error upgrading database using script " + string3 + " : " + exception.getMessage(), exception);
            return bl5;
        }
        finally {
            connection = DbManager.getDbConnection();
        }
    }
}

