/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Database;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.Database.DatabaseConfig;
import au.com.aemo.Common.Database.DbHandler;
import au.com.aemo.Common.Database.DbHandlerField;
import au.com.aemo.Common.Database.DbManager;
import au.com.aemo.Common.Database.DbPreparedStatementParam;
import au.com.aemo.Common.Database.DbSpaceStats;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbHandlerPostgreSQL
extends DbHandler {
    private static Logger logger = LoggerFactory.getLogger(DbHandlerPostgreSQL.class);

    public DbHandlerPostgreSQL(DatabaseConfig databaseConfig, String string, String string2) throws ApplicationException {
        super(databaseConfig, string, string2);
    }

    @Override
    public void afterConnect(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        if (statement != null) {
            statement.close();
        }
    }

    @Override
    public int maptoFieldTypeId(String string) {
        if (string.equalsIgnoreCase("numeric")) {
            return 3;
        }
        if (string.equalsIgnoreCase("timestamp")) {
            return 93;
        }
        if (string.equalsIgnoreCase("int2")) {
            return 4;
        }
        if (string.equalsIgnoreCase("int4")) {
            return 4;
        }
        if (string.equalsIgnoreCase("int8")) {
            return 4;
        }
        if (string.equalsIgnoreCase("bpchar")) {
            return 1;
        }
        return 12;
    }

    @Override
    @SuppressFBWarnings(value={"SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"}, justification="Script parameters are driven by managed configuration and not user input. No significant risk of SQL injection")
    public Map<String, DbHandlerField> getColumnList(Connection connection, String string, String string2) throws ApplicationException {
        LinkedHashMap<String, DbHandlerField> linkedHashMap = new LinkedHashMap<String, DbHandlerField>();
        try (Statement statement = connection.createStatement();){
            String string3 = "SELECT upper(column_name) as column_name,upper(udt_name) as data_type,character_maximum_length as data_length,numeric_scale FROM information_schema.columns   WHERE upper(table_name) = '" + string2.toUpperCase() + "'" + this.getInformationSchemaPredicate(null, string) + " order by ordinal_position";
            try (ResultSet resultSet = statement.executeQuery(string3);){
                while (resultSet.next()) {
                    DbHandlerField dbHandlerField = new DbHandlerField(resultSet.getString(1), resultSet.getString(2), this.maptoFieldTypeId(resultSet.getString(2)), resultSet.getInt(3), resultSet.getInt(4), linkedHashMap.size());
                    linkedHashMap.put(dbHandlerField.getFieldName().toUpperCase(), dbHandlerField);
                }
            }
        }
        catch (SQLException sQLException) {
            Util_Logger.error(logger, "Detected error in getColumnList: " + sQLException.getMessage(), sQLException);
        }
        return linkedHashMap;
    }

    @Override
    @SuppressFBWarnings(value={"SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"}, justification="Script parameters are driven by managed configuration and not user input. No significant risk of SQL injection")
    public List<String> getPkList(Connection connection, String string, String string2) throws ApplicationException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (Statement statement = connection.createStatement();){
            String string3 = "select upper(ccc.column_name) as column_name from information_schema.table_constraints tc,information_schema.key_column_usage ccc WHERE upper(tc.table_name) = '" + string2.toUpperCase() + "'" + this.getInformationSchemaPredicate("tc", string) + " and tc.constraint_type = 'PRIMARY KEY' and tc.constraint_name = ccc.constraint_name order by ccc.ordinal_position";
            try (ResultSet resultSet = statement.executeQuery(string3);){
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString(1));
                }
            }
        }
        catch (SQLException sQLException) {
            Util_Logger.error(logger, "Detected error in getPkList: " + sQLException.getMessage(), sQLException);
        }
        return arrayList;
    }

    @Override
    @SuppressFBWarnings(value={"SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"}, justification="The seqeunce names are hard coded in the application and therefore no SQL injection risk")
    public long getSequence(Connection connection, String string, String string2) throws ApplicationException {
        long l2 = -1L;
        try (Statement statement = connection.createStatement();){
            String string3 = "select nextval('" + this.getTableReference(string, string2) + "')";
            try (ResultSet resultSet = statement.executeQuery(string3);){
                while (resultSet.next()) {
                    l2 = resultSet.getLong(1);
                }
            }
        }
        catch (SQLException sQLException) {
            Util_Logger.error(logger, "Detected error in getSequence: " + sQLException.getMessage(), sQLException);
        }
        return l2;
    }

    @Override
    public String getCurrentDateTime() {
        return "now()";
    }

    @Override
    public String getCurrentUser() {
        return "CURRENT_USER";
    }

    @Override
    public String getCurrentSchema() {
        return "CURRENT_SCHEMA";
    }

    @Override
    public String getNoTable() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DbSpaceStats> getSpaceUsage() throws ApplicationException {
        ArrayList<DbSpaceStats> arrayList = new ArrayList<DbSpaceStats>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DbManager.getDbConnection();
            statement = connection.createStatement();
            String string = "SELECT spcname, pg_tablespace_size(spcname) as used_bytes FROM pg_tablespace" + this.getTablespaceToReportSQL("where", "spcname") + " order by spcname";
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                DbSpaceStats dbSpaceStats = new DbSpaceStats(resultSet.getString("spcname"));
                dbSpaceStats.setUsedBytes(resultSet.getLong("used_bytes"));
                arrayList.add(dbSpaceStats);
            }
            DbManager.freeDbConnection(connection, statement, resultSet);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error extracting database space statistics: " + exception.getMessage(), exception);
        }
        finally {
            DbManager.freeDbConnection(connection, statement, resultSet);
        }
        return arrayList;
    }

    @Override
    public String getSqlDate(Date date) {
        return this.getSqlDate(Util.dateToStr(date, this.getJavaDateFormat()));
    }

    @Override
    public String getSqlDate(String string) {
        return "to_timestamp('" + string + "','" + this.getDbDateFormat() + "')";
    }

    @Override
    public String concatStr(String string, String string2) {
        return "CONCAT(" + string + "," + string2 + ")";
    }

    @Override
    public String getDateFieldFormat(DbHandlerField dbHandlerField) {
        if (dbHandlerField.getFieldType().equalsIgnoreCase("TIMESTAMP")) {
            return this.getJavaTimestampFormat();
        }
        return null;
    }

    @Override
    public DbPreparedStatementParam getSqlPreparedStatementFormat(DbHandlerField dbHandlerField) {
        if (dbHandlerField == null) {
            return new DbPreparedStatementParam("?", 12);
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("NUMERIC")) {
            return new DbPreparedStatementParam("cast(? as NUMERIC)", 12);
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("DATE")) {
            return new DbPreparedStatementParam("to_date(?,'" + this.getDbDateFormat() + "')", 12);
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("TIMESTAMP")) {
            return new DbPreparedStatementParam("to_timestamp(?,'" + this.getDbDateFormat() + "')", 12);
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("INT2")) {
            return new DbPreparedStatementParam("cast(? as NUMERIC)", 12);
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("INT4")) {
            return new DbPreparedStatementParam("cast(? as NUMERIC)", 12);
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("INT8")) {
            return new DbPreparedStatementParam("cast(? as NUMERIC)", 12);
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("BPCHAR")) {
            return new DbPreparedStatementParam(this.rightPad("?", dbHandlerField.getDataLength()), 1);
        }
        return new DbPreparedStatementParam("?", 12);
    }

    @Override
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="Return value not required for database connectivity check")
    public boolean isValid(Connection connection) {
        boolean bl = false;
        if (connection != null) {
            try {
                try (Statement statement = connection.createStatement();){
                    statement.executeQuery("select 1");
                }
                bl = true;
            }
            catch (Exception exception) {
                Util_Logger.warning(logger, "Error on SQL connection: " + exception.getMessage(), exception);
            }
        }
        return bl;
    }

    @Override
    public String ifNull(String string, String string2) {
        return "COALESCE(" + string + "," + string2 + ")";
    }

    private String rightPad(String string, int n2) {
        return "RPAD(" + string + "," + n2 + ")::char(" + n2 + ")";
    }

    @Override
    public String getSqlRowLimited(String string, String string2, int n2) {
        return "SELECT " + string + " ORDER BY " + string2 + " LIMIT " + n2;
    }

    @Override
    public String getBitOperator(String string, String string2) {
        return "(" + string + " & " + string2 + ")";
    }

    @Override
    public String getSqlDateRoundUp(String string, int n2) throws Exception {
        return "date_trunc('day'," + string + ") + cast((" + n2 + " || ' min') as interval)*(floor((EXTRACT(EPOCH FROM (" + string + " - date_trunc('day'," + string + ")))-1)/(" + n2 + "*60))+1)";
    }

    @Override
    public String getSqlDateDiffInSecs(String string, String string2) {
        return "EXTRACT(EPOCH FROM (" + string2 + " - " + string + "))";
    }

    @Override
    public String getSqlDateAdd(String string, String string2, int n2) throws Exception {
        String string3 = string2.trim().startsWith("-") ? "-" : "+";
        String string4 = Util.replaceAll(string2, "-", "");
        switch (n2) {
            case 13: {
                return string + " " + string3 + " INTERVAL '" + string4 + " SECOND'";
            }
            case 12: {
                return string + " " + string3 + " INTERVAL '" + string4 + " MINUTE'";
            }
            case 11: {
                return string + " " + string3 + " INTERVAL '" + string4 + " HOUR'";
            }
            case 5: {
                return string + " " + string3 + " INTERVAL '" + string4 + " DAY'";
            }
        }
        throw new Exception("Unsupported operation getSqlDateAdd for Calendar field ID " + n2);
    }

    @Override
    protected String getInformationSchemaPredicate(String string, String string2) {
        return super.getInformationSchemaPredicate(string, string2 == null ? string2 : string2.toLowerCase());
    }

    @Override
    public boolean checkTableExists(Connection connection, String string, String string2) throws ApplicationException {
        return super.checkTableExists(connection, string == null ? string : string.toLowerCase(), string2.toLowerCase());
    }

    @Override
    public boolean checkColumnExists(Connection connection, String string, String string2, String string3) throws ApplicationException {
        return super.checkColumnExists(connection, string == null ? string : string.toLowerCase(), string2.toLowerCase(), string3.toLowerCase());
    }

    @Override
    public String getURL() {
        String string = super.getURL();
        if (Util.isBlank(this.getDefaultSchema())) {
            return string;
        }
        if (string.indexOf("?") < 0) {
            return string + "?currentSchema=" + this.getDefaultSchema();
        }
        return string + "&currentSchema=" + this.getDefaultSchema();
    }

    @Override
    public String getDefaultSchemaSQL() {
        String string = null;
        if (!Util.isBlank(this.getDefaultSchema())) {
            string = "SET SEARCH_PATH = " + this.getDefaultSchema();
        }
        return string;
    }

    @Override
    public boolean isPrimaryKeyViolation(SQLException sQLException) {
        return sQLException.getSQLState().equalsIgnoreCase(this.getPrimaryKeySQLErrorCode("23505"));
    }
}

