/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Database;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.Database.DatabaseConfig;
import au.com.aemo.Common.Database.DbHandler;
import au.com.aemo.Common.Database.DbHandlerField;
import au.com.aemo.Common.Database.DbManager;
import au.com.aemo.Common.Database.DbPreparedStatementParam;
import au.com.aemo.Common.Database.DbSpaceStats;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbHandlerSqlServer
extends DbHandler {
    private static Logger logger = LoggerFactory.getLogger(DbHandlerSqlServer.class);

    public DbHandlerSqlServer(DatabaseConfig databaseConfig, String string, String string2) throws ApplicationException {
        super(databaseConfig, string, string2);
    }

    @Override
    public void afterConnect(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            if (!Util.isBlank(this.getDbDateFormat())) {
                statement.execute("SET DATEFORMAT " + this.getDbDateFormat());
            }
        }
    }

    @Override
    @SuppressFBWarnings(value={"SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"}, justification="Script parameters are driven by managed configuration and not user input. No significant risk of SQL injection")
    public Map<String, DbHandlerField> getColumnList(Connection connection, String string, String string2) throws ApplicationException {
        LinkedHashMap<String, DbHandlerField> linkedHashMap = new LinkedHashMap<String, DbHandlerField>();
        try {
            String string3 = "SELECT Col.COLUMN_NAME ,Col.DATA_TYPE ,ISNULL(Col.CHARACTER_MAXIMUM_LENGTH,Col.NUMERIC_PRECISION) as LENGTH ,Col.NUMERIC_SCALE as PRECISION from " + this.getDbName(string) + "INFORMATION_SCHEMA.COLUMNS Col where\tupper(Col.Table_Name) = '" + string2.toUpperCase() + "'" + this.getInformationSchemaPredicate("Col", string) + " ORDER BY Col.ORDINAL_POSITION";
            try (Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery(string3);){
                while (resultSet.next()) {
                    DbHandlerField dbHandlerField = new DbHandlerField(resultSet.getString(1), resultSet.getString(2), this.maptoFieldTypeId(resultSet.getString(2)), resultSet.getInt(3), resultSet.getInt(4), linkedHashMap.size());
                    linkedHashMap.put(dbHandlerField.getFieldName().toUpperCase(), dbHandlerField);
                }
            }
        }
        catch (SQLException sQLException) {
            Util_Logger.error(logger, "Detected error in getColumnList: " + sQLException.getMessage(), sQLException);
        }
        return linkedHashMap;
    }

    @Override
    @SuppressFBWarnings(value={"SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"}, justification="Script parameters are driven by managed configuration and not user input. No significant risk of SQL injection")
    public List<String> getPkList(Connection connection, String string, String string2) throws ApplicationException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String string3 = this.getDbName(string);
            String string4 = " SELECT Col.COLUMN_NAME from\t" + string3 + "INFORMATION_SCHEMA.TABLE_CONSTRAINTS Tab,\t" + string3 + "INFORMATION_SCHEMA.KEY_COLUMN_USAGE Col WHERE\tCol.Constraint_Name = Tab.Constraint_Name and Col.TABLE_CATALOG = Tab.TABLE_CATALOG and Col.TABLE_SCHEMA = Tab.TABLE_SCHEMA\tAND Col.Table_Name = Tab.Table_Name\tAND Constraint_Type = 'PRIMARY KEY'\tAND upper(Col.Table_Name) = '" + string2.toUpperCase() + "'" + this.getInformationSchemaPredicate("Tab", string) + " ORDER BY\tCol.ORDINAL_POSITION";
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string4);
            while (resultSet.next()) {
                String string5 = resultSet.getString(1);
                arrayList.add(string5.toUpperCase());
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Util_Logger.error(logger, "Detected error in getPkList: " + sQLException.getMessage(), sQLException);
        }
        return arrayList;
    }

    @Override
    public long getSequence(Connection connection, String string, String string2) throws ApplicationException {
        long l2 = -1L;
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT NEXT VALUE FOR " + this.getTableReference(string, string2));){
            while (resultSet.next()) {
                l2 = resultSet.getLong(1);
            }
        }
        catch (SQLException sQLException) {
            Util_Logger.error(logger, "Detected error in getSequence: " + sQLException.getMessage(), sQLException);
        }
        return l2;
    }

    @Override
    public String getCurrentDateTime() {
        return "GETDATE()";
    }

    @Override
    public String getCurrentUser() {
        return "SUSER_SNAME()";
    }

    @Override
    public String getCurrentSchema() {
        return "SCHEMA_NAME()";
    }

    @Override
    public String getNoTable() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DbSpaceStats> getSpaceUsage() throws ApplicationException {
        ArrayList<DbSpaceStats> arrayList = new ArrayList<DbSpaceStats>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DbManager.getDbConnection();
            statement = connection.createStatement();
            String string = "Select b.groupname, SUM(cast(FILEPROPERTY(name, 'SpaceUsed') AS bigint) )*8*1024 as used_bytes, SUM(cast(max_size AS bigint))*8*1024 as max_bytes FROM sys.database_files a,sysfilegroups b where a.data_space_id=b.groupid" + this.getTablespaceToReportSQL("and", "b.groupname") + " group by b.groupname order by groupname";
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                DbSpaceStats dbSpaceStats = new DbSpaceStats(resultSet.getString("groupname").toUpperCase());
                dbSpaceStats.setUsedBytes(resultSet.getLong("used_bytes"));
                Long l2 = resultSet.getLong("max_bytes");
                if (l2 > 0L) {
                    dbSpaceStats.setTotalBytes(l2);
                }
                arrayList.add(dbSpaceStats);
            }
            DbManager.freeDbConnection(connection, statement, resultSet);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error extracting database space statistics: " + exception.getMessage(), exception);
        }
        finally {
            DbManager.freeDbConnection(connection, statement, resultSet);
        }
        return arrayList;
    }

    @Override
    public String getSqlDate(Date date) {
        return this.getSqlDate(Util.dateToStr(date, this.getJavaDateFormat()));
    }

    @Override
    public String getSqlDate(String string) {
        return "convert(datetime,'" + string + "')";
    }

    @Override
    public String concatStr(String string, String string2) {
        return "CONCAT(" + string + "," + string2 + ")";
    }

    @Override
    public String getDateFieldFormat(DbHandlerField dbHandlerField) {
        if (dbHandlerField.getFieldType().equalsIgnoreCase("DATETIME")) {
            return this.getJavaTimestampFormat();
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("DATETIME2")) {
            return this.getJavaTimestampFormat();
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("DATE")) {
            return this.getJavaDateFormat();
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("TIMESTAMP")) {
            return this.getJavaTimestampFormat();
        }
        return null;
    }

    private boolean isDateField(DbHandlerField dbHandlerField) {
        return dbHandlerField.getFieldType().equalsIgnoreCase("TIMESTAMP") || dbHandlerField.getFieldType().equalsIgnoreCase("DATETIME") || dbHandlerField.getFieldType().equalsIgnoreCase("DATETIME2") || dbHandlerField.getFieldType().equalsIgnoreCase("DATE");
    }

    private String getSqlPreparedStatementDateFormat(DbHandlerField dbHandlerField) {
        if (dbHandlerField.getFieldType().equalsIgnoreCase("DATETIME2")) {
            return "convert(datetime2(" + dbHandlerField.getDataScale() + "),?)";
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("DATE")) {
            return "convert(date,?)";
        }
        return "convert(datetime,?)";
    }

    @Override
    public DbPreparedStatementParam getSqlPreparedStatementFormat(DbHandlerField dbHandlerField) {
        if (dbHandlerField == null) {
            return new DbPreparedStatementParam("?", 12);
        }
        if (this.isDateField(dbHandlerField)) {
            return new DbPreparedStatementParam(this.getSqlPreparedStatementDateFormat(dbHandlerField), 12);
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("CHAR")) {
            return new DbPreparedStatementParam(this.rightPad("?", dbHandlerField.getDataLength()), 12);
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("DECIMAL")) {
            return new DbPreparedStatementParam("CAST(CAST(? as FLOAT) AS DECIMAL(" + dbHandlerField.getDataLength() + "," + dbHandlerField.getDataScale() + "))", 12);
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("NUMERIC")) {
            return new DbPreparedStatementParam("CAST(CAST(? as FLOAT) AS NUMERIC(" + dbHandlerField.getDataLength() + "," + dbHandlerField.getDataScale() + "))", 12);
        }
        return new DbPreparedStatementParam("?", 12);
    }

    @Override
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="Return value not required for database connectivity check")
    public boolean isValid(Connection connection) {
        boolean bl = false;
        if (connection != null) {
            try {
                try (Statement statement = connection.createStatement();){
                    statement.executeQuery("select getdate()");
                }
                bl = true;
            }
            catch (Exception exception) {
                Util_Logger.warning(logger, "Error on SQL connection: " + exception.getMessage(), exception);
            }
        }
        return bl;
    }

    @Override
    public String ifNull(String string, String string2) {
        return "ISNULL(" + string + "," + string2 + ")";
    }

    private String rightPad(String string, int n2) {
        return "cast(" + string + " as char(" + n2 + "))";
    }

    @Override
    public String getSqlRowLimited(String string, String string2, int n2) {
        return "SELECT TOP " + n2 + " " + string + " ORDER BY " + string2;
    }

    @Override
    public String getBitOperator(String string, String string2) {
        return "(" + string + " & " + string2 + ")";
    }

    @Override
    public String getSqlDateRoundUp(String string, int n2) {
        return "DATEADD(MINUTE, " + n2 + " + FLOOR(DATEDIFF(MINUTE, 0, DATEADD(SECOND,-1," + string + ")) / " + n2 + ") * " + n2 + ", 0)";
    }

    @Override
    public String getSqlDateDiffInSecs(String string, String string2) throws Exception {
        return "cast(DATEDIFF(millisecond," + string + "," + string2 + ") as float)/1000";
    }

    @Override
    public String getSqlDateAdd(String string, String string2, int n2) throws Exception {
        switch (n2) {
            case 13: {
                return "DATEADD(second," + string2 + "," + string + ")";
            }
            case 12: {
                return "DATEADD(minute," + string2 + "," + string + ")";
            }
            case 11: {
                return "DATEADD(hour," + string2 + "," + string + ")";
            }
            case 5: {
                return "DATEADD(day," + string2 + "," + string + ")";
            }
        }
        throw new Exception("Unsupported operation getSqlDateAdd for Calendar field ID " + n2);
    }

    @Override
    public String getScriptDelimiter() {
        return "go";
    }

    @Override
    public String getCodeBlockBegin() {
        return "begin";
    }

    @Override
    public String getCodeBlockEnd() {
        return "end";
    }

    @Override
    public boolean isPrimaryKeyViolation(SQLException sQLException) {
        return sQLException.getErrorCode() == Integer.parseInt(this.getPrimaryKeySQLErrorCode("2627"));
    }
}

