/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FileSystem;

import au.com.aemo.Common.FileSystem.fsConnectionBase;
import au.com.aemo.Common.FileSystem.fsConnectionFileFilterInt;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.FileSystem.fsFileLockInt;
import au.com.aemo.Common.FileSystem.fsFileLockNone;
import au.com.aemo.Common.FileSystem.fsFileTypeEnum;
import au.com.aemo.Common.FileSystem.fsProcessStatus;
import au.com.aemo.Common.Files.FileNameTokenResolver;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebClient;
import au.com.aemo.Common.Web.WebClientAuthInt;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebHttpResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.net.Proxy;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class fsConnectionAPI
extends fsConnectionBase {
    private static Logger logger = LoggerFactory.getLogger(fsConnectionAPI.class);
    private String itsDataSourceId;
    private String itsBaseURL;
    private Proxy itsProxy;
    private String itsCurrentDir;
    private int itsTransferBufferSize;
    private int itsTimeoutConnectionSecs;
    private int itsTimeoutTransferSecs;
    private WebClientAuthInt itsAuthProvider;
    private boolean itsUseDefaultSSLContext;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Class is consumed by trusted code")
    public fsConnectionAPI(String string, String string2, Proxy proxy, int n2, int n3, boolean bl) {
        super(string);
        this.itsDataSourceId = string;
        this.itsBaseURL = string2;
        this.itsProxy = proxy;
        this.itsTransferBufferSize = 1024;
        this.itsTimeoutConnectionSecs = n2;
        this.itsTimeoutTransferSecs = n3;
        this.itsUseDefaultSSLContext = bl;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Method is consumed by trusted code")
    public void setAuthProvider(WebClientAuthInt webClientAuthInt) {
        this.itsAuthProvider = webClientAuthInt;
    }

    @Override
    public String getDataSourceId() {
        return this.itsDataSourceId;
    }

    @Override
    public boolean supportsFileTimestamps() {
        return false;
    }

    @Override
    public boolean supportsFileMasks() {
        return false;
    }

    @Override
    public fsFileInfo resolveFilenameSpec(String string) throws Exception {
        throw new Exception("API connection does not support a resolveFilenameSpec operation");
    }

    @Override
    public void makeDir(String string) throws Exception {
        throw new Exception("API connection does not support a directory create operation");
    }

    @Override
    public void changeDir(String string) throws Exception {
        this.itsCurrentDir = this.itsBaseURL + "/" + string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<String, fsFileInfo> listFiles(String string, fsConnectionFileFilterInt fsConnectionFileFilterInt2, String string2) throws Exception {
        HashMap<String, fsFileInfo> hashMap = new HashMap<String, fsFileInfo>();
        try {
            void var10_16;
            void var10_14;
            String string32;
            String[] stringArray = Util.getColumns(string, '?');
            String string4 = stringArray[0];
            String[] stringArray2 = Util.getColumns(string4, '/');
            String string5 = stringArray2[stringArray2.length - 1];
            String string6 = "";
            for (String string32 : stringArray2) {
                String string7;
                if (Util.isBlank(string32) || !string32.toLowerCase().startsWith("v") || string32.length() <= 1 || !Util.isInteger(string7 = string32.substring(1))) continue;
                string6 = string7;
            }
            Object var10_12 = null;
            if (fsConnectionFileFilterInt2 != null) {
                String string8 = fsConnectionFileFilterInt2.getOutputFilenameMask();
            }
            if (Util.isBlank((String)var10_14)) {
                String string9 = "PUBLIC_{report_type}_v{api_version}_{date:yyyyMMddHHmmssSSS}.json";
            }
            fsFileInfo fsFileInfo2 = new fsFileInfo();
            fsFileInfo2.setFileType(fsFileTypeEnum.FILE);
            fsFileInfo2.setSize(null);
            fsFileInfo2.setModifiedDate(null, false);
            fsFileInfo2.setDirectory(string);
            if (fsConnectionFileFilterInt2 != null) {
                fsFileInfo2.addAPIHeaderValues(fsConnectionFileFilterInt2.getAPIHeaderValues());
            }
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put("report_type", string5);
            hashMap2.put("api_version", string6);
            if (fsFileInfo2.getEventData() != null) {
                if (fsFileInfo2.getAPIHeaderValues() != null) {
                    hashMap2.putAll(fsFileInfo2.getEventData().getAPIHeaderValues());
                }
                if (fsFileInfo2.getEventData().getEventParameters() != null) {
                    hashMap2.putAll(fsFileInfo2.getEventData().getEventParameters());
                }
            }
            string32 = FileNameTokenResolver.process((String)var10_16, hashMap2);
            fsFileInfo2.setFilename(string32);
            hashMap.put(fsFileInfo2.getFilename(), fsFileInfo2);
            Util_Logger.debug(logger, "Detected " + hashMap.size() + " files");
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error listing directory " + string + " from json API: " + exception.getMessage(), exception);
        }
        return hashMap;
    }

    protected String getURL(String string) throws Exception {
        Object object = null;
        if (string.toUpperCase().startsWith("HTTP://")) {
            object = string;
        } else if (string.toUpperCase().startsWith("HTTPS://")) {
            object = string;
        } else {
            String[] stringArray = Util.getColumns(string, '?');
            String string2 = stringArray[0];
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            if (stringArray.length > 1) {
                String string3 = FileNameTokenResolver.process(stringArray[1]);
                String[] stringArray2 = Util.getColumns(string3, '&');
                int n2 = 63;
                for (String string4 : stringArray2) {
                    String[] stringArray3 = Util.getColumns(string4, '=');
                    stringBuilder.append((char)n2);
                    stringBuilder.append(stringArray3[0]);
                    stringBuilder.append("=");
                    stringBuilder.append(URLEncoder.encode(stringArray3[1], "UTF-8"));
                    n2 = 38;
                }
            }
            boolean bl = true;
            if (this.itsBaseURL.endsWith("/")) {
                bl = false;
            }
            if (string.startsWith("/")) {
                if (!bl) {
                    stringBuilder.delete(0, 1);
                }
                bl = false;
            }
            object = this.itsBaseURL + (bl ? "/" : "") + stringBuilder.toString();
        }
        return object;
    }

    protected WebClient getWebClient() {
        WebClient webClient = new WebClient().setTimeoutConnectionSecs(this.itsTimeoutConnectionSecs).setTimeoutTransferSecs(this.itsTimeoutTransferSecs).setProxy(this.itsProxy).setUseDefaultSSLContext(this.itsUseDefaultSSLContext);
        webClient.setAuthProvider(this.itsAuthProvider);
        return webClient;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public fsFileInfo getFile(fsFileInfo fsFileInfo2, String string) throws Exception {
        fsFileInfo fsFileInfo3;
        block16: {
            fsFileInfo3 = null;
            File file = null;
            try {
                WebClient webClient = this.getWebClient();
                String string2 = this.getURL(fsFileInfo2.getDirectory());
                Util_Logger.debug(logger, "Getting from URL: " + string2);
                if (fsFileInfo2.getAPIHeaderValues() != null) {
                    for (Map.Entry object : fsFileInfo2.getAPIHeaderValues().entrySet()) {
                        Util_Logger.debug(logger, "HTTP header [" + String.valueOf(object.getKey()) + "] = [" + String.valueOf(object.getValue()) + "]");
                    }
                }
                WebHttpResponse webHttpResponse = webClient.doGet(string2, fsFileInfo2.getAPIHeaderValues());
                if (webHttpResponse.ReturnCode == 200) {
                    void var8_13;
                    String string3 = fsFileInfo2.getFilename();
                    if (Util.isBlank(string3)) {
                        String string4 = "API_response_" + Util.dateToStr(new Date(), "yyyyMMddHHmmssSSS") + ".tmp";
                    }
                    file = new File(string + "/" + (String)var8_13);
                    try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                        fileOutputStream.write(webHttpResponse.Body.getBytes());
                        fileOutputStream.flush();
                    }
                    if (fsFileInfo2.getModifiedDate() != null && !file.setLastModified(fsFileInfo2.getModifiedDate().getTime())) {
                        Util_Logger.warning(logger, "Unable to set modified time on file [" + file.getName() + "]");
                    }
                    fsFileInfo3 = new fsFileInfo(fsFileInfo2);
                    fsFileInfo3.setDirectory(string);
                    fsFileInfo3.setFilename((String)var8_13);
                    break block16;
                }
                Util_Logger.error(logger, "Detected error retrieving API data from " + string2 + ", response code is " + webHttpResponse.ReturnCode);
            }
            catch (Exception exception) {
                try {
                    if (file != null) {
                        FileUtilities.deleteFile(file);
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                Util_Logger.error(logger, "Error getting file " + fsFileInfo2.getFilename() + " from API: " + exception.getMessage(), exception);
            }
        }
        return fsFileInfo3;
    }

    @Override
    public fsProcessStatus putFile(fsFileInfo fsFileInfo2, String string, boolean bl, String string2) throws Exception {
        fsProcessStatus fsProcessStatus2 = new fsProcessStatus();
        File file = null;
        try {
            byte[] byArray = Files.readAllBytes(Paths.get(fsFileInfo2.getDirectory(), fsFileInfo2.getFilename()));
            String string3 = fsFileInfo2.getFilename();
            WebContent.MediaType mediaType = this.getMediaType(string3);
            WebClient webClient = new WebClient().setTimeoutConnectionSecs(this.itsTimeoutConnectionSecs).setTimeoutTransferSecs(this.itsTimeoutTransferSecs).setProxy(this.itsProxy).setUseDefaultSSLContext(this.itsUseDefaultSSLContext);
            webClient.setAuthProvider(this.itsAuthProvider);
            String string4 = this.getURL(string);
            Util_Logger.debug(logger, "Posting to URL: " + string4);
            if (fsFileInfo2.getAPIHeaderValues() != null) {
                for (Map.Entry<String, String> object : fsFileInfo2.getAPIHeaderValues().entrySet()) {
                    Util_Logger.debug(logger, "HTTP header [" + String.valueOf(object.getKey()) + "] = [" + String.valueOf(object.getValue()) + "]");
                }
            }
            WebHttpResponse webHttpResponse = webClient.doPost(string4, fsFileInfo2.getAPIHeaderValues(), mediaType, new String(byArray));
            if (fsFileInfo2.isBusinessResponseCode(webHttpResponse.ReturnCode)) {
                if (!Util.isBlank(string2)) {
                    fsFileInfo fsFileInfo3 = this.writeAckFile(fsFileInfo2, string2, webHttpResponse.Body);
                    fsProcessStatus2.setAcknowledgementResponse(webHttpResponse.ReturnCode, fsFileInfo3);
                    fsFileInfo3.setEventData(fsFileInfo2.getEventData());
                }
                fsProcessStatus2.setProcessSuccess();
            } else {
                Util_Logger.info(logger, "HTTP Response from  " + string4 + " is: " + webHttpResponse.Body);
                Util_Logger.error(logger, "Detected error posting API data to " + string4 + ", response code is " + webHttpResponse.ReturnCode);
            }
            if (bl) {
                FileUtilities.deleteFile(fsFileInfo2);
            }
        }
        catch (Exception exception) {
            try {
                if (file != null) {
                    FileUtilities.deleteFile(file);
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Util_Logger.error(logger, "Error posting to " + fsFileInfo2.getFilename() + " from API: " + exception.getMessage(), exception);
        }
        return fsProcessStatus2;
    }

    @Override
    public void writeData(String string, String string2, byte[] byArray, Date date, fsFileLockInt fsFileLockInt2) throws Exception {
        throw new Exception("API connection does not support a data write operation");
    }

    @Override
    public void deleteFile(String string, String string2) throws Exception {
    }

    @Override
    public void setBandwidthThrottle(int n2) {
    }

    @Override
    public void setTransferBufferSize(int n2) {
        this.itsTransferBufferSize = n2;
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean exists(String string, String string2) {
        return true;
    }

    @Override
    public boolean exists(fsFileInfo fsFileInfo2) throws Exception {
        return this.exists(fsFileInfo2.getDirectory(), fsFileInfo2.getFilename());
    }

    @Override
    public void renameFile(String string, String string2, String string3, String string4) throws Exception {
        throw new Exception("API connection does not support a file rename operation");
    }

    @Override
    public boolean logOperations() {
        return true;
    }

    @Override
    public fsFileLockInt lockFile(fsFileInfo fsFileInfo2) {
        return new fsFileLockNone();
    }
}

