/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FileSystem;

import au.com.aemo.Common.FileSystem.AzureBlob;
import au.com.aemo.Common.FileSystem.AzureBlobProperties;
import au.com.aemo.Common.FileSystem.AzureDirectoryWrapper;
import au.com.aemo.Common.FileSystem.AzureRequestParameters;
import au.com.aemo.Common.FileSystem.fsConnectionBase;
import au.com.aemo.Common.FileSystem.fsConnectionFileFilterInt;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.FileSystem.fsFileLockInt;
import au.com.aemo.Common.FileSystem.fsFileLockNone;
import au.com.aemo.Common.FileSystem.fsFileTypeEnum;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebClient;
import au.com.aemo.Common.XML.XmlUtilities;
import au.com.aemo.Common.XML.xStreamDateConverter;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.DomReader;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class fsConnectionAzure
extends fsConnectionBase {
    private static String VERSION = "2018-03-28";
    private static String AZURE_DATE_FOMAT = "EEE, dd MMM yyyy HH:mm:ss";
    private static Logger logger = LoggerFactory.getLogger(fsConnectionAzure.class);
    private String itsDataSourceId;
    private String itsAccount;
    private String itsBaseURL;
    private String itsAPIKey;
    private String itsAPISASToken;
    private String itsCurrentDir;
    private boolean itsGetFileModifiedTime;
    private SimpleDateFormat DateFormatter;
    private WebClient itsWebClient;

    public fsConnectionAzure(String string, String string2, String string3, Proxy proxy, String string4, String string5, int n2, int n3, boolean bl) {
        super(string);
        this.itsDataSourceId = string;
        this.itsAccount = string2;
        this.itsBaseURL = string3;
        this.itsAPIKey = string4;
        this.itsAPISASToken = string5;
        this.itsGetFileModifiedTime = bl;
        this.DateFormatter = new SimpleDateFormat(AZURE_DATE_FOMAT);
        this.DateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.itsWebClient = new WebClient().setTimeoutConnectionSecs(n2).setTimeoutTransferSecs(n3).setProxy(proxy);
    }

    @Override
    public String getDataSourceId() {
        return this.itsDataSourceId;
    }

    @Override
    public boolean supportsFileTimestamps() {
        return true;
    }

    @Override
    public boolean supportsFileMasks() {
        return true;
    }

    @Override
    public fsFileInfo resolveFilenameSpec(String string) throws Exception {
        fsFileInfo fsFileInfo2 = new fsFileInfo();
        int n2 = string.lastIndexOf("/");
        if (n2 < 0) {
            throw new Exception("Missing container specification (/) in filename [" + string + "]");
        }
        fsFileInfo2.setDirectory(string.substring(0, n2));
        fsFileInfo2.setFilename(string.substring(n2 + 1));
        return fsFileInfo2;
    }

    @Override
    public void makeDir(String string) throws Exception {
        throw new Exception("Azure connection does not support a directory create operation");
    }

    @Override
    public void changeDir(String string) throws Exception {
        this.itsCurrentDir = string;
    }

    private HttpsURLConnection getHttpURLConnection(String string, AzureRequestParameters azureRequestParameters) {
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = new URL(string);
            httpURLConnection = (HttpsURLConnection)this.itsWebClient.getHttpURLConnection(azureRequestParameters.method, uRL, null);
            String string2 = this.DateFormatter.format(Calendar.getInstance().getTime()) + " GMT";
            if (!Util.isBlank(azureRequestParameters.content_type)) {
                httpURLConnection.setRequestProperty("Content-Type", azureRequestParameters.content_type);
            }
            if (!Util.isBlank(azureRequestParameters.content_length)) {
                httpURLConnection.setRequestProperty("Content-Length", azureRequestParameters.content_length);
            }
            httpURLConnection.setRequestProperty("x-ms-date", string2);
            httpURLConnection.setRequestProperty("x-ms-version", VERSION);
            for (Map.Entry<String, String> object3 : azureRequestParameters.headers.entrySet()) {
                httpURLConnection.setRequestProperty(object3.getKey(), object3.getValue());
            }
            Object object = null;
            if (!Util.isBlank(this.itsAPIKey)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(Util.noNull(azureRequestParameters.method) + "\n");
                stringBuilder.append('\n');
                stringBuilder.append('\n');
                stringBuilder.append(Util.noNull(azureRequestParameters.content_length) + "\n");
                stringBuilder.append('\n');
                stringBuilder.append(Util.noNull(azureRequestParameters.content_type) + "\n");
                stringBuilder.append('\n');
                stringBuilder.append('\n');
                stringBuilder.append('\n');
                stringBuilder.append('\n');
                stringBuilder.append('\n');
                stringBuilder.append('\n');
                for (Map.Entry<String, String> entry : azureRequestParameters.headers.entrySet()) {
                    stringBuilder.append(entry.getKey());
                    stringBuilder.append(":");
                    stringBuilder.append(URLDecoder.decode(entry.getValue(), "UTF-8"));
                    stringBuilder.append("\n");
                }
                stringBuilder.append("x-ms-date:" + string2 + "\n");
                stringBuilder.append("x-ms-version:" + VERSION + "\n");
                stringBuilder.append(azureRequestParameters.resource);
                for (Map.Entry<String, String> entry : azureRequestParameters.parameters.entrySet()) {
                    stringBuilder.append("\n");
                    stringBuilder.append(entry.getKey());
                    stringBuilder.append(":");
                    stringBuilder.append(URLDecoder.decode(entry.getValue(), "UTF-8"));
                }
                Mac mac = Mac.getInstance("HmacSHA256");
                mac.init(new SecretKeySpec(Base64.getDecoder().decode(this.itsAPIKey), "HmacSHA256"));
                byte[] byArray = stringBuilder.toString().getBytes("UTF-8");
                String string3 = Base64.getEncoder().encodeToString(mac.doFinal(byArray));
                object = "SharedKey " + this.itsAccount + ":" + string3;
            }
            if (!Util.isBlank(object)) {
                httpURLConnection.setRequestProperty("Authorization", (String)object);
            }
        }
        catch (Exception exception) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            httpURLConnection = null;
            Util_Logger.errorNoRaise(logger, "Error connecting to HTTP URL " + string + ": " + exception.getMessage());
        }
        return httpURLConnection;
    }

    private Date getFileModifiedDate(String string, String string2) throws Exception {
        throw new Exception("Azure connection does not support a get modified date operation");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @SuppressFBWarnings(value={"NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"}, justification="Objects populated by XML serialisation")
    public Map<String, fsFileInfo> listFiles(String string, fsConnectionFileFilterInt fsConnectionFileFilterInt2, String string2) throws Exception {
        HashMap<String, fsFileInfo> hashMap = new HashMap<String, fsFileInfo>();
        HttpURLConnection httpURLConnection = null;
        try {
            CharSequence charSequence;
            String[] stringArray = Util.getColumns(string, '/');
            String string3 = stringArray[0];
            AzureRequestParameters azureRequestParameters = new AzureRequestParameters();
            azureRequestParameters.method = "GET";
            azureRequestParameters.resource = "/" + this.itsAccount + "/" + string3;
            azureRequestParameters.parameters.put("restype", "container");
            azureRequestParameters.parameters.put("comp", "list");
            azureRequestParameters.parameters.put("delimiter", "/");
            if (stringArray.length > 1) {
                charSequence = new StringBuilder();
                for (int i2 = 1; i2 < stringArray.length; ++i2) {
                    ((StringBuilder)charSequence).append(stringArray[i2]);
                    ((StringBuilder)charSequence).append("/");
                }
                azureRequestParameters.parameters.put("prefix", ((StringBuilder)charSequence).toString());
            }
            charSequence = this.getURL(string3, null, azureRequestParameters);
            Util_Logger.debug(logger, "Polling directory: " + (String)charSequence);
            httpURLConnection = this.getHttpURLConnection((String)charSequence, azureRequestParameters);
            httpURLConnection.connect();
            if (httpURLConnection.getResponseCode() == 200) {
                if (!httpURLConnection.getContentType().toLowerCase().startsWith("application/xml")) throw new Exception("Invalid response type " + httpURLConnection.getContentType() + " detected in listFiles");
                AzureDirectoryWrapper azureDirectoryWrapper = new AzureDirectoryWrapper();
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(httpURLConnection.getInputStream());
                XStream xStream = XmlUtilities.getConverter();
                xStream.alias("EnumerationResults", AzureDirectoryWrapper.class);
                xStream.alias("BlobPrefix", AzureBlob.class);
                xStream.processAnnotations(AzureDirectoryWrapper.class);
                xStream.processAnnotations(AzureBlob.class);
                xStream.processAnnotations(AzureBlobProperties.class);
                xStream.registerConverter((Converter)new xStreamDateConverter(AZURE_DATE_FOMAT));
                xStream.unmarshal((HierarchicalStreamReader)new DomReader(document), (Object)azureDirectoryWrapper);
                if (azureDirectoryWrapper.Blobs != null) {
                    for (AzureBlob azureBlob : azureDirectoryWrapper.Blobs) {
                        fsFileInfo fsFileInfo2;
                        String string4;
                        if (azureBlob.Name.endsWith("/")) {
                            string4 = azureBlob.Name.substring(0, azureBlob.Name.length() - 1);
                            if (string4.lastIndexOf("/") > 0) {
                                string4 = string4.substring(string4.lastIndexOf("/") + 1);
                            }
                            fsFileInfo2 = new fsFileInfo();
                            fsFileInfo2.setFilename(string4);
                            fsFileInfo2.setDirectory(string);
                            fsFileInfo2.setFileType(fsFileTypeEnum.DIRECTORY);
                            if (fsConnectionFileFilterInt2 == null) {
                                hashMap.put(string4, fsFileInfo2);
                                continue;
                            }
                            if (!fsConnectionFileFilterInt2.accept(fsFileInfo2)) continue;
                            hashMap.put(string4, fsFileInfo2);
                            continue;
                        }
                        string4 = azureBlob.Name;
                        if (azureBlob.Name.lastIndexOf("/") > 0) {
                            string4 = azureBlob.Name.substring(azureBlob.Name.lastIndexOf("/") + 1);
                        }
                        fsFileInfo2 = new fsFileInfo();
                        fsFileInfo2.setFilename(string4);
                        fsFileInfo2.setDirectory(string);
                        fsFileInfo2.setFileType(fsFileTypeEnum.FILE);
                        fsFileInfo2.setModifiedDate(azureBlob.Properties.LastModified, true);
                        fsFileInfo2.setSize(azureBlob.Properties.ContentLength);
                        if (fsConnectionFileFilterInt2 == null) {
                            hashMap.put(string4, fsFileInfo2);
                            continue;
                        }
                        if (!fsConnectionFileFilterInt2.accept(fsFileInfo2)) continue;
                        hashMap.put(string4, fsFileInfo2);
                    }
                }
            } else {
                String string5 = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream())).lines().collect(Collectors.joining("\n"));
                throw new Exception("Detected error in Azure List Blob operation, return code = " + httpURLConnection.getResponseCode() + ", Message=" + string5);
            }
            Util_Logger.debug(logger, "Detected " + hashMap.size() + " files");
            return hashMap;
        }
        catch (Exception exception) {
            try {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Util_Logger.error(logger, "Error listing directory " + string + " from Azure: " + exception.getMessage(), exception);
        }
        return hashMap;
    }

    private String getURL(String string, String string2, AzureRequestParameters azureRequestParameters) throws Exception {
        StringBuilder stringBuilder = new StringBuilder(this.itsBaseURL + "/" + string);
        if (!Util.isBlank(string2) && !string.endsWith(string2)) {
            stringBuilder.append("/" + string2);
        }
        String string3 = "?";
        if (!Util.isBlank(this.itsAPISASToken)) {
            stringBuilder.append(string3);
            stringBuilder.append(this.itsAPISASToken);
            string3 = "&";
        }
        if (azureRequestParameters != null) {
            for (Map.Entry<String, String> entry : azureRequestParameters.parameters.entrySet()) {
                stringBuilder.append(string3);
                stringBuilder.append(entry.getKey());
                stringBuilder.append("=");
                stringBuilder.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
                string3 = "&";
            }
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public fsFileInfo getFile(fsFileInfo fsFileInfo2, String string) throws Exception {
        fsFileInfo fsFileInfo3 = null;
        HttpURLConnection httpURLConnection = null;
        File file = null;
        try {
            AzureRequestParameters azureRequestParameters = new AzureRequestParameters();
            azureRequestParameters.method = "GET";
            azureRequestParameters.resource = "/" + this.itsAccount + "/" + fsFileInfo2.getDirectory() + "/" + fsFileInfo2.getFilename();
            String string2 = this.getURL(fsFileInfo2.getDirectory(), fsFileInfo2.getFilename(), null);
            Util_Logger.debug(logger, "Downloading blob: " + string2);
            httpURLConnection = this.getHttpURLConnection(string2, azureRequestParameters);
            httpURLConnection.connect();
            if (httpURLConnection.getResponseCode() != 200) {
                String string3 = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream())).lines().collect(Collectors.joining("\n"));
                throw new Exception("Detected error in Azure Get Blob operation, return code = " + httpURLConnection.getResponseCode() + ", Message=" + string3);
            }
            try (InputStream inputStream = httpURLConnection.getInputStream();){
                file = new File(string + "/" + fsFileInfo2.getFilename());
                Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                if (fsFileInfo2.getModifiedDate() != null && !file.setLastModified(fsFileInfo2.getModifiedDate().getTime())) {
                    Util_Logger.warning(logger, "Unable to set modified time on file [" + file.getName() + "]");
                }
            }
            fsFileInfo3 = new fsFileInfo(fsFileInfo2);
            fsFileInfo3.setDirectory(string);
            return fsFileInfo3;
        }
        catch (Exception exception) {
            try {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                FileUtilities.deleteFile(file);
            }
            catch (Exception exception3) {
                // empty catch block
            }
            Util_Logger.error(logger, "Error transferring file " + fsFileInfo2.getFilename() + " from Azure blob: " + exception.getMessage(), exception);
        }
        return fsFileInfo3;
    }

    @Override
    public void writeData(String string, String string2, byte[] byArray, Date date, fsFileLockInt fsFileLockInt2) throws Exception {
        HttpURLConnection httpURLConnection = null;
        try {
            if (byArray == null) {
                Util_Logger.info(logger, "No data to write for " + string2 + ", skipping writeData operation");
                return;
            }
            AzureRequestParameters azureRequestParameters = new AzureRequestParameters();
            azureRequestParameters.method = "PUT";
            azureRequestParameters.content_length = Integer.toString(byArray.length);
            azureRequestParameters.resource = "/" + this.itsAccount + "/" + string + "/" + string2;
            azureRequestParameters.headers.put("x-ms-blob-type", "BlockBlob");
            String string3 = this.getURL(string, string2, azureRequestParameters);
            Util_Logger.debug(logger, "Writing blob: " + string3);
            httpURLConnection = this.getHttpURLConnection(string3, azureRequestParameters);
            httpURLConnection.getOutputStream().write(byArray);
            httpURLConnection.connect();
            if (httpURLConnection.getResponseCode() != 201) {
                String string4 = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream())).lines().collect(Collectors.joining("\n"));
                throw new Exception("Detected error in Azure Write Blob operation, return code = " + httpURLConnection.getResponseCode() + ", Message=" + string4);
            }
        }
        catch (Exception exception) {
            try {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Util_Logger.error(logger, "Error writing file " + string2 + " to Azure blob: " + exception.getMessage(), exception);
        }
    }

    @Override
    public void deleteFile(String string, String string2) throws Exception {
        HttpURLConnection httpURLConnection = null;
        try {
            AzureRequestParameters azureRequestParameters = new AzureRequestParameters();
            azureRequestParameters.method = "DELETE";
            azureRequestParameters.resource = "/" + this.itsAccount + "/" + string + "/" + string2;
            String string3 = this.getURL(string, string2, null);
            Util_Logger.debug(logger, "Deleting blob: " + string3);
            httpURLConnection = this.getHttpURLConnection(string3, azureRequestParameters);
            httpURLConnection.connect();
            if (httpURLConnection.getResponseCode() != 202 && httpURLConnection.getResponseCode() != 404) {
                String string4 = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream())).lines().collect(Collectors.joining("\n"));
                throw new Exception("Detected error in Azure Delete Blob operation, return code = " + httpURLConnection.getResponseCode() + ", Message=" + string4);
            }
        }
        catch (Exception exception) {
            try {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Util_Logger.error(logger, "Error deleting file " + string2 + " from Azure blob: " + exception.getMessage(), exception);
        }
    }

    @Override
    public void setBandwidthThrottle(int n2) {
    }

    @Override
    public void setTransferBufferSize(int n2) {
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean exists(String string, String string2) throws Exception {
        boolean bl = false;
        HttpURLConnection httpURLConnection = null;
        try {
            AzureRequestParameters azureRequestParameters = new AzureRequestParameters();
            azureRequestParameters.method = "GET";
            azureRequestParameters.resource = "/" + this.itsAccount + "/" + string + (String)(Util.isBlank(string2) ? "" : "/" + string2);
            azureRequestParameters.parameters.put("comp", "metadata");
            if (Util.isBlank(string2)) {
                azureRequestParameters.parameters.put("restype", "container");
            }
            String string3 = this.getURL(string, string2, azureRequestParameters);
            Util_Logger.debug(logger, "Inspecting blob: " + string3);
            httpURLConnection = this.getHttpURLConnection(string3, azureRequestParameters);
            httpURLConnection.connect();
            if (httpURLConnection.getResponseCode() == 200) {
                bl = true;
            } else if (httpURLConnection.getResponseCode() != 404) {
                throw new Exception("Detected error in Azure exists Blob operation, return code = " + httpURLConnection.getResponseCode());
            }
        }
        catch (Exception exception) {
            try {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Util_Logger.error(logger, "Error checking existance of file " + string2 + " from Azure blob: " + exception.getMessage(), exception);
        }
        return bl;
    }

    @Override
    public boolean exists(fsFileInfo fsFileInfo2) throws Exception {
        return this.exists(fsFileInfo2.getDirectory(), fsFileInfo2.getFilename());
    }

    @Override
    public void renameFile(String string, String string2, String string3, String string4) throws Exception {
        throw new Exception("Azure connection does not support a file rename operation");
    }

    @Override
    public boolean logOperations() {
        return true;
    }

    @Override
    public fsFileLockInt lockFile(fsFileInfo fsFileInfo2) {
        return new fsFileLockNone();
    }
}

