/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FileSystem;

import au.com.aemo.Common.AMQP.AMQPChannelPool;
import au.com.aemo.Common.FileSystem.FilesystemManager;
import au.com.aemo.Common.FileSystem.fsConnectionAMQP;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryBase;
import au.com.aemo.Common.FileSystem.fsConnectionInt;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class fsConnectionFactoryAMQP
extends fsConnectionFactoryBase {
    private static Logger logger = LoggerFactory.getLogger(fsConnectionFactoryAMQP.class);
    private Map<String, AMQPChannelPool> itsPools;

    private fsConnectionFactoryAMQP() {
        super("AMQP");
    }

    public static fsConnectionFactoryAMQP getInstance() {
        return SingletonHolder.instance;
    }

    @Override
    public void start() {
        try {
            this.createAMQPConnectionPool();
            this.setIsRunning(true);
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error establishing AMQP pool: " + exception.getMessage(), exception);
        }
    }

    private void createAMQPConnectionPool() throws Exception {
        this.itsPools = new HashMap<String, AMQPChannelPool>();
        FilesystemManager filesystemManager = FilesystemManager.getInstance();
        for (String string : filesystemManager.getDataSources("AMQP")) {
            AMQPChannelPool aMQPChannelPool = new AMQPChannelPool(filesystemManager.getConfigPrefix(), string, filesystemManager.getConfiguration(), filesystemManager.getAppName() + " v" + filesystemManager.getAppVersion());
            this.itsPools.put(aMQPChannelPool.getId(), aMQPChannelPool);
            Util_Logger.info(logger, "Created AMQP connection pool ID : " + aMQPChannelPool.getId());
        }
    }

    @Override
    public fsConnectionInt getConnection(String string) {
        AMQPChannelPool aMQPChannelPool = this.itsPools.get(Util.noNull(string));
        if (aMQPChannelPool == null) {
            throw new RuntimeException("Unable to borrow AMQP connection from pool ID: " + string);
        }
        return new fsConnectionAMQP(aMQPChannelPool.getChannel(), string, aMQPChannelPool.getPrefetchCount());
    }

    @Override
    public void freeConnection(fsConnectionInt fsConnectionInt2) {
        AMQPChannelPool aMQPChannelPool;
        if (fsConnectionInt2 != null && (aMQPChannelPool = this.itsPools.get(fsConnectionInt2.getDataSourceId())) != null) {
            fsConnectionAMQP fsConnectionAMQP2 = (fsConnectionAMQP)fsConnectionInt2;
            aMQPChannelPool.returnChannel(fsConnectionAMQP2.getChannel());
        }
    }

    @Override
    public void resetPool(String string) {
        AMQPChannelPool aMQPChannelPool;
        if (this.itsPools != null && (aMQPChannelPool = this.itsPools.get(string)) != null) {
            aMQPChannelPool.clearCache();
        }
    }

    @Override
    public void resetPool() {
        if (this.itsPools != null) {
            for (AMQPChannelPool aMQPChannelPool : this.itsPools.values()) {
                aMQPChannelPool.clearCache();
            }
        }
    }

    public List<String> getPoolList() {
        if (this.itsPools == null) {
            return null;
        }
        return new ArrayList<String>(this.itsPools.keySet());
    }

    private static class SingletonHolder {
        private static fsConnectionFactoryAMQP instance = new fsConnectionFactoryAMQP();

        private SingletonHolder() {
        }
    }
}

