/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FileSystem;

import au.com.aemo.Common.FileSystem.fsConnectionBase;
import au.com.aemo.Common.FileSystem.fsConnectionFileFilterInt;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.FileSystem.fsFileLockInt;
import au.com.aemo.Common.FileSystem.fsFileLockNone;
import au.com.aemo.Common.FileSystem.fsProcessStatus;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebClient;
import au.com.aemo.Common.Web.WebClientAuthInt;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebHttpResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.Proxy;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class fsConnectionWebhook
extends fsConnectionBase {
    private static Logger logger = LoggerFactory.getLogger(fsConnectionWebhook.class);
    private String itsDataSourceId;
    private String itsBaseURL;
    private Proxy itsProxy;
    private String itsCurrentDir;
    private int itsTransferBufferSize;
    private int itsTimeoutConnectionSecs;
    private int itsTimeoutTransferSecs;
    private WebClientAuthInt itsAuthProvider;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Class is consumed by trusted code")
    public fsConnectionWebhook(String string, String string2, Proxy proxy, int n2, int n3) {
        super(string);
        this.itsDataSourceId = string;
        this.itsBaseURL = string2;
        this.itsProxy = proxy;
        this.itsTransferBufferSize = 1024;
        this.itsTimeoutConnectionSecs = n2;
        this.itsTimeoutTransferSecs = n3;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Method is consumed by trusted code")
    public void setAuthProvider(WebClientAuthInt webClientAuthInt) {
        this.itsAuthProvider = webClientAuthInt;
    }

    @Override
    public String getDataSourceId() {
        return this.itsDataSourceId;
    }

    @Override
    public boolean supportsFileTimestamps() {
        return false;
    }

    @Override
    public boolean supportsFileMasks() {
        return true;
    }

    @Override
    public fsFileInfo resolveFilenameSpec(String string) throws Exception {
        throw new Exception("Webhook connection does not support a resolveFilenameSpec operation");
    }

    @Override
    public void makeDir(String string) throws Exception {
        throw new Exception("Webhook connection does not support a directory create operation");
    }

    @Override
    public void changeDir(String string) throws Exception {
        this.itsCurrentDir = this.itsBaseURL + "/" + string;
    }

    @Override
    public Map<String, fsFileInfo> listFiles(String string, fsConnectionFileFilterInt fsConnectionFileFilterInt2, String string2) throws Exception {
        throw new Exception("Webhook connection does not support a listFiles operation");
    }

    @Override
    public fsFileInfo getFile(fsFileInfo fsFileInfo2, String string) throws Exception {
        throw new Exception("Webhook connection does not support a get file operation");
    }

    @Override
    public fsProcessStatus putFile(fsFileInfo fsFileInfo2, String string, boolean bl, String string2) throws Exception {
        fsProcessStatus fsProcessStatus2 = new fsProcessStatus();
        try {
            byte[] byArray = Files.readAllBytes(Paths.get(fsFileInfo2.getDirectory(), fsFileInfo2.getFilename()));
            String string3 = fsFileInfo2.getFilename();
            WebContent.MediaType mediaType = this.getMediaType(string3);
            WebClient webClient = new WebClient().setTimeoutConnectionSecs(this.itsTimeoutConnectionSecs).setTimeoutTransferSecs(this.itsTimeoutTransferSecs).setProxy(this.itsProxy);
            webClient.setAuthProvider(this.itsAuthProvider);
            WebHttpResponse webHttpResponse = webClient.doPost(this.itsBaseURL, fsFileInfo2.getAPIHeaderValues(), mediaType, new String(byArray));
            if (webHttpResponse.ReturnCode != 200) {
                throw new Exception("Server rejected post, response code = " + webHttpResponse.ReturnCode + ": " + webHttpResponse.Body);
            }
            Util_Logger.debug(logger, "Successfully sent data from source [" + string3 + "] to webhook " + this.itsBaseURL);
            fsFileInfo fsFileInfo3 = this.writeAckFile(fsFileInfo2, webHttpResponse.Body, string2);
            fsProcessStatus2.setAcknowledgementResponse(webHttpResponse.ReturnCode, fsFileInfo3);
            if (bl) {
                FileUtilities.deleteFile(fsFileInfo2);
            }
            fsProcessStatus2.setProcessSuccess();
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error posting webhook: " + exception.getMessage(), exception);
        }
        return fsProcessStatus2;
    }

    @Override
    public void writeData(String string, String string2, byte[] byArray, Date date, fsFileLockInt fsFileLockInt2) throws Exception {
        throw new Exception("Webhook connection does not support a writeData operation");
    }

    @Override
    public void deleteFile(String string, String string2) throws Exception {
        throw new Exception("Webhook connection does not support a file delete operation");
    }

    @Override
    public void setBandwidthThrottle(int n2) {
    }

    @Override
    public void setTransferBufferSize(int n2) {
        this.itsTransferBufferSize = n2;
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean exists(String string, String string2) {
        return true;
    }

    @Override
    public boolean exists(fsFileInfo fsFileInfo2) throws Exception {
        return this.exists(fsFileInfo2.getDirectory(), fsFileInfo2.getFilename());
    }

    @Override
    public void renameFile(String string, String string2, String string3, String string4) throws Exception {
        throw new Exception("Webhook connection does not support a file rename operation");
    }

    @Override
    public boolean logOperations() {
        return true;
    }

    @Override
    public fsFileLockInt lockFile(fsFileInfo fsFileInfo2) {
        return new fsFileLockNone();
    }
}

