/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FileSystem;

import au.com.aemo.Common.Java.Util;
import java.util.Date;

public class fsDataSource {
    private String Name;
    private String Protocol;
    private Date LastSendActivity;
    private Integer SendInactivityTimeoutSecs;
    private Integer SendInactivityFailoverSecs;
    private String SendInactivityDataSource;
    private Date LastReceiveActivity;
    private Integer ReceiveInactivityTimeoutSecs;
    private Integer ReceiveInactivityFailoverSecs;
    private String ReceiveInactivityDataSource;
    private volatile long TotalFilesSent;
    private volatile long TotalFilesReceived;
    private volatile double TotalKiloBytesSent;
    private volatile double TotalKiloBytesReceived;
    private volatile boolean SendFailOverState;
    private volatile boolean ReceiveFailOverState;
    private int ResetFrequencySecs;
    private Date LastReset;

    public fsDataSource(String string, String string2) {
        this.Name = string;
        this.Protocol = string2;
        this.SendFailOverState = false;
        this.ReceiveFailOverState = false;
    }

    public String getName() {
        return this.Name;
    }

    public String getProtocol() {
        return this.Protocol;
    }

    public Integer getSendInactivityTimeoutSecs() {
        return this.SendInactivityTimeoutSecs;
    }

    public void setSendInactivityTimeoutSecs(Integer n2) {
        this.SendInactivityTimeoutSecs = n2;
    }

    public Integer getReceiveInactivityTimeoutSecs() {
        return this.ReceiveInactivityTimeoutSecs;
    }

    public void setReceiveInactivityTimeoutSecs(Integer n2) {
        this.ReceiveInactivityTimeoutSecs = n2;
    }

    public Date getLastSendActivity() {
        return this.LastSendActivity;
    }

    public synchronized void updateSendActivity(int n2, double d2) {
        this.LastSendActivity = new Date();
        ++this.TotalFilesSent;
        this.TotalKiloBytesSent += d2;
    }

    public Date getLastReceiveActivity() {
        return this.LastReceiveActivity;
    }

    public synchronized void updateReceiveActivity(int n2, double d2) {
        this.LastReceiveActivity = new Date();
        ++this.TotalFilesReceived;
        this.TotalKiloBytesReceived += d2;
    }

    public long getTotalFilesSent() {
        return this.TotalFilesSent;
    }

    public long getTotalFilesReceived() {
        return this.TotalFilesReceived;
    }

    public double getTotalKiloBytesSent() {
        return this.TotalKiloBytesSent;
    }

    public double getTotalKiloBytesReceived() {
        return this.TotalKiloBytesReceived;
    }

    public Integer getSendInactivityFailoverSecs() {
        return this.SendInactivityFailoverSecs;
    }

    public void setSendInactivityFailoverSecs(Integer n2) {
        this.SendInactivityFailoverSecs = n2;
    }

    public Integer getReceiveInactivityFailoverSecs() {
        return this.ReceiveInactivityFailoverSecs;
    }

    public void setReceiveInactivityFailoverSecs(Integer n2) {
        this.ReceiveInactivityFailoverSecs = n2;
    }

    public String getSendInactivityDataSource() {
        return this.SendInactivityDataSource;
    }

    public void setSendInactivityDataSource(String string) {
        this.SendInactivityDataSource = string;
    }

    public String getReceiveInactivityDataSource() {
        return this.ReceiveInactivityDataSource;
    }

    public void setReceiveInactivityDataSource(String string) {
        this.ReceiveInactivityDataSource = string;
    }

    public boolean getReceiveFailOverState() {
        return this.ReceiveFailOverState;
    }

    public void setReceiveFailOverState(boolean bl) {
        this.ReceiveFailOverState = bl;
    }

    public boolean getSendFailOverState() {
        return this.SendFailOverState;
    }

    public void setSendFailOverState(boolean bl) {
        this.SendFailOverState = bl;
    }

    public void setResetFrequencySecs(int n2) {
        this.ResetFrequencySecs = n2;
    }

    public boolean checkSendFailoverTimeout() {
        boolean bl = false;
        if (!Util.isBlank(this.SendInactivityDataSource) && this.SendInactivityFailoverSecs != null) {
            Date date = Util.dateOffset(new Date(), -this.SendInactivityFailoverSecs.intValue(), 13);
            if (this.LastSendActivity != null) {
                bl = this.LastSendActivity.before(date);
            }
        }
        return bl;
    }

    public boolean initiateSendFailover() {
        boolean bl = false;
        if (!this.getSendFailOverState()) {
            bl = this.checkSendFailoverTimeout();
        }
        return bl;
    }

    public boolean checkReceiveFailoverTimeout() {
        boolean bl = false;
        if (!Util.isBlank(this.ReceiveInactivityDataSource) && this.ReceiveInactivityFailoverSecs != null) {
            Date date = Util.dateOffset(new Date(), -this.ReceiveInactivityFailoverSecs.intValue(), 13);
            if (this.LastReceiveActivity != null) {
                bl = this.LastReceiveActivity.before(date);
            }
        }
        return bl;
    }

    public boolean initiateReceiveFailover() {
        boolean bl = false;
        if (!this.getSendFailOverState()) {
            bl = this.checkReceiveFailoverTimeout();
        }
        return bl;
    }

    public boolean resetIsDue() {
        boolean bl = false;
        if (this.LastReset == null) {
            bl = true;
        } else if (this.ResetFrequencySecs <= 0) {
            bl = true;
        } else {
            Date date = Util.dateOffset(this.LastReset, this.ResetFrequencySecs, 13);
            Date date2 = new Date();
            bl = date2.after(date);
        }
        return bl;
    }

    public void wasReset() {
        this.LastReset = new Date();
    }
}

