/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FileSystem;

import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.FileSystem.fsFileLockInt;
import au.com.aemo.Common.Logging.Util_Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class fsFileLockLocal
implements fsFileLockInt {
    private static Logger logger = LoggerFactory.getLogger(fsFileLockLocal.class);
    private RandomAccessFile raf;
    private FileChannel channel;
    private FileLock lock;

    @Override
    public boolean implementsLock() {
        return true;
    }

    public boolean lockFile(File file) {
        boolean bl = false;
        try {
            this.raf = new RandomAccessFile(file, "rwd");
            this.channel = this.raf.getChannel();
            this.lock = this.channel.tryLock();
            if (this.lock != null) {
                bl = this.lock.isValid();
            } else {
                this.channel.close();
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error setting lock file: " + exception.getMessage(), exception);
        }
        return bl;
    }

    @Override
    public boolean lockFile(fsFileInfo fsFileInfo2) {
        boolean bl = false;
        try {
            if (!fsFileInfo2.isDirectory()) {
                File file = new File(fsFileInfo2.getPath());
                bl = this.lockFile(file);
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error setting lock file: " + exception.getMessage(), exception);
        }
        if (bl) {
            fsFileInfo2.setLockData(this);
        }
        return bl;
    }

    @Override
    public boolean isValid() {
        if (this.lock != null) {
            return this.lock.isValid();
        }
        return false;
    }

    @Override
    public void release() {
        try {
            if (this.lock != null) {
                if (this.channel != null) {
                    this.channel.close();
                }
                if (this.lock.isValid()) {
                    this.lock.release();
                }
            }
        }
        catch (IOException iOException) {
            Util_Logger.errorNoRaise(logger, "Error releasing lock file: " + iOException.getMessage(), iOException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="bytes read in size in useful to have")
    public byte[] readLockedFileContents() throws Exception {
        byte[] byArray = null;
        if (this.lock == null) throw new Exception("Unable to read locked file contents when lock is not held");
        if (!this.lock.isValid()) throw new Exception("Unable to read locked file contents when lock is invalid");
        if (this.channel == null) throw new Exception("Unable to read locked file contents when channel is closed");
        this.channel.position(0L);
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)this.channel.size());
        long l2 = this.channel.read(byteBuffer);
        return byteBuffer.array();
    }

    @Override
    public void updateLockedFileContents(byte[] byArray) throws Exception {
        if (this.lock != null) {
            if (!this.lock.isValid()) {
                throw new Exception("Unable to update locked file contents when lock is invalid");
            }
        } else {
            throw new Exception("Unable to update locked file contents when lock is not held");
        }
        this.raf.setLength(0L);
        this.channel.position(0L);
        this.channel.write(ByteBuffer.wrap(byArray));
    }
}

