/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Files;

import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.Logging.Util_Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtilities {
    private static Logger logger = LoggerFactory.getLogger(FileUtilities.class);
    private static final int BYTE_BUFFER_SIZE = 10240;
    private static final int OPERATION_RETRY_ATTEMPTS = 3;
    private static final int OPERATION_RETRY_WAIT = 1000;

    public static boolean deleteRecursive(File file, FilenameFilter filenameFilter) throws FileNotFoundException {
        boolean bl;
        block5: {
            block4: {
                if (!file.exists()) {
                    throw new FileNotFoundException(file.getAbsolutePath());
                }
                bl = true;
                if (!file.isDirectory()) break block4;
                File[] fileArray = file.listFiles(filenameFilter);
                if (fileArray == null) break block5;
                for (File file2 : fileArray) {
                    bl = bl && FileUtilities.deleteRecursive(file2, filenameFilter);
                }
                break block5;
            }
            try {
                FileUtilities.deleteFile(file);
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public static boolean deleteRecursive(String string, FilenameFilter filenameFilter) throws FileNotFoundException {
        return FileUtilities.deleteRecursive(new File(string), filenameFilter);
    }

    public static boolean fileExists(String string) throws IOException {
        Path path = Paths.get(string, new String[0]);
        return Files.exists(path, new LinkOption[0]);
    }

    public static boolean fileExists(File file) throws IOException {
        Path path = Paths.get(file.getPath(), new String[0]);
        return Files.exists(path, new LinkOption[0]);
    }

    public static boolean deleteFile(Path path) throws IOException {
        int n2 = 0;
        boolean bl = true;
        if (Files.exists(path, new LinkOption[0])) {
            bl = false;
            while (!bl && n2 < 3) {
                try {
                    ++n2;
                    bl = Files.deleteIfExists(path);
                    if (bl) continue;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                }
                catch (Exception exception) {
                    if (n2 < 3) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception2) {}
                        continue;
                    }
                    throw exception;
                }
            }
        }
        return bl;
    }

    public static boolean deleteFile(File file) throws IOException {
        if (file != null) {
            Path path = Paths.get(file.getPath(), new String[0]);
            return FileUtilities.deleteFile(path);
        }
        return false;
    }

    public static boolean deleteFile(String string) throws IOException {
        Path path = Paths.get(string, new String[0]);
        return FileUtilities.deleteFile(path);
    }

    public static boolean deleteFile(fsFileInfo fsFileInfo2) throws IOException {
        Path path = Paths.get(fsFileInfo2.getDirectory(), fsFileInfo2.getFilename());
        return FileUtilities.deleteFile(path);
    }

    public static void renameFile(String string, String string2) throws IOException {
        Path path = Paths.get(string, new String[0]);
        Path path2 = Paths.get(string2, new String[0]);
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        int n2 = 0;
        boolean bl = false;
        while (!bl) {
            try {
                ++n2;
                Files.move(path, path2, copyOptionArray);
                bl = true;
            }
            catch (Exception exception) {
                if (n2 < 3) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception2) {}
                    continue;
                }
                throw exception;
            }
        }
    }

    public static void renameFile(File file, File file2) throws IOException {
        FileUtilities.renameFile(file.getPath(), file2.getPath());
    }

    public static void copy(File file, File file2) throws IOException {
        Path path = Paths.get(file.getPath(), new String[0]);
        Path path2 = Paths.get(file2.getPath(), new String[0]);
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES};
        int n2 = 0;
        boolean bl = false;
        while (!bl) {
            try {
                ++n2;
                Files.copy(path, path2, copyOptionArray);
                bl = true;
            }
            catch (Exception exception) {
                if (n2 < 3) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception2) {}
                    continue;
                }
                throw exception;
            }
        }
    }

    public static void copyFileChannels(FileChannel fileChannel, FileChannel fileChannel2) throws IOException {
        long l2;
        long l3 = fileChannel.size();
        for (long i2 = 0L; i2 < l3; i2 += fileChannel2.transferFrom(fileChannel, i2, l2)) {
            l2 = l3 - i2 > 10240L ? 10240L : l3 - i2;
        }
    }

    public static void archiveFile(String string, String string2) throws IOException {
        File file = new File(string);
        File file2 = new File(string2 + File.separator);
        if (file2.mkdirs()) {
            Util_Logger.info(logger, "Created archive folder [" + file2.getPath() + "]");
        }
        File file3 = new File(file2, file.getName());
        FileUtilities.renameFile(file, file3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkFileIsNotLocked(String string) {
        boolean bl = false;
        File file = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        FileLock fileLock = null;
        try {
            file = new File(string);
            abstractInterruptibleChannel = new RandomAccessFile(file, "rw").getChannel();
            fileLock = ((FileChannel)abstractInterruptibleChannel).tryLock();
            if (fileLock != null) {
                bl = true;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (fileLock != null && fileLock.isValid()) {
                    fileLock.release();
                }
                if (abstractInterruptibleChannel != null) {
                    abstractInterruptibleChannel.close();
                }
                file = null;
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    public static synchronized void touch(File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            if (fileOutputStream != null) {
                ((OutputStream)fileOutputStream).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void copyFolder(final Path path, final Path path2, final CopyOption ... copyOptionArray) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path path3, BasicFileAttributes basicFileAttributes) throws IOException {
                Files.createDirectories(path2.resolve(path.relativize(path3).toString()), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path path3, BasicFileAttributes basicFileAttributes) throws IOException {
                Files.copy(path3, path2.resolve(path.relativize(path3).toString()), copyOptionArray);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

