/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Web;

import au.com.aemo.Common.Authentication.AuthenticationManager;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebExecutionParams;
import au.com.aemo.Common.Web.WebHandlerAPIWrapper;
import au.com.aemo.Common.Web.WebHandlerAPIWrapperMethod;
import au.com.aemo.Common.Web.WebHandlerBase;
import au.com.aemo.Common.Web.WebHelper;
import au.com.aemo.Common.Web.WebParamException;
import au.com.aemo.Common.Web.WebParamValidationConfig;
import au.com.aemo.Common.Web.WebParameterHelper;
import au.com.aemo.Common.Web.WebSecurityAuthenticationEnum;
import au.com.aemo.Common.Web.WebServer;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebHandlerAPI
extends WebHandlerBase {
    public static final int MAX_METHOD_PARAMS = 10;
    public static final String POST_BODY = "_body";
    private static Logger logger = LoggerFactory.getLogger(WebHandlerAPI.class);

    private WebAuth getWebAuth(HttpExchange httpExchange) {
        String[] stringArray;
        WebAuth webAuth = new WebAuth();
        String string = httpExchange.getRequestHeaders().getFirst("AUTHORIZATION");
        if (!Util.isBlank(string) && (stringArray = string.split(" ")) != null && stringArray.length == 2) {
            webAuth.AuthMethod = stringArray[0];
            webAuth.AuthDetail = stringArray[1];
        }
        return webAuth;
    }

    private WebRequest resolveRequest(HttpExchange httpExchange, String string) throws Exception {
        WebRequest webRequest = null;
        String string2 = httpExchange.getRequestURI().getPath();
        String string3 = httpExchange.getRequestMethod();
        String[] stringArray = string2.toString().split("/");
        Util_Logger.info(logger, "Received " + string3 + " request at " + string2 + " from " + httpExchange.getRemoteAddress().getHostString());
        WebServer webServer = WebServer.getInstance();
        Map<String, String> map = WebHelper.queryStringToMap(httpExchange.getRequestURI().getQuery());
        if (!Util.isBlank(string)) {
            map.put(POST_BODY, string);
        }
        for (WebHandlerAPIWrapper webHandlerAPIWrapper : webServer.itsHandlers.values()) {
            List<WebHandlerAPIWrapperMethod> list = webHandlerAPIWrapper.getMethods(string3);
            if (list == null) continue;
            for (WebHandlerAPIWrapperMethod webHandlerAPIWrapperMethod : list) {
                int n2;
                Util_Logger.debug(logger, "Checking signature for method [" + webHandlerAPIWrapperMethod.method.getName() + "] with path [" + webHandlerAPIWrapperMethod.getPath() + "]");
                WebExecutionParams webExecutionParams = webHandlerAPIWrapperMethod.matches(stringArray, map);
                if (!webExecutionParams.Matches) continue;
                Util_Logger.debug(logger, "Detected method [" + webHandlerAPIWrapperMethod.method.getName() + "] matches API request");
                if (webRequest == null) {
                    webRequest = new WebRequest();
                    webRequest.exec = webHandlerAPIWrapperMethod;
                    webRequest.wrapper = webHandlerAPIWrapper;
                    webRequest.execParams = webExecutionParams;
                    continue;
                }
                if (webHandlerAPIWrapperMethod.URIParts.length > webRequest.exec.URIParts.length) {
                    webRequest.exec = webHandlerAPIWrapperMethod;
                    webRequest.wrapper = webHandlerAPIWrapper;
                    webRequest.execParams = webExecutionParams;
                    continue;
                }
                if (webHandlerAPIWrapperMethod.URIParts.length != webRequest.exec.URIParts.length) continue;
                int n3 = webHandlerAPIWrapperMethod.getNonParameterURICountMatch(stringArray);
                if (n3 > (n2 = webRequest.exec.getNonParameterURICountMatch(stringArray))) {
                    webRequest.exec = webHandlerAPIWrapperMethod;
                    webRequest.wrapper = webHandlerAPIWrapper;
                    webRequest.execParams = webExecutionParams;
                    continue;
                }
                if (n3 != n2) continue;
                throw new IOException("Detected duplicated web service API specification for path [" + string2 + "] in handlers [" + webHandlerAPIWrapper.Handler.getName() + "." + webHandlerAPIWrapperMethod.method.getName() + " , " + webRequest.wrapper.Handler.getName() + "." + webRequest.exec.method.getName() + "]");
            }
        }
        if (webRequest == null) {
            Util_Logger.warning(logger, "Detected API request on URI [" + string2 + "] with no matching handler, aborting request");
        } else {
            Util_Logger.debug(logger, "Resolved request on URI [" + string2 + "] to handler [" + webRequest.wrapper.Handler.getName() + "." + webRequest.exec.method.getName() + " with " + webRequest.exec.methodParams.size() + " parameters]");
        }
        return webRequest;
    }

    private boolean validateRequest(HttpExchange httpExchange, String string, WebRequest webRequest) {
        boolean bl;
        block17: {
            bl = false;
            try {
                if (webRequest.exec.auth == WebSecurityAuthenticationEnum.PUBLIC) {
                    bl = true;
                    break block17;
                }
                WebAuth webAuth = this.getWebAuth(httpExchange);
                String string2 = WebServer.getInstance().getConfig().API_KEY;
                AuthenticationManager authenticationManager = AuthenticationManager.getInstance();
                if (!authenticationManager.isEnabled() && Util.isBlank(string2)) {
                    bl = true;
                    break block17;
                }
                if (Util.isBlank(webAuth.AuthDetail)) {
                    throw new Exception("Missing authentication detail in request header");
                }
                if (Util.isBlank(webAuth.AuthMethod)) {
                    throw new Exception("Missing authentication type in request header");
                }
                if (webAuth.AuthMethod.equalsIgnoreCase("BEARER")) {
                    bl = false;
                    if (authenticationManager.validateToken(webAuth.AuthDetail)) {
                        String string3 = null;
                        if (Util.isBlank(webRequest.exec.AuthContext)) {
                            bl = webRequest.exec.AdminAccessOnly ? authenticationManager.checkAuthorisation(webAuth.AuthDetail, httpExchange.getRequestURI().toString(), webRequest.exec.AdminAccessOnly, string3, webRequest.exec.action) : true;
                        } else {
                            String string4;
                            String[] stringArray;
                            if (!webRequest.exec.AdminAccessOnly && Util.isBlank(string3 = webRequest.exec.getAuthContextURLParameter(stringArray = (string4 = httpExchange.getRequestURI().getPath()).toString().split("/")))) {
                                Util_Logger.errorNoRaise(logger, "Unable to identify secuity context parameter [" + webRequest.exec.AuthContext + "] from web handler " + webRequest.wrapper.Handler.toString());
                                throw new Exception("Internal system error");
                            }
                            bl = authenticationManager.checkAuthorisation(webAuth.AuthDetail, httpExchange.getRequestURI().toString(), webRequest.exec.AdminAccessOnly, string3, webRequest.exec.action);
                        }
                    }
                    break block17;
                }
                if (webAuth.AuthMethod.equalsIgnoreCase("HMAC")) {
                    Date date;
                    long l2;
                    Mac mac = Mac.getInstance("HmacSHA256");
                    SecretKeySpec secretKeySpec = new SecretKeySpec(string2.getBytes(), "HmacSHA256");
                    mac.init(secretKeySpec);
                    long l3 = -1L;
                    String string5 = httpExchange.getRequestHeaders().getFirst("X-TIMESTAMP");
                    if (Util.isBlank(string5)) {
                        throw new Exception("Missing request header X-TIMESTAMP");
                    }
                    if (!Util.isInteger(string5)) {
                        throw new Exception("Invalid request header value for X-TIMESTAMP");
                    }
                    l3 = Long.parseLong(string5);
                    String string6 = webAuth.AuthDetail;
                    if (Util.isBlank(string5)) {
                        throw new Exception("Missing request header X-TIMESTAMP");
                    }
                    String string7 = WebServer.getInstance().getConfig().getHttpProtocol() ? "http" : "https";
                    URL uRL = new URL(string7 + "://" + httpExchange.getRequestHeaders().getFirst("Host") + String.valueOf(httpExchange.getRequestURI()));
                    String string8 = WebHelper.signRequest(string2, uRL, string, l3);
                    if (!string6.equals(string8)) {
                        throw new Exception("Invalid request signature");
                    }
                    Integer n2 = WebServer.getInstance().getConfig().TimeDriftToleranceSeconds;
                    if (n2 != null && (l2 = Math.abs((l3 - (date = new Date()).getTime()) / 1000L)) > (long)n2.intValue()) {
                        throw new Exception("Invalid timestamp exceeds drift threshold of " + n2.toString() + " seconds");
                    }
                    bl = true;
                    break block17;
                }
                throw new Exception("Unknown authentication type [" + webAuth.AuthMethod + "] in request header");
            }
            catch (Exception exception) {
                bl = false;
                Util_Logger.warning(logger, "Error validating web request: " + exception.getMessage(), exception);
            }
        }
        return bl;
    }

    @Override
    public void processRequest(HttpExchange httpExchange, String string) {
        int n2 = 503;
        Object object = "Internal server error";
        String string2 = WebContent.MediaType.TEXT_PLAIN.toString();
        WebRequest webRequest = null;
        String string3 = httpExchange.getRequestMethod();
        String string4 = httpExchange.getRequestURI().getPath();
        boolean bl = false;
        try {
            webRequest = this.resolveRequest(httpExchange, string);
            bl = true;
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error resolving URL request: " + exception.getMessage(), exception);
        }
        if (bl) {
            if (webRequest == null) {
                n2 = 404;
                string2 = WebContent.MediaType.TEXT_PLAIN.toString();
                object = "Invalid URL for " + string3 + " at " + string4;
                Util_Logger.errorNoRaise(logger, (String)object + " requested by " + httpExchange.getRemoteAddress().getHostString());
            } else {
                boolean bl2 = this.validateRequest(httpExchange, string, webRequest);
                if (!bl2) {
                    n2 = 403;
                    string2 = WebContent.MediaType.TEXT_PLAIN.toString();
                    object = "403 (Forbidden)";
                } else {
                    try {
                        Object object2;
                        Map<String, String> map = WebHelper.queryStringToMap(httpExchange.getRequestURI().getQuery());
                        Object t2 = webRequest.wrapper.Handler.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        if (webRequest.wrapper.fieldURL != null) {
                            webRequest.wrapper.fieldURL.setAccessible(true);
                            webRequest.wrapper.fieldURL.set(t2, string4);
                        }
                        if (webRequest.wrapper.fieldParams != null) {
                            webRequest.wrapper.fieldParams.setAccessible(true);
                            webRequest.wrapper.fieldParams.set(t2, map);
                        }
                        if (webRequest.wrapper.fieldUUID != null) {
                            object2 = httpExchange.getRequestHeaders().getFirst("X-UUID");
                            webRequest.wrapper.fieldUUID.setAccessible(true);
                            webRequest.wrapper.fieldUUID.set(t2, object2);
                        }
                        if (webRequest.wrapper.fieldSessionKey != null) {
                            object2 = this.getWebAuth(httpExchange);
                            webRequest.wrapper.fieldSessionKey.setAccessible(true);
                            webRequest.wrapper.fieldSessionKey.set(t2, ((WebAuth)object2).AuthDetail);
                        }
                        string2 = webRequest.exec.contentType;
                        if (webRequest.getNoParams() == 0) {
                            object = (String)webRequest.exec.method.invoke(t2, new Object[0]);
                        } else if (webRequest.getNoParams() == 1) {
                            object = (String)webRequest.exec.method.invoke(t2, webRequest.getParam(0));
                        } else if (webRequest.getNoParams() == 2) {
                            object = (String)webRequest.exec.method.invoke(t2, webRequest.getParam(0), webRequest.getParam(1));
                        } else if (webRequest.getNoParams() == 3) {
                            object = (String)webRequest.exec.method.invoke(t2, webRequest.getParam(0), webRequest.getParam(1), webRequest.getParam(2));
                        } else if (webRequest.getNoParams() == 4) {
                            object = (String)webRequest.exec.method.invoke(t2, webRequest.getParam(0), webRequest.getParam(1), webRequest.getParam(2), webRequest.getParam(3));
                        } else if (webRequest.getNoParams() == 5) {
                            object = (String)webRequest.exec.method.invoke(t2, webRequest.getParam(0), webRequest.getParam(1), webRequest.getParam(2), webRequest.getParam(3), webRequest.getParam(4));
                        } else if (webRequest.getNoParams() == 6) {
                            object = (String)webRequest.exec.method.invoke(t2, webRequest.getParam(0), webRequest.getParam(1), webRequest.getParam(2), webRequest.getParam(3), webRequest.getParam(4), webRequest.getParam(5));
                        } else if (webRequest.getNoParams() == 7) {
                            object = (String)webRequest.exec.method.invoke(t2, webRequest.getParam(0), webRequest.getParam(1), webRequest.getParam(2), webRequest.getParam(3), webRequest.getParam(4), webRequest.getParam(5), webRequest.getParam(6));
                        } else if (webRequest.getNoParams() == 8) {
                            object = (String)webRequest.exec.method.invoke(t2, webRequest.getParam(0), webRequest.getParam(1), webRequest.getParam(2), webRequest.getParam(3), webRequest.getParam(4), webRequest.getParam(5), webRequest.getParam(6), webRequest.getParam(7));
                        } else if (webRequest.getNoParams() == 9) {
                            object = (String)webRequest.exec.method.invoke(t2, webRequest.getParam(0), webRequest.getParam(1), webRequest.getParam(2), webRequest.getParam(3), webRequest.getParam(4), webRequest.getParam(5), webRequest.getParam(6), webRequest.getParam(7), webRequest.getParam(8));
                        } else if (webRequest.getNoParams() == 10) {
                            object = (String)webRequest.exec.method.invoke(t2, webRequest.getParam(0), webRequest.getParam(1), webRequest.getParam(2), webRequest.getParam(3), webRequest.getParam(4), webRequest.getParam(5), webRequest.getParam(6), webRequest.getParam(7), webRequest.getParam(8), webRequest.getParam(9));
                        } else {
                            throw new Exception("Internal error, unable to invoke handler with > 10 arguments");
                        }
                        n2 = 200;
                    }
                    catch (WebParamException webParamException) {
                        Util_Logger.info(logger, "Unable to process request in handler " + webRequest.wrapper.getClass().getName() + ": " + webParamException.getMessage());
                        string2 = WebContent.MediaType.TEXT_PLAIN.toString();
                        object = "Unable to process request: " + webParamException.getMessage();
                        n2 = 400;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Util_Logger.errorNoRaise(logger, "Error in Web Handler: " + invocationTargetException.getCause().getMessage(), new Exception(invocationTargetException.getCause()));
                        string2 = WebContent.MediaType.TEXT_PLAIN.toString();
                        String string5 = "Error processing request: ";
                        String string6 = invocationTargetException.getCause().getMessage();
                        object = string6.startsWith(string5) ? string6 : string5 + string6;
                    }
                    catch (Exception exception) {
                        Util_Logger.errorNoRaise(logger, "Error in Web Handler: " + exception.getMessage(), exception);
                        string2 = WebContent.MediaType.TEXT_PLAIN.toString();
                        object = "Internal server error: " + exception.getMessage();
                        n2 = 503;
                    }
                }
            }
        }
        try {
            Headers headers = httpExchange.getResponseHeaders();
            if (!Util.isBlank(string2)) {
                headers.add("Content-Type", string2.replace('_', '/'));
            }
            if (object == null) {
                object = "";
            }
            this.outputResponse(httpExchange, headers, n2, (String)object);
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error writing HTTP response: " + exception.getMessage(), exception);
        }
    }

    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC"}, justification="Cannot be a static class")
    private class WebAuth {
        public String AuthMethod;
        public String AuthDetail;

        private WebAuth() {
        }
    }

    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC"}, justification="Cannot be a static class")
    private class WebRequest {
        public WebHandlerAPIWrapper wrapper = null;
        public WebExecutionParams execParams = null;
        public WebHandlerAPIWrapperMethod exec = null;

        private WebRequest() {
        }

        public Object getParam(int n2) throws WebParamException, IllegalArgumentException {
            Object object = null;
            Util_Logger.debug(logger, "Resolving parameter [" + n2 + "]");
            WebParamValidationConfig webParamValidationConfig = this.exec.methodParams.get(n2);
            String string = Util.isBlank(this.execParams.Params.get(webParamValidationConfig.getSource()), webParamValidationConfig.getDefaultValue());
            Util_Logger.debug(logger, "Raw value of [" + webParamValidationConfig.getSource() + "] is [" + string + "]");
            if (string != null) {
                object = WebParameterHelper.validateParam(string, webParamValidationConfig);
            } else if (webParamValidationConfig.isMandatory()) {
                throw new IllegalArgumentException("Missing mandatory parameter [" + webParamValidationConfig.getSource() + "], aborting request");
            }
            return object;
        }

        public int getNoParams() {
            return this.exec.methodParams.size();
        }
    }
}

