/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Web;

import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Web.WebParamException;
import au.com.aemo.Common.Web.WebParamValidationConfig;
import au.com.aemo.Common.Web.WebParamValidationEnum;
import au.com.aemo.Common.Web.WebParamValidatorTypeInt;
import java.util.Arrays;
import java.util.List;

public class WebParamValidatorTypeInteger
implements WebParamValidatorTypeInt {
    @Override
    public List<String> getTypes() {
        return Arrays.asList("int", "java.lang.Integer");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object validate(String string, WebParamValidationConfig webParamValidationConfig) throws WebParamException {
        Integer n2 = null;
        if (!Util.isInteger(string)) throw new WebParamException("Invalid parameter [" + webParamValidationConfig.getName() + "] with value [" + string + "], aborting request");
        n2 = Integer.valueOf(string);
        if (webParamValidationConfig.getValidatorParam() != WebParamValidationEnum.POSITIVE) throw new IllegalArgumentException("Unsupported validator [" + webParamValidationConfig.getValidatorParam().name() + "] for integer parameter [" + string + "], aborting request");
        if (n2 > 0) return n2;
        throw new WebParamException("Invalid parameter [" + webParamValidationConfig.getName() + "] with value [" + string + "] must be > 0, aborting request");
    }

    public boolean returnsCustomType() {
        return false;
    }
}

