/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Web;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.Authentication.AuthenticationManager;
import au.com.aemo.Common.Authentication.KeyListenerInt;
import au.com.aemo.Common.Authentication.KeyManager;
import au.com.aemo.Common.Authentication.KeyTypeEnum;
import au.com.aemo.Common.Certificate.CertificateManager;
import au.com.aemo.Common.Certificate.CertificateUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebAccessEnum;
import au.com.aemo.Common.Web.WebGET;
import au.com.aemo.Common.Web.WebHandlerAPI;
import au.com.aemo.Common.Web.WebHandlerAPIWrapper;
import au.com.aemo.Common.Web.WebHandlerAPIWrapperMethod;
import au.com.aemo.Common.Web.WebHandlerDocument;
import au.com.aemo.Common.Web.WebPOST;
import au.com.aemo.Common.Web.WebServerConfig;
import au.com.aemo.Common.Web.WebServerConfigIPAddress;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServer
implements KeyListenerInt {
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String HTTP_HEADER_TIMESTAMP = "X-TIMESTAMP";
    public static final String HTTP_HEADER_AUTHORIZATION = "AUTHORIZATION";
    public static final String HTTP_HEADER_UUID = "X-UUID";
    public static final String HTTP_HEADER_SIGNATURE = "X-SIGNATURE";
    private static Logger logger = LoggerFactory.getLogger(WebServer.class);
    private HttpServer server;
    public Map<String, WebHandlerAPIWrapper> itsHandlers = new HashMap<String, WebHandlerAPIWrapper>();
    private boolean itsIsEnabled = false;
    private WebServerConfig itsConfig;

    private WebServer() {
    }

    public static WebServer getInstance() {
        return SingletonHolder.instance;
    }

    @Override
    public KeyTypeEnum getKeyType() {
        return KeyTypeEnum.HMAC;
    }

    @Override
    public void updatedKey(String string, Date date) throws ApplicationException {
        if (this.itsConfig != null && this.itsConfig.EnableAuthentication.booleanValue()) {
            this.itsConfig.API_KEY = string;
            this.itsConfig.keyFileLastModifiedDate = date;
            Util_Logger.info(logger, "Detected new HMAC key");
        }
    }

    private String getPathSummary(WebHandlerAPIWrapper webHandlerAPIWrapper, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        List<WebHandlerAPIWrapperMethod> list = webHandlerAPIWrapper.getMethods(string);
        if (list != null) {
            for (WebHandlerAPIWrapperMethod webHandlerAPIWrapperMethod : list) {
                if (stringBuilder.length() == 0) {
                    stringBuilder.append("    ");
                    stringBuilder.append(string);
                    stringBuilder.append(" : ");
                } else {
                    stringBuilder.append(" , ");
                }
                stringBuilder.append(webHandlerAPIWrapperMethod.getPath());
            }
        }
        return stringBuilder.toString();
    }

    public void addHandler(Class clazz) {
        if (!this.itsHandlers.containsKey(clazz.getName())) {
            String string;
            WebHandlerAPIWrapper webHandlerAPIWrapper = new WebHandlerAPIWrapper(clazz);
            this.itsHandlers.put(clazz.getName(), webHandlerAPIWrapper);
            Util_Logger.debug(logger, "Registered Web Server API handler " + clazz.getName());
            String string2 = this.getPathSummary(webHandlerAPIWrapper, GET);
            if (!Util.isBlank(string2)) {
                Util_Logger.debug(logger, string2);
            }
            if (!Util.isBlank(string = this.getPathSummary(webHandlerAPIWrapper, POST))) {
                Util_Logger.debug(logger, string);
            }
        }
    }

    public void addHandlersFromPackage(String string) {
        try {
            Util_Logger.info(logger, "Scanning classes from " + string + " to auto-detect web handlers");
            try (ScanResult scanResult = new ClassGraph().verbose(false).enableAllInfo().acceptPackages(new String[]{string}).scan();){
                for (ClassInfo classInfo : scanResult.getClassesWithMethodAnnotation(WebGET.class.getName())) {
                    try {
                        this.addHandler(Class.forName(classInfo.getName()));
                    }
                    catch (Exception exception) {
                        Util_Logger.errorNoRaise(logger, "Error registering web handler " + classInfo.getName() + ": " + exception.getMessage(), exception);
                    }
                }
                for (ClassInfo classInfo : scanResult.getClassesWithMethodAnnotation(WebPOST.class.getName())) {
                    try {
                        this.addHandler(Class.forName(classInfo.getName()));
                    }
                    catch (Exception exception) {
                        Util_Logger.errorNoRaise(logger, "Error registering web handler " + classInfo.getName() + ": " + exception.getMessage(), exception);
                    }
                }
            }
            Util_Logger.info(logger, "Completed auto detection of web handlers, " + this.itsHandlers.size() + " web handlers registered");
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error auto-detecting web handlers: " + exception.getMessage(), exception);
        }
    }

    public List<WebHandlerAPIWrapper> getHandlers() {
        return new ArrayList<WebHandlerAPIWrapper>(this.itsHandlers.values());
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Configuration is consumed by trusted code")
    public WebServerConfig getConfig() {
        return this.itsConfig;
    }

    public static WebServerConfig loadConfigFromProperties(Properties properties) {
        Object object;
        Object object2;
        String string;
        WebServerConfig webServerConfig = new WebServerConfig();
        webServerConfig.HTTPS = CertificateManager.loadConfigFromProperties(properties, "web_server");
        String string2 = Util.getProperty(properties, "web_server_port", null);
        if (Util.isInteger(string2)) {
            webServerConfig.Port = Integer.parseInt(string2);
        } else {
            Util_Logger.warning(logger, "Missing or invalid parameter web_server_port for API access web server");
        }
        webServerConfig.EnableAuthentication = Util.getProperty(properties, "web_server_enable_authentication", "true").equalsIgnoreCase("true");
        webServerConfig.WWW_Root = Util.getProperty(properties, "web_server_root_dir", null);
        webServerConfig.WWW_Index = Util.getProperty(properties, "web_server_index_file", null);
        webServerConfig.WebDocumentEnableCache = Util.getProperty(properties, "web_server_enable_cache", "true").equalsIgnoreCase("true");
        webServerConfig.WebDocumentEnableSSI = Util.getProperty(properties, "web_server_enable_SSI", "true").equalsIgnoreCase("true");
        webServerConfig.WebServiceCatalogEnable = Util.getProperty(properties, "web_server_enable_catalog", "true").equalsIgnoreCase("true");
        String string3 = Util.getProperty(properties, "web_server_no_threads", "5");
        if (Util.isInteger(string3)) {
            webServerConfig.NoThreads = Integer.valueOf(string3);
        } else {
            Util_Logger.warning(logger, "Missing or invalid parameter web_server_no_threads for API access web server");
        }
        webServerConfig.ResponseHeaders = Util.getProperty(properties, "web_server_response_headers", null);
        String string4 = Util.getProperty(properties, "web_server_time_drift_tolerance_seconds", "60");
        if (Util.isInteger(string4)) {
            webServerConfig.TimeDriftToleranceSeconds = Integer.valueOf(string4);
        }
        if (!Util.isBlank(string = Util.getProperty(properties, "web_server_host_allow", null)) && (object2 = string.split(",")) != null) {
            object = object2;
            int n2 = ((String[])object).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object3 = object[i2];
                if (Util.isBlank((String)object3)) continue;
                Object object4 = new WebServerConfigIPAddress();
                ((WebServerConfigIPAddress)object4).Address = object3;
                ((WebServerConfigIPAddress)object4).Access = WebAccessEnum.ALLOW;
                webServerConfig.Hosts.add((WebServerConfigIPAddress)object4);
            }
        }
        if (!Util.isBlank((String)(object2 = Util.getProperty(properties, "web_server_host_deny", null))) && (object = ((String)object2).split(",")) != null) {
            for (Object object4 : object) {
                if (Util.isBlank((String)object4)) continue;
                WebServerConfigIPAddress webServerConfigIPAddress = new WebServerConfigIPAddress();
                webServerConfigIPAddress.Address = object4;
                webServerConfigIPAddress.Access = WebAccessEnum.DENY;
                webServerConfig.Hosts.add(webServerConfigIPAddress);
            }
        }
        return webServerConfig;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Method is consumed by trusted code")
    public void init(WebServerConfig webServerConfig) throws IOException {
        if (webServerConfig != null) {
            if (webServerConfig.Port > 0) {
                this.itsConfig = webServerConfig;
                this.itsIsEnabled = true;
            }
            if (!Util.isBlank(webServerConfig.WWW_Root)) {
                webServerConfig.WWW_Root = new File(webServerConfig.WWW_Root).getCanonicalFile().getPath();
            }
        }
    }

    public void start() throws ApplicationException {
        try {
            if (this.itsIsEnabled) {
                Object object;
                Object object2;
                Util_Logger.info(logger, "Starting web server for API access");
                KeyManager.getInstance().addListener(this);
                this.server = null;
                if (this.itsConfig.getHttpProtocol()) {
                    this.server = HttpServer.create(new InetSocketAddress(this.itsConfig.Port), 0);
                } else {
                    object2 = new CertificateUtilities();
                    ((CertificateUtilities)object2).setCertStoreConfig(this.itsConfig.HTTPS);
                    object = ((CertificateUtilities)object2).getSslContext();
                    this.server = HttpsServer.create(new InetSocketAddress(this.itsConfig.Port), 0);
                    ((HttpsServer)this.server).setHttpsConfigurator(new HttpsConfigurator((SSLContext)object){

                        @Override
                        public void configure(HttpsParameters httpsParameters) {
                            try {
                                SSLContext sSLContext = this.getSSLContext();
                                SSLEngine sSLEngine = sSLContext.createSSLEngine();
                                httpsParameters.setNeedClientAuth(false);
                                httpsParameters.setCipherSuites(sSLEngine.getEnabledCipherSuites());
                                httpsParameters.setProtocols(sSLEngine.getEnabledProtocols());
                                SSLParameters sSLParameters = sSLContext.getSupportedSSLParameters();
                                httpsParameters.setSSLParameters(sSLParameters);
                            }
                            catch (Exception exception) {
                                System.out.println("Failed to create HTTPS port");
                            }
                        }
                    });
                }
                this.server.createContext("/api", new WebHandlerAPI());
                this.server.createContext("/", new WebHandlerDocument());
                object2 = Executors.newFixedThreadPool(this.itsConfig.NoThreads, new ThreadFactory(){

                    @Override
                    public Thread newThread(Runnable runnable) {
                        Thread thread = Executors.defaultThreadFactory().newThread(runnable);
                        thread.setDaemon(true);
                        return thread;
                    }
                });
                this.server.setExecutor((Executor)object2);
                this.server.start();
                object = this.itsConfig.getHttpProtocol() ? "http" : "https";
                Util_Logger.info(logger, "Started web server on URI " + (String)object + "://" + this.getHostName() + ":" + this.itsConfig.Port);
                AuthenticationManager authenticationManager = AuthenticationManager.getInstance();
                if (authenticationManager.isEnabled()) {
                    Util_Logger.info(logger, "Web Server access is secured by " + authenticationManager.getProviderId() + " provider");
                } else if (Util.isBlank(this.itsConfig.API_KEY)) {
                    Util_Logger.warning(logger, "Web Server API key is not defined, access is insecure");
                } else {
                    Util_Logger.info(logger, "Web Server API key is [" + this.itsConfig.API_KEY.replaceAll(".", "*") + "]" + (String)(this.itsConfig.keyFileLastModifiedDate != null ? ", Last Modified : " + Util.dateToStr(this.itsConfig.keyFileLastModifiedDate, "dd/MM/yyyy HH:mm:ss") : ""));
                }
                if (!Util.isBlank(this.itsConfig.WWW_Root) && !Util.isBlank(this.itsConfig.WWW_Index)) {
                    Util_Logger.info(logger, "Web browser interfaces available at URL " + (String)object + "://" + this.getHostName() + ":" + this.itsConfig.Port + this.itsConfig.WWW_Index);
                }
            } else {
                Util_Logger.info(logger, "Web server for API access is disabled");
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error starting web server: " + exception.getMessage(), exception);
        }
    }

    public boolean getIsEnabled() {
        return this.itsIsEnabled;
    }

    public void stop() {
        if (this.server != null) {
            Util_Logger.info(logger, "Stopping web server");
            this.server.stop(1);
        }
    }

    private String getHostName() {
        String string = "localhost";
        try {
            string = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public void logCertificates() {
        try {
            if (this.itsConfig.HTTPS != null) {
                CertificateUtilities certificateUtilities = new CertificateUtilities();
                certificateUtilities.setCertStoreConfig(this.itsConfig.HTTPS);
                certificateUtilities.logCertificates("Web Server");
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error listing certificates from keystore [" + String.valueOf(this.itsConfig.HTTPS) + "]: " + exception.getMessage(), exception);
        }
    }

    private static class SingletonHolder {
        private static WebServer instance = new WebServer();

        private SingletonHolder() {
        }
    }
}

