/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.izpack.install;

import au.com.aemo.izpack.install.UIProcessHandlerWithLogging;
import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import java.io.File;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class xmlFileUpdater {
    private static final Logger logger = Logger.getLogger(xmlFileUpdater.class.getName());

    private Document loadFile(String string) throws Exception {
        File file = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            file = new File(string);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(file);
            document.getDocumentElement().normalize();
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList nodeList = (NodeList)xPath.evaluate("//text()[normalize-space()='']", document, XPathConstants.NODESET);
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                Node node = nodeList.item(i2);
                node.getParentNode().removeChild(node);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            file = null;
        }
        return document;
    }

    private void updateDocument(Document document, String string, String string2) throws Exception {
        XPath xPath = XPathFactory.newInstance().newXPath();
        Node node = ((NodeList)xPath.compile(string).evaluate(document, XPathConstants.NODESET)).item(0);
        if (string2 == null) {
            Node node2 = node.getParentNode();
            node2.removeChild(node);
        } else if (string2.length() == 0) {
            Node node3 = node.getParentNode();
            node3.removeChild(node);
        } else {
            node.setNodeValue(string2.trim());
        }
    }

    private void writeFile(Document document, String string) throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(new File(string));
        transformer.transform(dOMSource, streamResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(AbstractUIProcessHandler abstractUIProcessHandler, String[] stringArray) {
        boolean bl = false;
        UIProcessHandlerWithLogging uIProcessHandlerWithLogging = new UIProcessHandlerWithLogging(abstractUIProcessHandler, logger);
        String string = "Unknown";
        try {
            uIProcessHandlerWithLogging.startProcess("XML Updater");
            string = stringArray[0];
            Document document = this.loadFile(string);
            int n2 = (stringArray.length - 1) / 2;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = i2 * 2 + 1;
                String string2 = stringArray[n3];
                String string3 = stringArray[n3 + 1];
                if (string.toLowerCase().endsWith(".xml")) {
                    string3 = stringArray[n3 + 1].replace('\\', '/');
                }
                uIProcessHandlerWithLogging.logOutput("Updating " + string2 + " ...");
                this.updateDocument(document, string2, string3);
            }
            this.writeFile(document, string);
            bl = true;
        }
        catch (Exception exception) {
            uIProcessHandlerWithLogging.logOutput("Error processing updates to " + string + ": " + exception.getMessage(), exception);
        }
        finally {
            uIProcessHandlerWithLogging.finishProcess();
        }
        return bl;
    }

    public static void main(String[] stringArray) throws Exception {
        xmlFileUpdater xmlFileUpdater2 = new xmlFileUpdater();
        xmlFileUpdater2.run(null, stringArray);
    }
}

