/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher;

import au.com.aemo.Common.Authentication.KeyManager;
import au.com.aemo.Common.Certificate.CertificateManager;
import au.com.aemo.Common.Certificate.CertificateStoreConfig;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebClient;
import au.com.aemo.Common.Web.WebClientAuthHMAC;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebHttpResponse;
import au.com.nemmco.Pdr.Batcher.pdrBatcher;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppPdrBatcherAPIExecuteThread {
    private static Logger logger = LoggerFactory.getLogger(AppPdrBatcherAPIExecuteThread.class);

    public static void main(String[] stringArray) throws Exception {
        boolean bl = false;
        try {
            CertificateManager certificateManager;
            CertificateStoreConfig certificateStoreConfig;
            String string;
            Object object;
            Options options = new Options();
            options.addRequiredOption("t", "thread", true, "Thread ID to execute");
            options.addOption("c", "configuration", true, "The properties configuration file");
            options.addOption("h", "host", true, "The host on which the applications is running");
            options.addOption("p", "port", true, "The port on which the applications web services are exposed");
            options.addOption("a", "api", true, "The aPI key to access the applications web services");
            DefaultParser defaultParser = new DefaultParser();
            CommandLine commandLine = null;
            try {
                commandLine = defaultParser.parse(options, stringArray);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                object = new HelpFormatter();
                object.printHelp("AppPdrBatcherAPIExecuteThread", options);
                System.exit(1);
            }
            String string2 = commandLine.getOptionValue("thread");
            if (!Util.isInteger(string2)) {
                throw new Exception("Thread ID Parameter must be an integer");
            }
            object = new Properties();
            String string3 = commandLine.getOptionValue("configuration", pdrBatcher.PROPERTIES_FILE);
            if (!Util.isBlank(string3)) {
                try {
                    object = Util.getPropertiesObject(string3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (Util.isBlank(string = commandLine.getOptionValue("host", "localhost"))) {
                throw new Exception("Host is not defined");
            }
            String string4 = commandLine.getOptionValue("port", Util.getProperty((Properties)object, "web_server_port", null));
            if (Util.isBlank(string4)) {
                throw new Exception("Port is not defined");
            }
            if (!Util.isInteger(string4)) {
                throw new Exception("Port parameter must be an integer");
            }
            KeyManager keyManager = KeyManager.getInstance();
            keyManager.loadKeyConfiguration();
            String string5 = keyManager.getHMACKey();
            string5 = commandLine.getOptionValue("api", string5);
            if (Util.isBlank(string5)) {
                throw new Exception("API key is not defined");
            }
            String string6 = Util.getProperty((Properties)object, "web_server_https_keystore_file", null);
            boolean bl2 = Util.isBlank(string6);
            if (!bl2) {
                certificateStoreConfig = CertificateManager.loadConfigFromProperties((Properties)object, "web_server");
                certificateManager = CertificateManager.getInstance();
                certificateManager.setCertStoreConfig(certificateStoreConfig);
            }
            certificateStoreConfig = null;
            certificateManager = null;
            Integer n2 = null;
            Integer n3 = null;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(bl2 ? "http://" : "https://");
            stringBuilder.append(string);
            stringBuilder.append(":");
            stringBuilder.append(string4);
            stringBuilder.append("/api/app/control");
            String string7 = "action=execute&thread_id=" + string2;
            WebClient webClient = new WebClient().setTimeoutConnectionSecs(n2).setTimeoutTransferSecs(n3).setProxy((String)((Object)certificateStoreConfig), (Integer)((Object)certificateManager)).setUseDefaultSSLContext(false);
            webClient.setAuthProvider(new WebClientAuthHMAC().setAPIKey(string5));
            WebHttpResponse webHttpResponse = webClient.doPost(stringBuilder.toString(), null, WebContent.MediaType.TEXT_PLAIN, string7);
            if (webHttpResponse.ReturnCode != 200) {
                throw new Exception(webHttpResponse.Body);
            }
            bl = true;
            Util_Logger.info(logger, webHttpResponse.Body);
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error calling batcher thread execution API: " + exception.getMessage(), exception);
        }
        System.exit(bl ? 0 : 1);
    }
}

