/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher;

import au.com.aemo.Common.Application.ApplicationManager;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Batcher.AppPdrBatcher;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerConfigTranslator;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationUtil;
import au.com.nemmco.Pdr.Batcher.pdrBatcher;
import java.io.File;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppPdrBatcherTransformTest {
    private static Logger logger = LoggerFactory.getLogger(AppPdrBatcherTransformTest.class);

    private static void outputHelpInfo(Options options) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("AppPdrBatcherTransformTest", options);
        System.err.println("");
        System.err.println("Example 1: Modify column name in first line of a gas INT file and rename the file");
        System.err.println("pdrBatcherTransformTest.bat \"REPLACE -find current_date -replace curr_date -to_line 1|RENAME -name DWGM_{name}.gascsv\" int111_v5_sdpc_1~20210318131932.csv");
        System.err.println("");
        System.err.println("Example 2: Transform a NEMCSV file to JSON");
        System.err.println("pdrBatcherTransformTest.bat NEMCSV_TO_JSON PUBLIC_DISPATCHIS_202008120505_0000000418405314_LEGACY.CSV");
        System.err.println("");
        System.err.println("Please refer to pdrBatcher.properties for documentation of available file translation functions");
    }

    public static void main(String[] stringArray) throws Exception {
        ApplicationManager applicationManager = ApplicationManager.getInstance();
        applicationManager.init(pdrBatcher.PROPERTIES_FILE, "AppPdrBatcherTransformTest", "7.6.1", "batcher", AppPdrBatcher.class, applicationManager.buildStartOptions());
        Options options = new Options();
        options.addRequiredOption("i", "input", true, "The input file to process");
        options.addRequiredOption("t", "translation", true, "Translation specification");
        options.addOption("ds", "data_source", true, "Translation specification");
        DefaultParser defaultParser = new DefaultParser();
        CommandLine commandLine = null;
        try {
            commandLine = defaultParser.parse(options, stringArray);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            AppPdrBatcherTransformTest.outputHelpInfo(options);
            System.exit(1);
        }
        String string = commandLine.getOptionValue("input");
        String string2 = commandLine.getOptionValue("translation");
        String string3 = commandLine.getOptionValue("data_source", null);
        if (Util.isBlank(string)) {
            Util_Logger.errorNoRaise(logger, "Input File not specified");
            AppPdrBatcherTransformTest.outputHelpInfo(options);
            System.exit(1);
        } else if (!FileUtilities.fileExists(string)) {
            Util_Logger.errorNoRaise(logger, "Input File " + string + " not found");
            AppPdrBatcherTransformTest.outputHelpInfo(options);
            System.exit(1);
        }
        if (Util.isBlank(string2)) {
            Util_Logger.errorNoRaise(logger, "Translation not specified");
            AppPdrBatcherTransformTest.outputHelpInfo(options);
            System.exit(1);
        }
        pdrBatcherHandlerConfigTranslator pdrBatcherHandlerConfigTranslator2 = new pdrBatcherHandlerConfigTranslator();
        pdrBatcherHandlerConfigTranslator2.TranslationSpec = pdrFileTranslationUtil.resolveConfig(string2, string3);
        try {
            File file = new File(string);
            fsFileInfo fsFileInfo2 = new fsFileInfo(file);
            Util_Logger.info(logger, "Input file is " + string);
            Util_Logger.info(logger, "Performing translation " + string2);
            List<fsFileInfo> list = pdrFileTranslationUtil.transformSourceFile(fsFileInfo2, pdrBatcherHandlerConfigTranslator2, fsFileInfo2.getDirectory(), 0);
            if (list != null) {
                for (fsFileInfo fsFileInfo3 : list) {
                    Util_Logger.info(logger, "Generated output file " + fsFileInfo3.getPath());
                }
            }
            applicationManager.shutdown();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

