/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.IO;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.FileSystem.FilesystemManager;
import au.com.aemo.Common.FileSystem.fsConnectionInt;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.FileSystem.fsFileLockInt;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Batcher.IO.pdrBatcherDataIOInt;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Only accessed via trusted code")
public class pdrBatcherDataIODefault
implements pdrBatcherDataIOInt {
    private static Logger logger = LoggerFactory.getLogger(pdrBatcherDataIODefault.class);
    private fsFileInfo itsCacheFile;

    @Override
    public String getProtocol() {
        return "DEFAULT";
    }

    @Override
    public fsFileInfo resolveCacheFilename(String string) throws ApplicationException {
        if (this.itsCacheFile == null) {
            try {
                fsConnectionInt fsConnectionInt2 = FilesystemManager.getInstance().getInternalConnection();
                this.itsCacheFile = fsConnectionInt2.resolveFilenameSpec(string);
            }
            catch (Exception exception) {
                Util_Logger.error(logger, "Error resolving cache filename [" + string + "] : " + exception.getMessage(), exception);
            }
        }
        return this.itsCacheFile;
    }

    @Override
    public fsFileLockInt lockCacheFile(fsFileInfo fsFileInfo2) throws ApplicationException {
        fsFileLockInt fsFileLockInt2 = null;
        try {
            fsConnectionInt fsConnectionInt2 = FilesystemManager.getInstance().getInternalConnection();
            if (!fsConnectionInt2.exists(fsFileInfo2)) {
                String string = " ";
                fsConnectionInt2.writeData(fsFileInfo2.getDirectory(), fsFileInfo2.getFilename(), string.getBytes(), null, null);
            }
            fsFileLockInt2 = fsConnectionInt2.lockFile(fsFileInfo2);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error locking cache file [" + fsFileInfo2.getPath() + "]: " + exception.getMessage(), exception);
        }
        return fsFileLockInt2;
    }

    @Override
    public String loadCacheFile(fsFileInfo fsFileInfo2) throws ApplicationException {
        String string = null;
        try {
            fsConnectionInt fsConnectionInt2 = FilesystemManager.getInstance().getInternalConnection();
            if (fsConnectionInt2.exists(fsFileInfo2)) {
                byte[] byArray = fsConnectionInt2.readData(fsFileInfo2);
                string = new String(byArray);
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error reading cache file [" + fsFileInfo2.getPath() + "]: " + exception.getMessage(), exception);
        }
        return string;
    }

    @Override
    public void saveCacheFile(fsFileInfo fsFileInfo2, String string) throws ApplicationException {
        try {
            fsConnectionInt fsConnectionInt2 = FilesystemManager.getInstance().getInternalConnection();
            fsConnectionInt2.writeData(fsFileInfo2.getDirectory(), fsFileInfo2.getFilename(), string.getBytes(), null, fsFileInfo2.getLockData());
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error saving cache file [" + fsFileInfo2.getPath() + "]: " + exception.getMessage(), exception);
        }
    }
}

