/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Processor.Util;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.FTP.FtpException;
import au.com.aemo.Common.FileSystem.fsConnectionInt;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Batcher.Validator.pdrFileValidatorFactory;
import au.com.nemmco.Pdr.Batcher.Validator.pdrFileValidatorInt;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrBatcherHandlerDownloadFile {
    private static Logger logger = LoggerFactory.getLogger(pdrBatcherHandlerDownloadFile.class);
    private String itsHoldingDir;
    private boolean itsCheckFileIntegrity;

    public pdrBatcherHandlerDownloadFile(String string, boolean bl) {
        this.itsHoldingDir = string;
        this.itsCheckFileIntegrity = bl;
    }

    public fsFileInfo getSourceFile(fsConnectionInt fsConnectionInt2, fsFileInfo fsFileInfo2, int n2, String string, String string2) throws ApplicationException {
        Object object;
        fsFileInfo fsFileInfo3 = null;
        if (fsConnectionInt2.logOperations()) {
            Util_Logger.info(logger, "Now getting " + fsFileInfo2.getFilename() + " from " + fsFileInfo2.getDirectory() + " in thread " + n2);
        }
        try {
            fsFileInfo3 = fsConnectionInt2.getFile(fsFileInfo2, this.itsHoldingDir);
            fsFileInfo3.setDirectory(this.itsHoldingDir);
            if (fsFileInfo2.getSize() == null && ((File)(object = new File(this.itsHoldingDir, fsFileInfo2.getFilename()))).exists()) {
                fsFileInfo2.setSize(((File)object).length());
                fsFileInfo3.setSize(((File)object).length());
            }
        }
        catch (FtpException ftpException) {
            if (ftpException.getReplyCode() == 550) {
                Util_Logger.debug(logger, "Detected FTP get file contention error: " + ftpException.getReplyCode() + ", " + ftpException.getMessage() + " in thread " + n2);
            } else {
                Util_Logger.error(logger, "Detected FTP error: " + ftpException.getMessage() + " in thread " + n2, ftpException);
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Detected FTP error: " + exception.getMessage() + " in thread " + n2, exception);
        }
        object = null;
        if (fsFileInfo3 != null) {
            if (this.itsCheckFileIntegrity) {
                if (this.checkFileIntegrity(fsFileInfo3, n2)) {
                    object = fsFileInfo3;
                } else {
                    Util_Logger.error(logger, "Skipping processing of invalid file [" + fsFileInfo2.getFilename() + "]");
                }
            } else {
                object = fsFileInfo3;
            }
            Object object2 = "";
            if (!Util.isBlank(string)) {
                object2 = string + "_";
            }
            ((fsFileInfo)object).populateFileVariables((String)object2);
            ((fsFileInfo)object).processFilenameMask(string2);
        }
        return object;
    }

    private boolean checkFileIntegrity(fsFileInfo fsFileInfo2, int n2) throws ApplicationException {
        boolean bl = false;
        pdrFileValidatorFactory pdrFileValidatorFactory2 = pdrFileValidatorFactory.getInstance();
        pdrFileValidatorInt pdrFileValidatorInt2 = null;
        try {
            pdrFileValidatorInt2 = pdrFileValidatorFactory2.getValidator(fsFileInfo2.getExtension());
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Unable to get validator for file [" + fsFileInfo2.getFilename() + "]");
        }
        if (pdrFileValidatorInt2 != null) {
            File file = new File(fsFileInfo2.getDirectory(), fsFileInfo2.getFilename());
            bl = pdrFileValidatorInt2.checkFileIntegrity(file, n2);
            if (!bl) {
                try {
                    file.delete();
                }
                catch (Exception exception) {}
            }
        } else {
            bl = true;
        }
        return bl;
    }
}

