/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Processor.aseXML;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.BatcherDOMParserFactory;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.aseXMLDocumentInfo;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AckFileWriter {
    private static Logger logger = LoggerFactory.getLogger(AckFileWriter.class);
    private String itsDataSource;

    public AckFileWriter(String string) {
        this.itsDataSource = string;
    }

    public String generateAck(String string, aseXMLDocumentInfo aseXMLDocumentInfo2) throws ApplicationException {
        String string2 = null;
        File file = new File(string);
        try {
            if (!file.exists() && !file.createNewFile()) {
                throw new Exception("Creation of ack file failed " + string);
            }
            String string3 = null;
            try (FileWriter fileWriter = new FileWriter(file.getAbsolutePath(), false);){
                boolean bl;
                boolean bl2 = bl = !aseXMLDocumentInfo2.getToName().isEmpty() && !aseXMLDocumentInfo2.getFromName().isEmpty() && !aseXMLDocumentInfo2.getTransGroup().isEmpty();
                if (bl) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSS");
                    string3 = "BH-" + simpleDateFormat.format(Calendar.getInstance().getTime());
                    String string4 = "";
                    SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    string4 = simpleDateFormat2.format(Calendar.getInstance().getTime());
                    this.generateEnvelopeHeader("aseXML", fileWriter, aseXMLDocumentInfo2.getTransGroup(), aseXMLDocumentInfo2.getSchemaVersion());
                    this.generateHeaderElement(fileWriter, aseXMLDocumentInfo2, string3, string4);
                    this.generateAckElement(fileWriter, aseXMLDocumentInfo2, string3, string4);
                    fileWriter.write("</ase:aseXML>\n");
                } else if (!aseXMLDocumentInfo2.isValid()) {
                    this.generateEnvelopeHeader("Event", fileWriter, aseXMLDocumentInfo2.getTransGroup(), aseXMLDocumentInfo2.getSchemaVersion());
                    this.generateNackSchema(fileWriter, aseXMLDocumentInfo2);
                    fileWriter.write("</ase:Event>\n");
                } else {
                    this.generateEnvelopeHeader("Event", fileWriter, aseXMLDocumentInfo2.getTransGroup(), aseXMLDocumentInfo2.getSchemaVersion());
                    this.generateNackHeader(fileWriter);
                    fileWriter.write("</ase:Event>\n");
                }
                fileWriter.flush();
            }
            string2 = string3;
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Fail to generate Ack [" + string + "] : " + exception.getMessage(), exception);
        }
        return string2;
    }

    public boolean generateZipNack(String string) {
        File file = new File(string);
        try {
            if (!file.exists() && !file.createNewFile()) {
                throw new Exception("Creation of ack file failed " + string);
            }
            try (FileWriter fileWriter = new FileWriter(file.getAbsolutePath(), false);){
                this.generateEnvelopeHeader("Event", fileWriter, "", "");
                this.generateNackZip(fileWriter);
                fileWriter.write("</ase:Event>\n");
                fileWriter.flush();
            }
            return true;
        }
        catch (Exception exception) {
            Util_Logger.warning(logger, "Fail to generate Ack" + string, exception);
            return false;
        }
    }

    private void generateEnvelopeHeader(String string, FileWriter fileWriter, String string2, String string3) throws Exception {
        String string4;
        BatcherDOMParserFactory batcherDOMParserFactory = BatcherDOMParserFactory.getInstance();
        String string5 = batcherDOMParserFactory.getAckSchemaNamespace(this.itsDataSource);
        String string6 = batcherDOMParserFactory.getAckSchemaLocation(this.itsDataSource);
        List<String> list = batcherDOMParserFactory.getB2BFileTypes(this.itsDataSource);
        if (!list.isEmpty() && string2 != null && string2.length() > 0 && list.contains(string2.toUpperCase()) && string3 != null && string3.length() > 0) {
            string4 = string5.split(":");
            String string7 = string4[2];
            string5 = string5.replaceFirst(string7, string3);
            string6 = string6.replaceAll(string7, string3);
        }
        string4 = "<ase:" + string + " xmlns:ase=\"" + string5 + "\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"" + string5 + " " + string6 + "\">\n";
        fileWriter.write("<?xml version=\"1.0\" ?>\n");
        fileWriter.write(string4);
    }

    private void generateHeaderElement(FileWriter fileWriter, aseXMLDocumentInfo aseXMLDocumentInfo2, String string, String string2) throws Exception {
        fileWriter.write("   <Header>\n");
        fileWriter.write("      <From" + this.generateDescription(aseXMLDocumentInfo2.getToDesc()) + ">" + aseXMLDocumentInfo2.getToName() + "</From>\n");
        fileWriter.write("      <To" + this.generateDescription(aseXMLDocumentInfo2.getFromDesc()) + ">" + aseXMLDocumentInfo2.getFromName() + "</To>\n");
        fileWriter.write("      <MessageID>" + string + "</MessageID>\n");
        fileWriter.write("      <MessageDate>" + string2 + "</MessageDate>\n");
        fileWriter.write("      <TransactionGroup>" + aseXMLDocumentInfo2.getTransGroup() + "</TransactionGroup>\n");
        if (!Util.isBlank(aseXMLDocumentInfo2.getPriority())) {
            fileWriter.write("      <Priority>" + aseXMLDocumentInfo2.getPriority() + "</Priority>\n");
        }
        if (!Util.isBlank(aseXMLDocumentInfo2.getSecurityContext())) {
            fileWriter.write("      <SecurityContext>" + aseXMLDocumentInfo2.getSecurityContext() + "</SecurityContext>\n");
        }
        fileWriter.write("   </Header>\n");
    }

    private String generateDescription(String string) {
        if (!string.isEmpty()) {
            return " description=\"" + this.fixSpecialCodes(string) + "\"";
        }
        return "";
    }

    private void generateAckElement(FileWriter fileWriter, aseXMLDocumentInfo aseXMLDocumentInfo2, String string, String string2) throws Exception {
        fileWriter.write("   <Acknowledgements>\n");
        if (aseXMLDocumentInfo2.isValid()) {
            fileWriter.write("      <MessageAcknowledgement initiatingMessageID=\"" + aseXMLDocumentInfo2.getMsgId() + "\" receiptDate=\"" + string2 + "\" receiptID=\"" + string + "\" status=\"Accept\">\n");
        } else {
            fileWriter.write("      <MessageAcknowledgement initiatingMessageID=\"" + aseXMLDocumentInfo2.getMsgId() + "\" receiptDate=\"" + string2 + "\" receiptID=\"" + string + "\" status=\"Reject\">\n");
            fileWriter.write("         <Event class=\"Message\" severity=\"Fatal\">\n");
            fileWriter.write("            <Code description=\"Schema validation failure\">2</Code>\n");
            fileWriter.write("            <Explanation>" + this.fixSpecialCodes(aseXMLDocumentInfo2.getErrorMessage()) + "</Explanation>\n");
            fileWriter.write("         </Event>\n");
        }
        fileWriter.write("      </MessageAcknowledgement>\n");
        fileWriter.write("   </Acknowledgements>\n");
    }

    private void generateNackSchema(FileWriter fileWriter, aseXMLDocumentInfo aseXMLDocumentInfo2) throws Exception {
        fileWriter.write("            <Code description=\"Schema validation failure\">2</Code>\n");
        fileWriter.write("            <Explanation>" + this.fixSpecialCodes(aseXMLDocumentInfo2.getErrorMessage()) + "</Explanation>\n");
    }

    private void generateNackHeader(FileWriter fileWriter) throws Exception {
        fileWriter.write("            <Code description=\"Header Incorrect\">7</Code>\n");
        fileWriter.write("            <Explanation>Header Incorrect</Explanation>\n");
    }

    private void generateNackZip(FileWriter fileWriter) throws Exception {
        fileWriter.write("            <Code description=\"Uncompression failure\">5</Code>\n");
        fileWriter.write("            <Explanation>Invalid zip file</Explanation>\n");
    }

    private String replaceAllCodes(String string, char c2, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = 0;
        for (int i2 = 0; i2 < stringBuffer.length(); ++i2) {
            if (stringBuffer.charAt(i2) == c2) {
                stringBuffer2.insert(n2, '&');
                stringBuffer2.insert(n2 + 1, string2);
                n2 = n2 + string2.length() + 1;
                continue;
            }
            stringBuffer2.insert(n2, stringBuffer.charAt(i2));
            ++n2;
        }
        return stringBuffer2.toString();
    }

    private String fixSpecialCodes(String string) {
        string = this.replaceAllCodes(string, '&', "amp;");
        string = this.replaceAllCodes(string, '\'', "apos;");
        string = this.replaceAllCodes(string, '\"', "quot;");
        string = this.replaceAllCodes(string, '>', "gt;");
        string = this.replaceAllCodes(string, '<', "lt;");
        return string;
    }

    public static void main(String[] stringArray) {
        AckFileWriter ackFileWriter = new AckFileWriter("test");
        String string = "&This < > is the ''mes>sage\" & ok?";
        String string2 = ackFileWriter.fixSpecialCodes(string);
        System.out.println(string);
        System.out.println(string2);
    }
}

