/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Processor.aseXML;

import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.BatcherDOMParser;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.BatcherDOMParserGrammerPool;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.ProcessWatermark;
import au.com.nemmco.Pdr.Batcher.pdrBatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatcherDOMParserFactory {
    private static Logger logger = LoggerFactory.getLogger(BatcherDOMParserFactory.class);
    private boolean allOK = false;
    private Map<String, BatcherDOMParserGrammerPool> itsGrammerPools;
    private Map<String, String> itsAckSchemaNamespace;
    private Map<String, String> itsAckSchemaLocation;
    private Map<String, List<String>> itsB2BFileTypes;
    private Map<String, Boolean> itsValidateSchema;
    private Map<String, ProcessWatermark> itsWaterMarks;

    private BatcherDOMParserFactory() {
        try {
            this.itsGrammerPools = new HashMap<String, BatcherDOMParserGrammerPool>();
            this.itsAckSchemaNamespace = new HashMap<String, String>();
            this.itsAckSchemaLocation = new HashMap<String, String>();
            this.itsB2BFileTypes = new HashMap<String, List<String>>();
            this.itsValidateSchema = new HashMap<String, Boolean>();
            this.itsWaterMarks = new HashMap<String, ProcessWatermark>();
            String string = Util.getProperty(pdrBatcher.PROPERTIES_FILE, "batcher_data_sources", "remote,local");
            if (!Util.isBlank(string)) {
                String[] stringArray;
                for (String string2 : stringArray = Util.getColumns(string, ',')) {
                    Object object;
                    boolean bl = Util.getProperty(pdrBatcher.PROPERTIES_FILE, "batcher_" + string2 + "_hub", "false").equalsIgnoreCase("true");
                    if (!bl) continue;
                    BatcherDOMParserGrammerPool batcherDOMParserGrammerPool = new BatcherDOMParserGrammerPool(string2);
                    this.itsGrammerPools.put(string2, batcherDOMParserGrammerPool);
                    String string3 = Util.getProperty(pdrBatcher.PROPERTIES_FILE, "batcher_" + string2 + "_ackschemanamespace");
                    this.itsAckSchemaNamespace.put(string2, string3);
                    String string4 = Util.getProperty(pdrBatcher.PROPERTIES_FILE, "batcher_" + string2 + "_ackschemalocation");
                    this.itsAckSchemaLocation.put(string2, string4);
                    String string5 = Util.getProperty(pdrBatcher.PROPERTIES_FILE, "batcher_" + string2 + "_b2bfiletypes");
                    ArrayList<String> arrayList = new ArrayList<String>();
                    if (!Util.isBlank(string5)) {
                        for (String string6 : object = Util.getColumns(string5, ',')) {
                            if (Util.isBlank(string6)) continue;
                            arrayList.add(string6.toUpperCase());
                        }
                    }
                    this.itsB2BFileTypes.put(string2, arrayList);
                    object = Util.getProperty(pdrBatcher.PROPERTIES_FILE, "batcher_" + string2 + "_schemavalidation", "true");
                    this.itsValidateSchema.put(string2, ((String)object).equalsIgnoreCase("true"));
                    ProcessWatermark processWatermark = new ProcessWatermark();
                    processWatermark.setInboxHighMark(this.getWaterMark(string2, "inboxhighmark", "30"));
                    processWatermark.setInboxLowMark(this.getWaterMark(string2, "inboxlowmark", "5"));
                    processWatermark.setOutboxHighMark(this.getWaterMark(string2, "outboxhighmark", "500"));
                    processWatermark.setOutboxLowMark(this.getWaterMark(string2, "outboxlowmark", "100"));
                    this.itsWaterMarks.put(string2, processWatermark);
                }
            }
            this.allOK = true;
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error initialising BatcherDOMParserFactory: " + exception.getMessage(), exception);
        }
    }

    public static BatcherDOMParserFactory getInstance() {
        return SingletonHolder.instance;
    }

    private Integer getWaterMark(String string, String string2, String string3) {
        Integer n2 = null;
        String string4 = Util.getProperty(pdrBatcher.PROPERTIES_FILE, "batcher_" + string + "_" + string2, string3);
        if (!Util.isBlank(string4)) {
            n2 = Integer.parseInt(string4);
        }
        return n2;
    }

    public boolean getAllOK() {
        return this.allOK;
    }

    public BatcherDOMParser getParser(String string) {
        BatcherDOMParserGrammerPool batcherDOMParserGrammerPool = this.itsGrammerPools.get(string);
        BatcherDOMParser batcherDOMParser = new BatcherDOMParser(batcherDOMParserGrammerPool);
        return batcherDOMParser;
    }

    public String getAckSchemaNamespace(String string) {
        return this.itsAckSchemaNamespace.get(string);
    }

    public String getAckSchemaLocation(String string) {
        return this.itsAckSchemaLocation.get(string);
    }

    public List<String> getB2BFileTypes(String string) {
        return this.itsB2BFileTypes.get(string);
    }

    public boolean getValidateSchema(String string) {
        return this.itsValidateSchema.get(string);
    }

    public ProcessWatermark getProcessWatermark(String string) {
        return this.itsWaterMarks.get(string);
    }

    public void setProcessWatermark(String string, ProcessWatermark processWatermark) {
        this.itsWaterMarks.put(string, processWatermark);
    }

    private static class SingletonHolder {
        private static BatcherDOMParserFactory instance = new BatcherDOMParserFactory();

        private SingletonHolder() {
        }
    }
}

