/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Processor.aseXML;

import au.com.aemo.Common.Logging.Util_Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessWatermark
implements Serializable {
    private static Logger logger = LoggerFactory.getLogger(ProcessWatermark.class);
    private int itsInboxHighMark;
    private int itsInboxLowMark;
    private int itsOutboxHighMark;
    private int itsOutboxLowMark;
    private volatile int itsAEMOInboxFileCount = 0;
    private volatile boolean itsAEMOInboxIsClearing = false;
    private volatile int itsParticipantOutboxFileCount = 0;
    private volatile boolean itsParticipantOutboxIsClearing = false;

    @SuppressFBWarnings(value={"UG_SYNC_SET_UNSYNC_GET"}, justification="No requirement to synchronise get method")
    public Integer getAEMOInboxFileCount() {
        return this.itsAEMOInboxFileCount;
    }

    public boolean getAEMOInboxIsClearing() {
        return this.itsAEMOInboxIsClearing;
    }

    public synchronized void setAEMOInboxFileCount(int n2) {
        this.itsAEMOInboxFileCount = n2;
        this.assessAEMOInboxFlowControlState(true);
    }

    @SuppressFBWarnings(value={"UG_SYNC_SET_UNSYNC_GET"}, justification="No requirement to synchronise get method")
    public Integer getParticipantOutboxFileCount() {
        return this.itsParticipantOutboxFileCount;
    }

    public synchronized void setParticipantOutboxFileCount(int n2) {
        this.itsParticipantOutboxFileCount = n2;
        this.assessParticipantOutboxFlowControlState(true);
    }

    public boolean getParticipantOutboxIsClearing() {
        return this.itsParticipantOutboxIsClearing;
    }

    public synchronized boolean assessAEMOInboxFlowControlState(boolean bl) {
        boolean bl2 = false;
        if (this.getAEMOInboxIsClearing()) {
            if (this.getAEMOInboxFileCount() < this.getInboxLowMark()) {
                this.itsAEMOInboxIsClearing = false;
                bl2 = true;
                Util_Logger.info(logger, "AEMO inbox file count [" + this.getAEMOInboxFileCount() + "] now within Inbox low mark limit [" + this.getInboxHighMark() + "], disabling flow control");
            } else {
                String string = "Waiting for AEMO inbox file count [" + this.getAEMOInboxFileCount() + "] to fall below Inbox low mark limit [" + this.getInboxLowMark() + "]";
                if (bl) {
                    Util_Logger.info(logger, string);
                } else {
                    Util_Logger.debug(logger, string);
                }
            }
        } else if (this.getAEMOInboxFileCount() < this.getInboxHighMark()) {
            bl2 = true;
        } else {
            this.itsAEMOInboxIsClearing = true;
            Util_Logger.info(logger, "AEMO inbox file count [" + this.getAEMOInboxFileCount() + "] now at Inbox high mark limit [" + this.getInboxHighMark() + "], enabling flow control");
        }
        return bl2;
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="Method is synchronized, so only one thread increments this.itsAEMOInboxFileCount at a time")
    public synchronized boolean canSendFile() {
        boolean bl = this.assessAEMOInboxFlowControlState(false);
        if (bl) {
            ++this.itsAEMOInboxFileCount;
        }
        return bl;
    }

    public synchronized boolean assessParticipantOutboxFlowControlState(boolean bl) {
        boolean bl2 = false;
        if (this.getParticipantOutboxIsClearing()) {
            if (this.getParticipantOutboxFileCount() < this.getOutboxLowMark()) {
                this.itsParticipantOutboxIsClearing = false;
                bl2 = true;
                Util_Logger.info(logger, "Participant outbox file count [" + this.getParticipantOutboxFileCount() + "] now within Outbox low mark limit [" + this.getOutboxLowMark() + "], disabling flow control");
            } else {
                String string = "Waiting for participant outbox file count [" + this.getParticipantOutboxFileCount() + "] to fall below Outbox low mark limit [" + this.getOutboxLowMark() + "]";
                if (bl) {
                    Util_Logger.info(logger, string);
                } else {
                    Util_Logger.debug(logger, string);
                }
            }
        } else if (this.getParticipantOutboxFileCount() < this.getOutboxHighMark()) {
            bl2 = true;
        } else {
            this.itsParticipantOutboxIsClearing = true;
            Util_Logger.info(logger, "Participant outbox file count [" + this.getParticipantOutboxFileCount() + "] now at Outbox high mark limit [" + this.getOutboxHighMark() + "], enabling flow control");
        }
        return bl2;
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="Method is synchronized, so only one thread increments this.itsParticipantOutboxFileCount at a time")
    public synchronized boolean canReceiveFile() {
        boolean bl = this.assessParticipantOutboxFlowControlState(false);
        if (bl) {
            ++this.itsParticipantOutboxFileCount;
        }
        return bl;
    }

    public int getInboxHighMark() {
        return this.itsInboxHighMark;
    }

    public void setInboxHighMark(int n2) {
        this.itsInboxHighMark = n2;
    }

    public int getInboxLowMark() {
        return this.itsInboxLowMark;
    }

    public void setInboxLowMark(int n2) {
        this.itsInboxLowMark = n2;
    }

    public int getOutboxHighMark() {
        return this.itsOutboxHighMark;
    }

    public void setOutboxHighMark(int n2) {
        this.itsOutboxHighMark = n2;
    }

    public int getOutboxLowMark() {
        return this.itsOutboxLowMark;
    }

    public void setOutboxLowMark(int n2) {
        this.itsOutboxLowMark = n2;
    }
}

