/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Processor;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.FileSystem.fsConnectionInt;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.FileSystem.fsTransactionMetaData;
import au.com.aemo.Common.Files.FileNameTokenResolver;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.BatcherDOMParserFactory;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.aseXMLDocumentInfo;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerBase;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerConfig;
import au.com.nemmco.Pdr.Batcher.pdrBatcher;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class pdrBatcherHandlerAseXMLBase
extends pdrBatcherHandlerBase {
    public static final String INBOX = "INBOX";
    public static final String OUTBOX = "OUTBOX";
    public static final String STOPBOX = "STOPBOX";
    public static final String STATE_TMP = "TMP";
    public static final String STATE_ZIP = "ZIP";
    public static final String STATE_SENDING = "SENDING";
    public static final String STATE_SENT = "SENT";
    public static final String STATE_DONE = "DONE";
    public static final String STATE_NACK = "nack";
    public static final String STATE_RESEND = "RESEND";
    public static final String STATE_ACK = "ack";
    public static final String POSITIVE_ACK = "Positive";
    public static final String NEGATIVE_ACK = "Negative";
    public static final String RESEND_ACK = "Resend";
    public static final String PARAM_ParticipantID = "ParticipantId";
    private static Logger logger = LoggerFactory.getLogger(pdrBatcherHandlerAseXMLBase.class);
    private List<String> itsParticipantIdList;

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Abstract class used by trusted internal classes")
    public pdrBatcherHandlerAseXMLBase(pdrBatcherHandlerConfig pdrBatcherHandlerConfig2) throws ApplicationException {
        super(pdrBatcherHandlerConfig2);
        BatcherDOMParserFactory batcherDOMParserFactory = BatcherDOMParserFactory.getInstance();
        if (!batcherDOMParserFactory.getAllOK()) {
            Util_Logger.error(logger, "Error initialising BatcherDOMParserFactory");
        }
        String string = Util.getProperty(pdrBatcher.PROPERTIES_FILE, "batcher_" + this.getDataSourceId() + "_participant_list", null);
        string = Util.getProperty(pdrBatcher.PROPERTIES_FILE, "batcher_thread_" + pdrBatcherHandlerConfig2.ThreadId + "_participant_list", string);
        this.itsParticipantIdList = !Util.isBlank(string) ? Util.getList(string, ',') : new ArrayList<String>();
    }

    protected List<String> getParticipantIdList() {
        return this.itsParticipantIdList;
    }

    protected abstract String getSchemaDefinitionDataSource();

    protected String getParticipantId(fsFileInfo fsFileInfo2) {
        String string = null;
        if (fsFileInfo2.getEventData().getEventParameters() != null) {
            string = fsFileInfo2.getEventData().getEventParameters().get(PARAM_ParticipantID);
        }
        return string;
    }

    protected String calcFilename(fsFileInfo fsFileInfo2, String string) {
        int n2 = fsFileInfo2.getFilename().lastIndexOf(".");
        return (fsFileInfo2.getFilename().substring(0, n2) + "." + string).toLowerCase();
    }

    private Map<String, fsFileInfo> fixDirectoryListingKeys(Map<String, fsFileInfo> map) {
        HashMap<String, fsFileInfo> hashMap = new HashMap<String, fsFileInfo>();
        if (map != null) {
            for (Map.Entry<String, fsFileInfo> entry : map.entrySet()) {
                hashMap.put(entry.getKey().toLowerCase(), entry.getValue());
            }
        }
        return hashMap;
    }

    private String resolveSourceDir(String string, String string2, String string3) throws Exception {
        String string4 = this.getSourceDir().toUpperCase();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(PARAM_ParticipantID, string);
        string4 = FileNameTokenResolver.process(string4, hashMap);
        string4 = string4.replace(string2, string3);
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, fsFileInfo> getSourceListing(String string, String string2, String string3) {
        Map<String, fsFileInfo> map = null;
        fsConnectionInt fsConnectionInt2 = null;
        try {
            String string4 = this.resolveSourceDir(string, string2, string3);
            fsConnectionInt2 = this.getSourceConnection();
            map = fsConnectionInt2.listFiles(string4, this.getFileFilter(), null);
        }
        catch (Exception exception) {
            try {
                try {
                    if (fsConnectionInt2 != null) {
                        fsConnectionInt2.disconnect();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                Util_Logger.errorNoRaise(logger, "Detected exception processing aseXML files: " + exception.getMessage(), exception);
            }
            catch (Throwable throwable) {
                this.freeSourceConnection(fsConnectionInt2);
                throw throwable;
            }
            this.freeSourceConnection(fsConnectionInt2);
        }
        this.freeSourceConnection(fsConnectionInt2);
        return this.fixDirectoryListingKeys(map);
    }

    protected String resolveDestinationDir(String string) throws Exception {
        String string2 = this.getDestinationDir(null).get(0);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(PARAM_ParticipantID, string);
        string2 = FileNameTokenResolver.process(string2, hashMap);
        return string2;
    }

    private String resolveDestinationDir(String string, String string2, String string3) throws Exception {
        String string4 = this.resolveDestinationDir(string).toUpperCase();
        string4 = string4.replace(string2, string3);
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, fsFileInfo> getDestinationListing(String string, String string2, String string3) throws ApplicationException {
        Map<String, fsFileInfo> map = null;
        fsConnectionInt fsConnectionInt2 = null;
        try {
            String string4 = this.resolveDestinationDir(string, string2, string3);
            fsConnectionInt2 = this.getDestinationConnection();
            map = fsConnectionInt2.listFiles(string4, this.getFileFilter(), null);
        }
        catch (Exception exception) {
            try {
                try {
                    if (fsConnectionInt2 != null) {
                        fsConnectionInt2.disconnect();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                Util_Logger.error(logger, "Detected exception processing aseXML files: " + exception.getMessage(), exception);
            }
            catch (Throwable throwable) {
                this.freeDestinationConnection(fsConnectionInt2);
                throw throwable;
            }
            this.freeDestinationConnection(fsConnectionInt2);
        }
        this.freeDestinationConnection(fsConnectionInt2);
        return this.fixDirectoryListingKeys(map);
    }

    protected void populateTransactionData(fsFileInfo fsFileInfo2, aseXMLDocumentInfo aseXMLDocumentInfo2) {
        fsTransactionMetaData fsTransactionMetaData2 = fsFileInfo2.getTransactionMetaData();
        fsTransactionMetaData2.setFileId(aseXMLDocumentInfo2.getTransGroup());
        fsTransactionMetaData2.setMessageId(aseXMLDocumentInfo2.getMsgId());
        fsTransactionMetaData2.setInitiatingMessageId(aseXMLDocumentInfo2.getInitMsgId());
        fsTransactionMetaData2.setParticipantIdFrom(aseXMLDocumentInfo2.getFromName());
        fsTransactionMetaData2.setParticipantIdTo(aseXMLDocumentInfo2.getToName());
        fsTransactionMetaData2.setMarket(aseXMLDocumentInfo2.getMarket());
        fsTransactionMetaData2.setPriority(aseXMLDocumentInfo2.getPriority());
    }
}

