/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Processor;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.FileSystem.fsConnectionInt;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.FileSystem.fsProcessStatus;
import au.com.aemo.Common.FileSystem.fsTransactionMetaData;
import au.com.aemo.Common.Files.FileNameTokenResolver;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Threading.threadMonitorStatusItem;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.AckFileWriter;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.BatcherDOMParserFactory;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.ProcessWatermark;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.aseXMLDocumentInfo;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.xmlTransactionFileParser;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerAseXMLBase;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerConfig;
import au.com.nemmco.Pdr.Common.Monitor.pdrMonitorManager;
import au.com.nemmco.Pdr.Common.Monitor.pdrPerformanceJobSizeUnits;
import au.com.nemmco.Pdr.Common.Monitor.pdrPerformanceRec;
import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class pdrBatcherHandlerAseXMLReceiveBase
extends pdrBatcherHandlerAseXMLBase {
    private static Logger logger = LoggerFactory.getLogger(pdrBatcherHandlerAseXMLReceiveBase.class);
    private boolean itsProcessFlowCountSet = false;

    public pdrBatcherHandlerAseXMLReceiveBase(pdrBatcherHandlerConfig pdrBatcherHandlerConfig2) throws ApplicationException {
        super(pdrBatcherHandlerConfig2);
    }

    @Override
    protected String getSchemaDefinitionDataSource() {
        return this.getDataSourceId();
    }

    @Override
    protected boolean requiresDestinationDirectoryListing() {
        return true;
    }

    @Override
    protected boolean logDirectoryEntry() {
        return false;
    }

    private void setFlowControl(Map<String, fsFileInfo> map) {
        if (!this.itsProcessFlowCountSet) {
            int n2 = map.size();
            BatcherDOMParserFactory batcherDOMParserFactory = BatcherDOMParserFactory.getInstance();
            ProcessWatermark processWatermark = batcherDOMParserFactory.getProcessWatermark(this.getSchemaDefinitionDataSource());
            Util_Logger.info(logger, "Setting Participant Outbox directory file count to " + n2 + " for process flow control");
            processWatermark.setParticipantOutboxFileCount(n2);
            this.itsProcessFlowCountSet = true;
        }
    }

    @Override
    protected boolean removeSourceFileAfterProcessing() {
        return false;
    }

    @Override
    protected boolean downloadSourceFile() {
        return true;
    }

    protected void resetFlowControl() {
        this.itsProcessFlowCountSet = false;
    }

    protected abstract String getOutboxFileExtensionForProcessing();

    @Override
    protected boolean processFileCheck(fsFileInfo fsFileInfo2, Map<String, fsFileInfo> map, boolean bl) {
        boolean bl2 = false;
        try {
            if (bl) {
                this.setFlowControl(map);
            }
            if (fsFileInfo2.getExtension().equalsIgnoreCase(this.getOutboxFileExtensionForProcessing())) {
                boolean bl3 = false;
                if (map != null) {
                    bl3 = map.containsKey(fsFileInfo2.getFilename().toLowerCase());
                }
                if (!bl3) {
                    BatcherDOMParserFactory batcherDOMParserFactory;
                    ProcessWatermark processWatermark;
                    bl2 = bl ? ((processWatermark = (batcherDOMParserFactory = BatcherDOMParserFactory.getInstance()).getProcessWatermark(this.getDataSourceId())) != null ? processWatermark.canReceiveFile() : true) : true;
                }
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Unable to perform file process check for [" + fsFileInfo2.getFilename() + "] : " + exception.getMessage(), exception);
        }
        return bl2;
    }

    @Override
    protected void startPollCycle(String string) {
    }

    @Override
    protected void startPollCycleDirectory(String string) {
    }

    @Override
    protected void preProcessSourceDirList(String string, List<fsFileInfo> list) {
    }

    @Override
    public List<AbstractMap.SimpleEntry> reportSupplementalConfiguration() {
        ArrayList<AbstractMap.SimpleEntry> arrayList = new ArrayList<AbstractMap.SimpleEntry>();
        BatcherDOMParserFactory batcherDOMParserFactory = BatcherDOMParserFactory.getInstance();
        ProcessWatermark processWatermark = batcherDOMParserFactory.getProcessWatermark(this.getDataSourceId());
        if (processWatermark != null) {
            arrayList.add(new AbstractMap.SimpleEntry<String, Integer>("OutboxLowWatermark", processWatermark.getOutboxLowMark()));
            arrayList.add(new AbstractMap.SimpleEntry<String, Integer>("OutboxHighWatermark", processWatermark.getOutboxHighMark()));
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        for (String string2 : this.getParticipantIdList()) {
            stringBuilder.append(string);
            stringBuilder.append(string2);
            string = ",";
        }
        arrayList.add(new AbstractMap.SimpleEntry<String, String>("ActiveParticipantList", stringBuilder.toString()));
        return arrayList;
    }

    @Override
    public threadMonitorStatusItem getStatusReport() {
        threadMonitorStatusItem threadMonitorStatusItem2 = super.getStatusReport();
        BatcherDOMParserFactory batcherDOMParserFactory = BatcherDOMParserFactory.getInstance();
        ProcessWatermark processWatermark = batcherDOMParserFactory.getProcessWatermark(this.getDataSourceId());
        if (processWatermark != null) {
            if (processWatermark.getParticipantOutboxFileCount() != null) {
                threadMonitorStatusItem2.addItem("Outbox Count", processWatermark.getParticipantOutboxFileCount());
            }
            threadMonitorStatusItem2.addItem("Outbox Flow Control", processWatermark.getParticipantOutboxIsClearing() ? "ACTIVE" : "MONITORING");
        }
        return threadMonitorStatusItem2;
    }

    protected abstract String getAckFilename(fsFileInfo var1, boolean var2);

    @Override
    protected fsProcessStatus processSingleFileAction(fsConnectionInt fsConnectionInt2, fsFileInfo fsFileInfo2, fsFileInfo fsFileInfo3, String string, fsConnectionInt fsConnectionInt3, String string2, Map<String, fsFileInfo> map, boolean bl, boolean bl2) {
        fsProcessStatus fsProcessStatus2 = new fsProcessStatus();
        try {
            List<String> list;
            Object object;
            xmlTransactionFileParser xmlTransactionFileParser2 = new xmlTransactionFileParser(this.getSchemaDefinitionDataSource(), this.getHoldingDir());
            aseXMLDocumentInfo aseXMLDocumentInfo2 = xmlTransactionFileParser2.Parse(fsFileInfo3.getPath());
            boolean bl3 = aseXMLDocumentInfo2.isValid();
            if (bl3) {
                this.populateTransactionData(fsFileInfo2, aseXMLDocumentInfo2);
                if (fsConnectionInt3.logOperations()) {
                    Util_Logger.info(logger, "Now sending " + fsFileInfo3.getFilename() + " to " + string2 + " in thread " + this.getId());
                }
                if (this.getConfig().AllowOverwrite && fsConnectionInt3.exists(string2, fsFileInfo3.getFilename())) {
                    fsConnectionInt3.deleteFile(string2, fsFileInfo3.getFilename());
                }
                fsProcessStatus2 = fsConnectionInt3.putFile(fsFileInfo3, string2, bl2, null);
                object = aseXMLDocumentInfo2.getToName();
                list = this.getParticipantIdList();
                if (!list.contains(object)) {
                    Util_Logger.info(logger, "Detected transaction from ParticipantID [" + (String)object + "] from source [" + this.getDataSourceId() + "], adding to configured participant list");
                    list.add((String)object);
                }
            }
            if (bl2) {
                object = new AckFileWriter(this.getSchemaDefinitionDataSource());
                list = this.getAckFilename(fsFileInfo3, bl3);
                String string3 = this.getHoldingDir() + "/" + (String)((Object)list);
                String string4 = ((AckFileWriter)object).generateAck(string3, aseXMLDocumentInfo2);
                fsFileInfo fsFileInfo4 = new fsFileInfo(new File(string3));
                fsFileInfo4.setEventData(fsFileInfo2.getEventData());
                fsFileInfo4.setTransactionMetaData(fsFileInfo2.getTransactionMetaData());
                fsFileInfo4.addAPIHeaderValues(this.getSourceAckAPIHeaderValues());
                String string5 = FileNameTokenResolver.process(this.getSourceAckDir(), fsFileInfo4);
                Util_Logger.info(logger, "Now sending acknowledgement [" + fsFileInfo4.getFilename() + "] to " + string5 + " in thread " + this.getId());
                Date date = new Date();
                fsConnectionInt2.putFile(fsFileInfo4, string5, true, null);
                pdrPerformanceRec pdrPerformanceRec2 = new pdrPerformanceRec();
                pdrPerformanceRec2.setDataSource(this.getDataDestinationId());
                pdrPerformanceRec2.setThreadId(Integer.toString(this.getId()));
                pdrPerformanceRec2.setStartDate(date);
                pdrPerformanceRec2.setEndDate(new Date());
                pdrPerformanceRec2.setFilename(fsFileInfo4.getName());
                pdrPerformanceRec2.setFileExtension(fsFileInfo4.getExtension());
                this.populateTransactionData(fsFileInfo4, aseXMLDocumentInfo2);
                fsTransactionMetaData fsTransactionMetaData2 = fsFileInfo4.getTransactionMetaData();
                fsTransactionMetaData2.setMessageId(string4);
                pdrPerformanceRec2.setTransactionMetaData(fsTransactionMetaData2);
                pdrPerformanceRec2.setJobType("UPLOAD");
                pdrPerformanceRec2.setJobSize(fsFileInfo4.getSize());
                pdrPerformanceRec2.setJobSizeUnits(pdrPerformanceJobSizeUnits.BYTES);
                pdrPerformanceRec2.setContentCreationDate(fsFileInfo4.getModifiedDate());
                pdrPerformanceRec2.setEventReceivedDate(new Date());
                pdrMonitorManager.getInstance().addRecord(pdrPerformanceRec2);
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Detected error receiving aseXML transaction [" + fsFileInfo3.getFilename() + "]: " + exception.getMessage() + " in thread " + this.getId(), exception);
        }
        return fsProcessStatus2;
    }
}

