/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Processor;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.FileSystem.fsConnectionInt;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.FileSystem.fsProcessStatus;
import au.com.aemo.Common.Java.ObjectUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Threading.threadMonitorStatusItem;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.BatcherDOMParserFactory;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.ProcessWatermark;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.aseXMLDocumentInfo;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.xmlTransactionFileParser;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerAseXMLBase;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerConfig;
import au.com.nemmco.Pdr.Common.Monitor.pdrMonitorManager;
import au.com.nemmco.Pdr.Common.Monitor.pdrPerformanceJobSizeUnits;
import au.com.nemmco.Pdr.Common.Monitor.pdrPerformanceRec;
import java.lang.invoke.CallSite;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class pdrBatcherHandlerAseXMLSendBase
extends pdrBatcherHandlerAseXMLBase {
    private static Logger logger = LoggerFactory.getLogger(pdrBatcherHandlerAseXMLSendBase.class);

    public pdrBatcherHandlerAseXMLSendBase(pdrBatcherHandlerConfig pdrBatcherHandlerConfig2) throws ApplicationException {
        super(pdrBatcherHandlerConfig2);
    }

    @Override
    protected String getSchemaDefinitionDataSource() {
        return this.getDataDestinationId();
    }

    protected boolean isB2BFileType(fsFileInfo fsFileInfo2) {
        boolean bl = false;
        BatcherDOMParserFactory batcherDOMParserFactory = BatcherDOMParserFactory.getInstance();
        for (String string : batcherDOMParserFactory.getB2BFileTypes(this.getSchemaDefinitionDataSource())) {
            if (!fsFileInfo2.getName().toUpperCase().startsWith(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected abstract boolean checkReceivingParticipantIsStopped(fsFileInfo var1, aseXMLDocumentInfo var2) throws Exception;

    protected boolean checkReceivingParticipantIsStopped(fsFileInfo fsFileInfo2, fsFileInfo fsFileInfo3) throws Exception {
        xmlTransactionFileParser xmlTransactionFileParser2 = new xmlTransactionFileParser(this.getDataDestinationId(), this.getHoldingDir());
        aseXMLDocumentInfo aseXMLDocumentInfo2 = xmlTransactionFileParser2.Parse(fsFileInfo3.getPath());
        this.populateTransactionData(fsFileInfo2, aseXMLDocumentInfo2);
        return this.checkReceivingParticipantIsStopped(fsFileInfo3, aseXMLDocumentInfo2);
    }

    @Override
    protected boolean logDirectoryEntry() {
        return false;
    }

    @Override
    protected boolean removeSourceFileAfterProcessing() {
        return false;
    }

    @Override
    protected boolean downloadSourceFile() {
        return true;
    }

    @Override
    protected void startPollCycle(String string) {
    }

    @Override
    protected void startPollCycleDirectory(String string) {
    }

    @Override
    public List<AbstractMap.SimpleEntry> reportSupplementalConfiguration() {
        ArrayList<AbstractMap.SimpleEntry> arrayList = new ArrayList<AbstractMap.SimpleEntry>();
        BatcherDOMParserFactory batcherDOMParserFactory = BatcherDOMParserFactory.getInstance();
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        for (String string2 : this.getParticipantIdList()) {
            stringBuilder.append(string);
            stringBuilder.append(string2);
            string = ",";
            String string3 = this.getDataDestinationId() + "_" + string2;
            ProcessWatermark processWatermark = batcherDOMParserFactory.getProcessWatermark(string3);
            if (processWatermark == null) continue;
            arrayList.add(new AbstractMap.SimpleEntry<CallSite, Integer>((CallSite)((Object)(string2 + " InboxLowWatermark")), processWatermark.getInboxLowMark()));
            arrayList.add(new AbstractMap.SimpleEntry<CallSite, Integer>((CallSite)((Object)(string2 + " InboxHighWatermark")), processWatermark.getInboxHighMark()));
        }
        arrayList.add(new AbstractMap.SimpleEntry<String, String>("ActiveParticipantList", stringBuilder.toString()));
        return arrayList;
    }

    @Override
    public threadMonitorStatusItem getStatusReport() {
        threadMonitorStatusItem threadMonitorStatusItem2 = super.getStatusReport();
        BatcherDOMParserFactory batcherDOMParserFactory = BatcherDOMParserFactory.getInstance();
        for (String string : this.getParticipantIdList()) {
            String string2 = this.getDataDestinationId() + "_" + string;
            ProcessWatermark processWatermark = batcherDOMParserFactory.getProcessWatermark(string2);
            if (processWatermark == null) continue;
            if (processWatermark.getParticipantOutboxFileCount() != null) {
                threadMonitorStatusItem2.addItem(string + " Inbox Count", processWatermark.getAEMOInboxFileCount());
            }
            threadMonitorStatusItem2.addItem(string + " Inbox Flow Control", processWatermark.getAEMOInboxIsClearing() ? "ACTIVE" : "MONITORING");
        }
        return threadMonitorStatusItem2;
    }

    protected abstract int getActiveTransactionCount(String var1) throws ApplicationException;

    @Override
    protected void preProcessSourceDirList(String string, List<fsFileInfo> list) throws ApplicationException {
        if (list != null) {
            for (fsFileInfo object : list) {
                object.processFilenameMask(this.getSourceFilenameMask());
                String string2 = this.getParticipantId(object);
                if (!Util.isBlank(string2)) {
                    string2 = string2.toUpperCase();
                    List<String> n2 = this.getParticipantIdList();
                    if (n2.contains(string2)) continue;
                    Util_Logger.info(logger, "Detected transaction from ParticipantID [" + string2 + "] from source [" + this.getDataSourceId() + "], adding to configured participant list");
                    n2.add(string2);
                    continue;
                }
                Util_Logger.warning(logger, "Unable to extract ParticipantId from file [" + object.getFilename() + "]");
            }
        }
        BatcherDOMParserFactory batcherDOMParserFactory = BatcherDOMParserFactory.getInstance();
        for (String string2 : this.getParticipantIdList()) {
            int n2 = this.getActiveTransactionCount(string2);
            String string3 = this.getDataDestinationId() + "_" + string2;
            ProcessWatermark processWatermark = batcherDOMParserFactory.getProcessWatermark(string3);
            if (processWatermark == null) {
                ProcessWatermark processWatermark2 = batcherDOMParserFactory.getProcessWatermark(this.getDataDestinationId());
                processWatermark = ObjectUtilities.deepClone(processWatermark2);
                batcherDOMParserFactory.setProcessWatermark(string3, processWatermark);
            }
            Util_Logger.info(logger, "Setting AEMO Inbox directory file count to " + n2 + " for participant [" + string2 + "] process flow control");
            processWatermark.setAEMOInboxFileCount(n2);
        }
    }

    protected abstract Map<String, fsFileInfo> getAEMOInboxDirList(String var1) throws ApplicationException;

    @Override
    protected boolean processFileCheck(fsFileInfo fsFileInfo2, Map<String, fsFileInfo> map, boolean bl) {
        boolean bl2 = false;
        try {
            String string = null;
            if (fsFileInfo2.getEventData().getEventParameters() != null) {
                string = fsFileInfo2.getEventData().getEventParameters().get("ParticipantId");
            }
            if (!Util.isBlank(string)) {
                boolean bl3 = false;
                Map<String, fsFileInfo> map2 = this.getAEMOInboxDirList(string);
                if (map2 != null) {
                    bl3 = map2.containsKey(fsFileInfo2.getFilename().toLowerCase());
                }
                if (!bl3) {
                    String string2 = this.getDataDestinationId() + "_" + string;
                    BatcherDOMParserFactory batcherDOMParserFactory = BatcherDOMParserFactory.getInstance();
                    ProcessWatermark processWatermark = batcherDOMParserFactory.getProcessWatermark(string2);
                    bl2 = processWatermark != null ? processWatermark.canSendFile() : true;
                }
            } else {
                Util_Logger.warning(logger, "Unable to extract [ParticipantId] from file [" + fsFileInfo2.getFilename() + "], not processing file");
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Unable to perform file process check for [" + fsFileInfo2.getFilename() + "] : " + exception.getMessage(), exception);
        }
        return bl2;
    }

    protected void processAcknowledgementPerformanceData(fsFileInfo fsFileInfo2, Date date) throws Exception {
        xmlTransactionFileParser xmlTransactionFileParser2 = new xmlTransactionFileParser(this.getSchemaDefinitionDataSource(), this.getHoldingDir());
        aseXMLDocumentInfo aseXMLDocumentInfo2 = xmlTransactionFileParser2.Parse(fsFileInfo2.getPath());
        pdrPerformanceRec pdrPerformanceRec2 = new pdrPerformanceRec();
        pdrPerformanceRec2.setDataSource(this.getDataDestinationId());
        pdrPerformanceRec2.setThreadId(Integer.toString(this.getId()));
        pdrPerformanceRec2.setStartDate(date);
        pdrPerformanceRec2.setEndDate(new Date());
        pdrPerformanceRec2.setFilename(fsFileInfo2.getName());
        pdrPerformanceRec2.setFileExtension(fsFileInfo2.getExtension());
        this.populateTransactionData(fsFileInfo2, aseXMLDocumentInfo2);
        pdrPerformanceRec2.setTransactionMetaData(fsFileInfo2.getTransactionMetaData());
        pdrPerformanceRec2.setJobType("DOWNLOAD");
        pdrPerformanceRec2.setJobSize(fsFileInfo2.getSize());
        pdrPerformanceRec2.setJobSizeUnits(pdrPerformanceJobSizeUnits.BYTES);
        pdrPerformanceRec2.setContentCreationDate(fsFileInfo2.getModifiedDate());
        pdrPerformanceRec2.setEventReceivedDate(new Date());
        pdrMonitorManager.getInstance().addRecord(pdrPerformanceRec2);
    }

    @Override
    protected fsProcessStatus processSingleFileAction(fsConnectionInt fsConnectionInt2, fsFileInfo fsFileInfo2, fsFileInfo fsFileInfo3, String string, fsConnectionInt fsConnectionInt3, String string2, Map<String, fsFileInfo> map, boolean bl, boolean bl2) {
        fsProcessStatus fsProcessStatus2 = new fsProcessStatus();
        try {
            if (!this.checkReceivingParticipantIsStopped(fsFileInfo2, fsFileInfo3)) {
                if (fsConnectionInt3.logOperations()) {
                    Util_Logger.info(logger, "Now sending " + fsFileInfo3.getFilename() + " to " + string2 + " in thread " + this.getId());
                }
                if (this.getConfig().AllowOverwrite && fsConnectionInt3.exists(string2, fsFileInfo3.getFilename())) {
                    fsConnectionInt3.deleteFile(string2, fsFileInfo3.getFilename());
                }
                fsProcessStatus2 = fsConnectionInt3.putFile(fsFileInfo3, string2, bl2, null);
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Detected error sending aseXML transaction [" + fsFileInfo3.getFilename() + "]: " + exception.getMessage() + " in thread " + this.getId(), exception);
        }
        return fsProcessStatus2;
    }
}

