/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Processor;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.FTP.FtpException;
import au.com.aemo.Common.FileSystem.FilesystemManager;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryInt;
import au.com.aemo.Common.FileSystem.fsConnectionFileFilter;
import au.com.aemo.Common.FileSystem.fsConnectionInt;
import au.com.aemo.Common.FileSystem.fsEventData;
import au.com.aemo.Common.FileSystem.fsEventListenerInt;
import au.com.aemo.Common.FileSystem.fsFileComparatorInt;
import au.com.aemo.Common.FileSystem.fsFileComparatorManager;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.FileSystem.fsProcessStatus;
import au.com.aemo.Common.FileSystem.fsTransactionMetaData;
import au.com.aemo.Common.Files.FileMaskSpecification;
import au.com.aemo.Common.Files.FileNameTokenResolver;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.Java.ObjectUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Jobs.LockManager;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Threading.threadMonitorCPU;
import au.com.aemo.Common.Threading.threadMonitorStatusItem;
import au.com.nemmco.Pdr.Batcher.Processor.Util.pdrBatcherHandlerDownloadFile;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerConfig;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerConfigTranslator;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerInt;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationUtil;
import au.com.nemmco.Pdr.Batcher.pdrBatcher;
import au.com.nemmco.Pdr.Batcher.pdrFileEventInt;
import au.com.nemmco.Pdr.Common.Monitor.pdrMonitorManager;
import au.com.nemmco.Pdr.Common.Monitor.pdrPerformanceJobSizeUnits;
import au.com.nemmco.Pdr.Common.Monitor.pdrPerformanceRec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class pdrBatcherHandlerBase
implements pdrBatcherHandlerInt,
fsEventListenerInt {
    private static Logger logger = LoggerFactory.getLogger(pdrBatcherHandlerBase.class);
    private static final Pattern gasIntReportRegexPattern = Pattern.compile(".*(?<IntReportNo>int\\d+[a-z]?)_v(?<Version>\\d+)_.*", 2);
    private pdrBatcherHandlerConfig itsConfig;
    private int itsId;
    private String itsDelivery;
    private String itsOperation;
    private FileMaskSpecification itsFileMaskSpec;
    private int itsMinFileSizeBytes;
    private int itsMaxFileSizeKB;
    private int itsPollingInterval;
    private String itsSchedulingMode;
    private String itsCronJobSchedule;
    private int itsPauseInterval;
    private int itsFailWaitInterval;
    private String itsDestinationDir;
    private String itsSourceDir;
    private String itsHoldingDir;
    private String itsSourceArchiveDir;
    private volatile boolean itsIsRunning = true;
    private volatile boolean itsIsActive = true;
    private volatile boolean itsIsReady = true;
    private volatile boolean itsIsProcessing = false;
    private volatile boolean itsIsRunningInThread = false;
    private pdrBatcher itsParent;
    private boolean itsActivityMonitor;
    private List<String> itsSubDirList;
    private boolean itsSubDirListDest;
    private char itsSourceSeparator;
    private char itsDestinationSeparator;
    private boolean itsDirectoryRecurse;
    private boolean itsDirectoryCreate;
    private int itsTrottleBytesPerSecond;
    private int itsTransferBufferSize;
    private int itsProcessLimitFiles;
    private String itsProcessOrder;
    private fsConnectionFactoryInt itsDataSource;
    private fsConnectionFactoryInt itsDataDestination;
    private String itsDataSourceId;
    private String itsDataDestinationId;
    private pdrFileEventInt itsFileEventHandler;
    private volatile long itsTotalFilesProcessed;
    private volatile double itsSourceTotalKiloBytesTransferred;
    private volatile double itsDestinationTotalKiloBytesTransferred;
    private volatile Date itsLastProcessTime;
    private volatile threadMonitorCPU itsCpuProcessStats;
    private String itsDestinationDirListingFile;
    private List<pdrBatcherHandlerConfigTranslator> itsFileTranslators;
    private boolean itsCheckFileIntegrity;
    private String itsJobType;
    private String itsSourceFilenameMask;
    private String itsDestinationFilenameMask;
    private String itsSourceAckDir;
    private List<pdrBatcherHandlerConfigTranslator> itsSourceAckTranslators;
    private String itsSourceAckAPIHeaderValues;
    private String itsSourceDirListURL;
    private String itsSourceDirListAPIHeaderValues;
    private String itsSourceAPIHeaderValues;
    private String itsDestinationAPIHeaderValues;
    private String itsAPIBusinessResponseCodes;
    private String itsHubManagementAPIURL;
    private String itsHubManagementAPIHeaderValues;
    private String itsEventDataSource;
    private String itsEventDataSourceBinding;
    private boolean itsReportTranslatorProcessChain;
    private transient List<Integer> itsAPIBusinessResponseCodeList;
    private Object itsWaitLock = new Object();

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Abstract class used by trusted internal classes")
    public pdrBatcherHandlerBase(pdrBatcherHandlerConfig pdrBatcherHandlerConfig2) throws ApplicationException {
        this.configOverride(pdrBatcherHandlerConfig2);
        this.itsConfig = pdrBatcherHandlerConfig2;
        this.itsId = pdrBatcherHandlerConfig2.ThreadId;
        this.itsDelivery = pdrBatcherHandlerConfig2.ThreadDelivery;
        this.itsOperation = pdrBatcherHandlerConfig2.Operation;
        this.itsPollingInterval = pdrBatcherHandlerConfig2.PollingIntervalMilliSecs;
        this.itsPauseInterval = (int)Math.max(pdrBatcherHandlerConfig2.PauseIntervalSecs * 1000.0, 0.0);
        this.itsFailWaitInterval = pdrBatcherHandlerConfig2.FailWaitIntervalSecs * 1000;
        this.itsSchedulingMode = pdrBatcherHandlerConfig2.SchedulingMode;
        this.itsCronJobSchedule = pdrBatcherHandlerConfig2.CronJobSchedule;
        this.itsTrottleBytesPerSecond = pdrBatcherHandlerConfig2.TrottleBytesPerSecond;
        this.itsTransferBufferSize = pdrBatcherHandlerConfig2.TransferBufferSize;
        this.itsProcessLimitFiles = pdrBatcherHandlerConfig2.ProcessLimitFiles;
        this.itsProcessOrder = pdrBatcherHandlerConfig2.FileProcessOrder;
        this.itsHoldingDir = pdrBatcherHandlerConfig2.HoldingDir;
        this.itsParent = pdrBatcherHandlerConfig2.Parent;
        this.itsActivityMonitor = pdrBatcherHandlerConfig2.ThreadActivityMonitor;
        this.itsFileEventHandler = pdrBatcherHandlerConfig2.FileEventHandler;
        this.itsCheckFileIntegrity = pdrBatcherHandlerConfig2.CheckFileIntegrity;
        if (pdrBatcherHandlerConfig2.SubDirList != null) {
            this.itsSubDirList = pdrBatcherHandlerConfig2.SubDirList;
        }
        this.itsSubDirListDest = pdrBatcherHandlerConfig2.SubDirListDest;
        this.itsDirectoryRecurse = pdrBatcherHandlerConfig2.DirectoryRecurse;
        this.itsDirectoryCreate = pdrBatcherHandlerConfig2.DirectoryCreate;
        this.itsFileMaskSpec = pdrBatcherHandlerConfig2.FileMaskSpec;
        this.itsMinFileSizeBytes = pdrBatcherHandlerConfig2.MinFileSizeBytes;
        this.itsMaxFileSizeKB = pdrBatcherHandlerConfig2.MaxFileSizeKB;
        FilesystemManager filesystemManager = FilesystemManager.getInstance();
        this.itsDataSourceId = pdrBatcherHandlerConfig2.DataSource;
        this.itsDataDestinationId = pdrBatcherHandlerConfig2.DataDestination;
        this.itsDataSource = filesystemManager.getDataSourceFactory(Util.isBlank(pdrBatcherHandlerConfig2.DataSourceProtocol, "LOCAL"));
        if (this.itsDataSource == null) {
            Util_Logger.error(logger, "Invalid data source in thread " + this.itsId);
        }
        this.itsDataDestination = filesystemManager.getDataSourceFactory(Util.isBlank(pdrBatcherHandlerConfig2.DataDestinationProtocol, "LOCAL"));
        if (this.itsDataDestination == null) {
            Util_Logger.error(logger, "Invalid data destination in thread " + this.itsId);
        }
        this.itsSourceDir = pdrBatcherHandlerConfig2.SourceDir;
        this.itsSourceSeparator = this.itsSourceDir.endsWith("\\") ? (char)92 : (char)47;
        this.itsDestinationDir = pdrBatcherHandlerConfig2.DestinationDir;
        this.itsDestinationSeparator = this.itsDestinationDir.endsWith("\\") ? (char)92 : (char)47;
        this.itsSourceArchiveDir = pdrBatcherHandlerConfig2.SourceArchiveDir;
        this.itsDestinationDirListingFile = pdrBatcherHandlerConfig2.DestinationDirListingFile;
        this.itsFileTranslators = pdrBatcherHandlerConfig2.FileTranslators;
        this.itsJobType = pdrBatcherHandlerConfig2.JobType;
        this.itsSourceFilenameMask = pdrBatcherHandlerConfig2.SourceFilenameMask;
        this.itsDestinationFilenameMask = pdrBatcherHandlerConfig2.DestinationFilenameMask;
        this.itsSourceAckDir = pdrBatcherHandlerConfig2.SourceAckDir;
        this.itsSourceAckTranslators = pdrBatcherHandlerConfig2.SourceAckTranslators;
        this.itsSourceAckAPIHeaderValues = pdrBatcherHandlerConfig2.SourceAckAPIHeaderValues;
        this.itsSourceDirListURL = pdrBatcherHandlerConfig2.SourceDirListURL;
        this.itsSourceDirListAPIHeaderValues = pdrBatcherHandlerConfig2.SourceDirListAPIHeaderValues;
        this.itsSourceAPIHeaderValues = pdrBatcherHandlerConfig2.SourceAPIHeaderValues;
        this.itsDestinationAPIHeaderValues = pdrBatcherHandlerConfig2.DestinationAPIHeaderValues;
        this.itsAPIBusinessResponseCodes = pdrBatcherHandlerConfig2.APIBusinessResponseCodes;
        this.itsAPIBusinessResponseCodeList = new ArrayList<Integer>();
        if (!Util.isBlank(this.itsAPIBusinessResponseCodes)) {
            List<String> list = Util.getList(this.itsAPIBusinessResponseCodes, ',');
            for (String string : list) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                if (!Util.isBlank(string)) {
                    if (string.indexOf("-") > 0) {
                        String[] stringArray = Util.getColumns(string, '-');
                        if (stringArray.length == 2) {
                            try {
                                int n2 = Integer.parseInt(stringArray[0]);
                                int n3 = Integer.parseInt(stringArray[1]);
                                for (int i2 = n2; i2 <= n3; ++i2) {
                                    arrayList.add(i2);
                                }
                            }
                            catch (Exception exception) {
                                Util_Logger.error(logger, "Detected invalid API response code range [" + string + "]");
                            }
                        } else {
                            Util_Logger.error(logger, "Detected invalid API response code range [" + string + "]");
                        }
                    } else if (Util.isInteger(string)) {
                        arrayList.add(Integer.parseInt(string));
                    } else {
                        Util_Logger.error(logger, "Detected invalid API response code [" + string + "]");
                    }
                }
                this.itsAPIBusinessResponseCodeList.addAll(arrayList);
            }
        }
        this.itsHubManagementAPIURL = pdrBatcherHandlerConfig2.HubManagementAPIURL;
        this.itsHubManagementAPIHeaderValues = pdrBatcherHandlerConfig2.HubManagementAPIHeaderValues;
        this.itsTotalFilesProcessed = 0L;
        this.itsSourceTotalKiloBytesTransferred = 0.0;
        this.itsDestinationTotalKiloBytesTransferred = 0.0;
        this.itsCpuProcessStats = new threadMonitorCPU(0L);
        this.itsEventDataSource = pdrBatcherHandlerConfig2.EventDataSource;
        this.itsEventDataSourceBinding = pdrBatcherHandlerConfig2.EventDataSourceBinding;
        this.itsReportTranslatorProcessChain = pdrBatcherHandlerConfig2.ReportTranslatorProcessChain;
        this.itsIsReady = true;
    }

    protected void configOverride(pdrBatcherHandlerConfig pdrBatcherHandlerConfig2) {
    }

    @Override
    public void clearDataState() {
    }

    protected abstract boolean requiresDestinationDirectoryListing();

    protected abstract boolean processFileCheck(fsFileInfo var1, Map<String, fsFileInfo> var2, boolean var3);

    protected abstract boolean removeSourceFileAfterProcessing();

    protected abstract boolean downloadSourceFile();

    protected abstract fsProcessStatus processSingleFileAction(fsConnectionInt var1, fsFileInfo var2, fsFileInfo var3, String var4, fsConnectionInt var5, String var6, Map<String, fsFileInfo> var7, boolean var8, boolean var9);

    protected abstract boolean logDirectoryEntry();

    protected abstract void startPollCycle(String var1);

    protected abstract void preProcessSourceDirList(String var1, List<fsFileInfo> var2) throws ApplicationException;

    protected abstract void completePollCycle(String var1);

    protected abstract void startPollCycleDirectory(String var1);

    private void logStart(String string, List<String> list) {
        String string2 = "Getting ";
        StringBuilder stringBuilder = new StringBuilder(string2);
        if (this.itsFileMaskSpec != null) {
            stringBuilder.append(this.itsFileMaskSpec.getMaskDescriptionForLog());
        }
        stringBuilder.append(" from directory " + string);
        stringBuilder.append(" to");
        for (String string3 : list) {
            stringBuilder.append(" ");
            stringBuilder.append(string3);
        }
        stringBuilder.append(" in thread ID " + this.getId());
        Util_Logger.info(logger, stringBuilder.toString());
    }

    @Override
    public int getId() {
        return this.itsId;
    }

    public String getDescription() {
        return this.getOperation() + "_" + this.getId();
    }

    @Override
    public String getOperation() {
        return this.itsOperation;
    }

    @Override
    public pdrBatcherHandlerConfig getConfig() {
        return this.itsConfig;
    }

    private boolean getIsRunning() {
        return this.itsIsRunning;
    }

    @Override
    public String getDelivery() {
        return this.itsDelivery;
    }

    @Override
    public boolean getActivityMonitor() {
        return this.itsActivityMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyNewFileEvent() {
        Object object = this.itsWaitLock;
        synchronized (object) {
            this.itsWaitLock.notify();
        }
    }

    private void updateProcessStats() {
        long l2 = 0L;
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        if (threadMXBean.isCurrentThreadCpuTimeSupported()) {
            l2 = threadMXBean.getCurrentThreadCpuTime();
        }
        this.itsCpuProcessStats = new threadMonitorCPU(l2);
    }

    private String getDataTransferred(double d2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (d2 < 1024.0) {
            stringBuilder.append(String.format("%,d", (long)d2));
            stringBuilder.append(" kB");
        } else if (d2 < 1048576.0) {
            stringBuilder.append(String.format("%,d", (long)d2 / 1024L));
            stringBuilder.append(" MB");
        } else {
            stringBuilder.append(String.format("%,d", (long)d2 / 0x100000L));
            stringBuilder.append(" GB");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public threadMonitorStatusItem getStatusReport() {
        threadMonitorStatusItem threadMonitorStatusItem2 = new threadMonitorStatusItem(this.itsConfig.Name);
        threadMonitorStatusItem2.addItem("Description", this.itsConfig.Description);
        threadMonitorStatusItem2.addItem("Files processed", this.itsTotalFilesProcessed);
        threadMonitorStatusItem2.addItem("Data transferred (from source)", this.getDataTransferred(this.itsSourceTotalKiloBytesTransferred));
        threadMonitorStatusItem2.addItem("Data transferred (to destination)", this.getDataTransferred(this.itsDestinationTotalKiloBytesTransferred));
        if (this.itsLastProcessTime != null) {
            threadMonitorStatusItem2.addItem("Last Active", Util.dateToStr(this.itsLastProcessTime, "dd/MM/yyyy HH:mm:ss"));
        }
        if (this.itsCpuProcessStats != null) {
            threadMonitorCPU threadMonitorCPU2 = this.itsCpuProcessStats;
            synchronized (threadMonitorCPU2) {
                if (this.itsCpuProcessStats.getCPUTime() > 0L) {
                    threadMonitorStatusItem2.addItem("CPU time", Long.toString(this.itsCpuProcessStats.getCPUTime()) + " " + this.itsCpuProcessStats.getCPUTimeValue());
                }
            }
        }
        threadMonitorStatusItem2.addItem("Delivery", this.itsDelivery);
        threadMonitorStatusItem2.addItem("Status", this.getIsActive() ? "ACTIVE" : "INACTIVE");
        return threadMonitorStatusItem2;
    }

    @Override
    public List<AbstractMap.SimpleEntry> reportSupplementalConfiguration() {
        return new ArrayList<AbstractMap.SimpleEntry>();
    }

    private int getPollingInterval() {
        return this.itsPollingInterval;
    }

    @Override
    public String getSchedulingMode() {
        return this.itsSchedulingMode;
    }

    @Override
    public String getCronJobSchedule() {
        return this.itsCronJobSchedule;
    }

    @Override
    public int getFailWaitInterval() {
        return this.itsFailWaitInterval;
    }

    private int getPauseInterval() {
        return this.itsPauseInterval;
    }

    private int getTrottleBytesPerSecond() {
        return this.itsTrottleBytesPerSecond;
    }

    private int getProcessLimitFiles() {
        return this.itsProcessLimitFiles;
    }

    private String getProcessOrder() {
        return this.itsProcessOrder;
    }

    protected boolean getDirectoryRecurse() {
        return this.itsDirectoryRecurse;
    }

    protected String getHoldingDir() {
        return this.itsHoldingDir;
    }

    protected boolean getCheckFileIntegrity() {
        return this.itsCheckFileIntegrity;
    }

    protected List<String> getDestinationDir(String string) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray = Util.getColumns(this.itsDestinationDir, ',')) {
            Object object = string2;
            if (!Util.isBlank(string)) {
                object = string2.endsWith(Character.toString(this.itsDestinationSeparator)) ? string2 + string : string2 + this.itsDestinationSeparator + string;
            }
            arrayList.add((String)object);
        }
        return arrayList;
    }

    protected String getSourceDir() {
        return this.itsSourceDir;
    }

    protected String getSourceDir(String string, String string2) {
        if (Util.isBlank(string2)) {
            return string;
        }
        if (string.endsWith(Character.toString(this.itsSourceSeparator))) {
            return string + string2;
        }
        return string + this.itsSourceSeparator + string2;
    }

    @Override
    public boolean getDataSourceIsEventBased() {
        return this.getSchedulingMode().equalsIgnoreCase("EVENT");
    }

    @Override
    public String getEventDataSource() {
        return this.itsEventDataSource;
    }

    @Override
    public String getEventDataSourceBinding() {
        return this.itsEventDataSourceBinding;
    }

    @Override
    public String getEventConsumerId() {
        if (this.getSchedulingMode().equalsIgnoreCase("EVENT")) {
            return Util.isBlank(this.getDescription(), "Thread ID [" + this.itsId + "]");
        }
        return null;
    }

    @Override
    public boolean getIsShutdown() {
        if (this.itsIsRunningInThread) {
            return !this.itsIsReady;
        }
        return !this.itsIsProcessing;
    }

    @Override
    public void stop() {
        this.itsIsRunning = false;
    }

    @Override
    public boolean getIsActive() {
        return this.itsIsActive;
    }

    @Override
    public void setIsActive(boolean bl) {
        this.itsIsActive = bl;
    }

    private pdrBatcherHandlerConfigTranslator getFileTranslator(fsFileInfo fsFileInfo2) {
        pdrBatcherHandlerConfigTranslator pdrBatcherHandlerConfigTranslator2 = null;
        if (fsFileInfo2 != null && this.itsFileTranslators != null) {
            for (pdrBatcherHandlerConfigTranslator pdrBatcherHandlerConfigTranslator3 : this.itsFileTranslators) {
                if (!Util.wildCardMatch(pdrBatcherHandlerConfigTranslator3.IncludeFileMask, fsFileInfo2.getFilename())) continue;
                pdrBatcherHandlerConfigTranslator2 = pdrBatcherHandlerConfigTranslator3;
                break;
            }
        }
        return pdrBatcherHandlerConfigTranslator2;
    }

    private pdrBatcherHandlerConfigTranslator getAckTranslator(fsFileInfo fsFileInfo2) {
        pdrBatcherHandlerConfigTranslator pdrBatcherHandlerConfigTranslator2 = null;
        if (fsFileInfo2 != null && this.itsSourceAckTranslators != null) {
            for (pdrBatcherHandlerConfigTranslator pdrBatcherHandlerConfigTranslator3 : this.itsSourceAckTranslators) {
                if (!Util.wildCardMatch(pdrBatcherHandlerConfigTranslator3.IncludeFileMask, fsFileInfo2.getFilename())) continue;
                pdrBatcherHandlerConfigTranslator2 = pdrBatcherHandlerConfigTranslator3;
                break;
            }
        }
        return pdrBatcherHandlerConfigTranslator2;
    }

    private fsFileInfo getSourceFile(fsConnectionInt fsConnectionInt2, fsFileInfo fsFileInfo2) throws Exception {
        fsFileInfo2.addAPIHeaderValues(this.getSourceAPIHeaderValues());
        String string = fsFileInfo2.getDirectory();
        String string2 = FileNameTokenResolver.process(string, fsFileInfo2);
        fsFileInfo2.setDirectory(string2);
        fsFileInfo2.addAckAPIHeaderValues(this.itsSourceAckAPIHeaderValues);
        pdrBatcherHandlerDownloadFile pdrBatcherHandlerDownloadFile2 = new pdrBatcherHandlerDownloadFile(this.getHoldingDir(), this.itsCheckFileIntegrity);
        return pdrBatcherHandlerDownloadFile2.getSourceFile(fsConnectionInt2, fsFileInfo2, this.itsId, "source", this.itsSourceFilenameMask);
    }

    private List<fsFileInfo> transformSourceFile(fsFileInfo fsFileInfo2) throws Exception {
        List<fsFileInfo> list = pdrFileTranslationUtil.transformSourceFile(fsFileInfo2, this.getFileTranslator(fsFileInfo2), this.itsHoldingDir, this.itsId);
        for (fsFileInfo fsFileInfo3 : list) {
            fsFileInfo3.addAPIHeaderValues(this.itsDestinationAPIHeaderValues);
            fsFileInfo3.processFilenameMask(this.itsSourceFilenameMask);
        }
        for (fsFileInfo fsFileInfo3 : list) {
            fsEventData fsEventData2 = fsFileInfo3.getEventData();
            if (fsEventData2 == null) {
                fsEventData2 = new fsEventData();
                fsFileInfo3.setEventData(fsEventData2);
            }
            fsEventData2.setAPIBusinessResponseCodes(this.itsAPIBusinessResponseCodeList);
        }
        return list;
    }

    private List<fsFileInfo> transformAckFile(fsFileInfo fsFileInfo2) throws ApplicationException {
        List<fsFileInfo> list = pdrFileTranslationUtil.transformSourceFile(fsFileInfo2, this.getAckTranslator(fsFileInfo2), this.itsHoldingDir, this.itsId);
        return list;
    }

    private void deriveParametersFromFile(fsFileInfo fsFileInfo2, pdrPerformanceRec pdrPerformanceRec2) {
        String string = null;
        String string2 = null;
        fsTransactionMetaData fsTransactionMetaData2 = fsFileInfo2.getTransactionMetaData();
        pdrPerformanceRec2.setTransactionMetaData(fsTransactionMetaData2);
        String[] stringArray = fsFileInfo2.getName().split("_");
        if (stringArray.length > 1) {
            Matcher matcher = gasIntReportRegexPattern.matcher(fsFileInfo2.getName());
            if (matcher.matches()) {
                string = matcher.group("IntReportNo").toUpperCase();
                String string3 = stringArray[stringArray.length - 1];
                String[] stringArray2 = string3.split("~");
                string2 = stringArray2[0].equalsIgnoreCase("1") ? "PUBLIC" : "PRIVATE";
                pdrPerformanceRec2.setFileId(string);
                pdrPerformanceRec2.setConfidentiality(string2);
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                string2 = stringArray[0].equalsIgnoreCase("PUBLIC") ? "PUBLIC" : "PRIVATE";
                for (int i2 = 1; i2 < stringArray.length && !Util.isInteger(stringArray[i2]); ++i2) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("_");
                    }
                    stringBuilder.append(stringArray[i2]);
                }
                if (stringBuilder.length() > 0) {
                    string = stringBuilder.toString();
                }
                if (Util.isBlank(pdrPerformanceRec2.getFileId())) {
                    pdrPerformanceRec2.setFileId(string);
                }
                pdrPerformanceRec2.setConfidentiality(string2);
            }
        }
    }

    protected fsConnectionFileFilter getFileFilter() {
        String string = null;
        if (!this.itsDirectoryRecurse && this.itsFileMaskSpec != null) {
            string = this.itsFileMaskSpec.getDirectoryListFileMask();
        }
        fsConnectionFileFilter fsConnectionFileFilter2 = new fsConnectionFileFilter();
        fsConnectionFileFilter2.setServerDirectoryListingFileMask(string);
        fsConnectionFileFilter2.setOutputFilenameMask(this.itsDestinationFilenameMask);
        fsConnectionFileFilter2.setAPIHeaderValues(this.itsSourceAPIHeaderValues);
        fsConnectionFileFilter2.setDirListAPIHeaderValues(this.itsSourceDirListAPIHeaderValues);
        fsConnectionFileFilter2.setAckAPIHeaderValues(this.itsSourceAckAPIHeaderValues);
        return fsConnectionFileFilter2;
    }

    protected Map<String, fsFileInfo> pollSourceConnection(fsConnectionInt fsConnectionInt2, String string) throws Exception {
        return fsConnectionInt2.listFiles(string, this.getFileFilter(), this.getEventConsumerId());
    }

    private Map<String, fsFileInfo> pollSourceMap(fsConnectionInt fsConnectionInt2, String string) throws Exception {
        HashMap<String, fsFileInfo> hashMap = new HashMap<String, fsFileInfo>();
        Map<String, fsFileInfo> map = this.pollSourceConnection(fsConnectionInt2, string);
        if (map != null) {
            for (fsFileInfo fsFileInfo2 : map.values()) {
                if (fsFileInfo2.isDirectory()) {
                    if (!this.itsDirectoryRecurse) continue;
                    hashMap.put(fsFileInfo2.getFilename(), fsFileInfo2);
                    continue;
                }
                boolean bl = this.itsFileMaskSpec.checkFileMask(fsFileInfo2.getFilename());
                boolean bl2 = false;
                if (this.itsMinFileSizeBytes < 0) {
                    bl2 = true;
                } else if (fsFileInfo2.getSize() == null) {
                    Util_Logger.warning(logger, "Data source [" + fsConnectionInt2.getDataSourceId() + "] does not support file size attributes, ignoring thread minimum size threshold");
                    bl2 = true;
                } else if (fsFileInfo2.getSize() > (long)this.itsMinFileSizeBytes) {
                    bl2 = true;
                } else {
                    Util_Logger.debug(logger, "Skipping file " + fsFileInfo2.getFilename() + ", size = " + fsFileInfo2.getSize() + " bytes, minimum size > " + this.itsMinFileSizeBytes + " bytes");
                }
                boolean bl3 = false;
                if (this.itsMaxFileSizeKB < 0) {
                    bl3 = true;
                } else if (fsFileInfo2.getSize() == null) {
                    Util_Logger.warning(logger, "Data source [" + fsConnectionInt2.getDataSourceId() + "] does not support file size attributes, ignoring thread maximum size threshold");
                    bl3 = true;
                } else if (fsFileInfo2.getSize() <= (long)(this.itsMaxFileSizeKB * 1024)) {
                    bl3 = true;
                } else {
                    Util_Logger.debug(logger, "Skipping file " + fsFileInfo2.getFilename() + ", size = " + fsFileInfo2.getSize() + " bytes, maximum size <= " + this.itsMaxFileSizeKB + " kB");
                }
                if (!bl || !bl2 || !bl3) continue;
                hashMap.put(fsFileInfo2.getFilename(), fsFileInfo2);
            }
        }
        return hashMap;
    }

    protected List<fsFileInfo> pollSource(fsConnectionInt fsConnectionInt2, String string, String string2) throws Exception {
        ArrayList<fsFileInfo> arrayList = new ArrayList<fsFileInfo>(this.pollSourceMap(fsConnectionInt2, string2).values());
        fsFileComparatorInt fsFileComparatorInt2 = fsFileComparatorManager.getInstance().getComparator(this.getProcessOrder());
        if (fsFileComparatorInt2.requiresTimestamp()) {
            if (fsConnectionInt2.supportsFileTimestamps()) {
                Collections.sort(arrayList, fsFileComparatorInt2);
            } else {
                Util_Logger.warning(logger, "Sort order of " + this.getProcessOrder() + " not supported in source " + fsConnectionInt2.getDataSourceId());
            }
        } else {
            Collections.sort(arrayList, fsFileComparatorInt2);
        }
        return arrayList;
    }

    protected void fileProcessSuccess(fsFileInfo fsFileInfo2) {
        fsFileInfo2.setCompleted(true);
        if (this.itsActivityMonitor) {
            this.itsParent.updateLastBusyTime(this.getDataSourceId());
        }
        this.itsLastProcessTime = new Date();
        if (this.itsFileEventHandler != null) {
            try {
                this.itsFileEventHandler.fileProcess(fsFileInfo2.getFilename());
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Error calling batcher event handler: " + exception.getMessage(), exception);
            }
        }
    }

    private void fileProcessTargetSuccess(String string, String string2) {
        if (this.itsFileEventHandler != null) {
            try {
                this.itsFileEventHandler.fileProcessToTarget(string, string2);
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Error calling batcher targetted event handler: " + exception.getMessage(), exception);
            }
        }
    }

    private int processSingleDirectory(fsConnectionInt fsConnectionInt2, String string, String string2, fsFileInfo fsFileInfo2, List<String> list) throws ApplicationException {
        int n2 = 0;
        if (fsFileInfo2.isDirectory() && this.getDirectoryRecurse()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string3 = string2 + "/" + fsFileInfo2.getFilename();
            for (String string4 : list) {
                Object object = string4;
                if (this.itsSubDirListDest) {
                    object = (String)object + "/" + fsFileInfo2.getFilename();
                }
                arrayList.add((String)object);
            }
            n2 = this.pollAndProcessDirectory(string, string3, arrayList, fsConnectionInt2);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="this.itsTotalFilesProcessed only ever incremented by a single thread, but read by other threads")
    private boolean processSingleFile(fsConnectionInt fsConnectionInt2, String string, String string2, fsFileInfo fsFileInfo2, fsConnectionInt fsConnectionInt3, List<String> list, List<Map<String, fsFileInfo>> list2) throws ApplicationException {
        boolean bl;
        block53: {
            bl = false;
            LockManager lockManager = LockManager.getInstance();
            try {
                block54: {
                    if (!lockManager.addTask(fsFileInfo2.getUniqueId())) break block53;
                    try {
                        fsFileInfo fsFileInfo3;
                        Object exception;
                        if (!fsConnectionInt2.exists(fsFileInfo2) || fsFileInfo2.isCompleted()) break block54;
                        fsConnectionInt2.lockFile(fsFileInfo2);
                        if (!fsFileInfo2.canProcessLockCheck()) break block54;
                        Date date = new Date();
                        fsFileInfo2.processFilenameMask(this.itsSourceFilenameMask);
                        fsFileInfo fsFileInfo4 = null;
                        List<fsFileInfo> list3 = null;
                        fsProcessStatus fsProcessStatus2 = null;
                        for (int i2 = 0; i2 < list.size(); ++i2) {
                            void var19_33;
                            boolean bl2 = i2 == 0;
                            boolean bl3 = i2 == list.size() - 1;
                            String object3 = list.get(i2);
                            exception = object3;
                            if (fsFileInfo2.getEventData() != null && fsFileInfo2.getEventData().getEventParameters() != null) {
                                exception = FileNameTokenResolver.process(object3, fsFileInfo2.getEventData().getEventParameters());
                            }
                            Object l2 = null;
                            if (this.requiresDestinationDirectoryListing()) {
                                Map<String, fsFileInfo> map = list2.get(i2);
                            }
                            if (!this.processFileCheck(fsFileInfo2, (Map<String, fsFileInfo>)var19_33, bl2)) continue;
                            fsFileInfo2.incrementProcessAttempts();
                            if (this.downloadSourceFile()) {
                                if (fsFileInfo4 == null) {
                                    fsFileInfo4 = this.getSourceFile(fsConnectionInt2, fsFileInfo2);
                                }
                            } else {
                                fsFileInfo4 = fsFileInfo2;
                            }
                            if (fsFileInfo4 == null) continue;
                            if (list3 == null) {
                                list3 = this.transformSourceFile(fsFileInfo4);
                            }
                            boolean bl4 = false;
                            if (list3 != null) {
                                bl4 = true;
                                for (fsFileInfo fsFileInfo5 : list3) {
                                    String string3 = FileNameTokenResolver.process((String)exception, fsFileInfo2);
                                    fsProcessStatus2 = this.processSingleFileAction(fsConnectionInt2, fsFileInfo2, fsFileInfo5, string2, fsConnectionInt3, string3, (Map<String, fsFileInfo>)var19_33, bl2, bl3);
                                    bl4 &= fsProcessStatus2.getProcessStatus();
                                }
                            }
                            if (!bl4) continue;
                            this.fileProcessTargetSuccess(fsFileInfo4.getFilename(), (String)exception);
                            bl = true;
                        }
                        if (bl && fsProcessStatus2 != null && (fsFileInfo3 = fsProcessStatus2.getAcknowledgementResponse()) != null) {
                            fsFileInfo3.addEventParameter("process_status", Boolean.toString(fsProcessStatus2.getProcessStatus()));
                            List<fsFileInfo> list4 = this.transformAckFile(fsProcessStatus2.getAcknowledgementResponse());
                            for (fsFileInfo fsFileInfo6 : list4) {
                                exception = FileNameTokenResolver.process(this.itsSourceAckDir, fsFileInfo6);
                                Util_Logger.info(logger, "Archiving acknowledgement file [" + fsFileInfo6.getFilename() + "] to " + (String)exception);
                                fsConnectionInt2.putFile(fsFileInfo6, (String)exception, true, null);
                            }
                        }
                        FileUtilities.deleteFile(this.getHoldingDir() + "/" + fsFileInfo2.getFilename());
                        if (bl) {
                            block55: {
                                ++this.itsTotalFilesProcessed;
                                double d2 = (double)fsFileInfo4.getSize().longValue() / 1024.0;
                                this.itsSourceTotalKiloBytesTransferred += d2;
                                double d3 = 0.0;
                                for (fsFileInfo fsFileInfo7 : list3) {
                                    d3 += (double)fsFileInfo7.getSize().longValue() / 1024.0;
                                }
                                this.itsDestinationTotalKiloBytesTransferred += d3;
                                FilesystemManager.getInstance().updateReceiveActivity(this.itsDataSourceId, 1, d2);
                                FilesystemManager.getInstance().updateSendActivity(this.itsDataDestinationId, list3.size(), d3);
                                if (!Util.isBlank(this.itsSourceArchiveDir)) {
                                    try {
                                        if (fsProcessStatus2 != null) {
                                            fsFileInfo2.addEventParameter("process_status", Boolean.toString(fsProcessStatus2.getProcessStatus()));
                                        }
                                        exception = FileNameTokenResolver.process(this.itsSourceArchiveDir, fsFileInfo2);
                                        if (string2.length() > string.length()) {
                                            int n2 = string.length();
                                            exception = (String)exception + string2.substring(n2);
                                        }
                                        if (this.itsDirectoryRecurse) {
                                            fsConnectionInt2.makeDir((String)exception);
                                        }
                                        if (fsConnectionInt2.exists((String)exception, fsFileInfo2.getFilename())) {
                                            fsConnectionInt2.deleteFile((String)exception, fsFileInfo2.getFilename());
                                        }
                                        if (fsFileInfo2.processWithLock() && fsFileInfo2.hasValidLock()) {
                                            fsFileInfo2.releaseLock();
                                        }
                                        fsConnectionInt2.renameFile(string2, fsFileInfo2.getFilename(), (String)exception, fsFileInfo2.getFilename());
                                    }
                                    catch (FtpException ftpException) {
                                        if (ftpException.getReplyCode() == 550) {
                                            Util_Logger.debug(logger, "Detected FTP get file contention error: " + ftpException.getReplyCode() + ", " + ftpException.getMessage() + " in thread " + this.getId());
                                            break block55;
                                        }
                                        Util_Logger.warning(logger, "Detected problem with archive of " + fsFileInfo2.getFilename() + " in thread ID " + this.getId() + ": " + ftpException.getMessage(), ftpException);
                                    }
                                    catch (Exception exception2) {
                                        Util_Logger.warning(logger, "Detected problem with archive of " + fsFileInfo2.getFilename() + " in thread ID " + this.getId() + ": " + exception2.getMessage(), exception2);
                                    }
                                } else if (this.removeSourceFileAfterProcessing()) {
                                    if (fsConnectionInt2.logOperations()) {
                                        Util_Logger.info(logger, "Now deleting " + fsFileInfo2.getFilename() + " in thread " + this.getId());
                                    }
                                    try {
                                        fsConnectionInt2.deleteFile(fsFileInfo2);
                                    }
                                    catch (FtpException ftpException) {
                                        if (ftpException.getReplyCode() == 550) {
                                            Util_Logger.debug(logger, "Detected FTP get file contention error: " + ftpException.getReplyCode() + ", " + ftpException.getMessage() + " in thread " + this.getId());
                                        } else {
                                            Util_Logger.warning(logger, "Detected problem with delete of " + fsFileInfo2.getFilename() + " in thread ID " + this.getId() + ": " + ftpException.getMessage(), ftpException);
                                        }
                                    }
                                    catch (Exception exception3) {
                                        Util_Logger.warning(logger, "Detected problem with delete of " + fsFileInfo2.getFilename() + " in thread ID " + this.getId() + ": " + exception3.getMessage(), exception3);
                                    }
                                }
                            }
                            exception = new Date();
                            long l2 = ((Date)exception).getTime() - date.getTime();
                            boolean bl5 = false;
                            if (list3 != null) {
                                if (list3.size() == 1) {
                                    fsFileInfo fsFileInfo8 = list3.get(0);
                                    bl5 = !fsFileInfo8.getFilename().equalsIgnoreCase(fsFileInfo2.getFilename());
                                } else if (list3.size() > 1) {
                                    bl5 = true;
                                }
                                if (bl5) {
                                    for (fsFileInfo fsFileInfo9 : list3) {
                                        Util_Logger.info(logger, "Delivered transformed file [" + fsFileInfo9.getFilename() + "] to destination in thread " + this.getId());
                                    }
                                }
                            }
                            Util_Logger.info(logger, "Completed processing of " + fsFileInfo2.getFilename() + " [" + fsFileInfo4.getSize() + " bytes, " + l2 + " ms] in thread " + this.getId());
                            this.fileProcessSuccess(fsFileInfo2);
                            pdrPerformanceRec pdrPerformanceRec2 = new pdrPerformanceRec();
                            pdrPerformanceRec2.setDataSource(this.getDataSourceId());
                            pdrPerformanceRec2.setThreadId(Integer.toString(this.getId()));
                            pdrPerformanceRec2.setStartDate(date);
                            pdrPerformanceRec2.setEndDate((Date)exception);
                            if (!Util.isBlank(fsFileInfo2.getExtension())) {
                                pdrPerformanceRec2.setFilename(fsFileInfo2.getFilename().substring(0, fsFileInfo2.getFilename().length() - fsFileInfo2.getExtension().length() - 1));
                                pdrPerformanceRec2.setFileExtension(fsFileInfo2.getExtension());
                            } else {
                                pdrPerformanceRec2.setFilename(fsFileInfo2.getFilename());
                            }
                            this.deriveParametersFromFile(fsFileInfo2, pdrPerformanceRec2);
                            pdrPerformanceRec2.setJobType(this.itsJobType);
                            pdrPerformanceRec2.setJobSize(fsFileInfo4.getSize());
                            pdrPerformanceRec2.setJobSizeUnits(pdrPerformanceJobSizeUnits.BYTES);
                            if (fsFileInfo2.getModifiedDateExact()) {
                                pdrPerformanceRec2.setContentCreationDate(fsFileInfo2.getModifiedDate());
                            }
                            pdrPerformanceRec2.setEventReceivedDate(fsFileInfo2.getEventReceivedDate());
                            String string4 = Util.dateToStr(date, "yyyyMMddHHmmssSSS");
                            pdrPerformanceRec2.setProcessElementId(Util.dateToStr(date, string4 + "-0"));
                            pdrMonitorManager.getInstance().addRecord(pdrPerformanceRec2);
                            if (this.itsReportTranslatorProcessChain && bl5) {
                                int n3 = 1;
                                for (fsFileInfo fsFileInfo10 : list3) {
                                    pdrPerformanceRec pdrPerformanceRec3 = ObjectUtilities.deepClone(pdrPerformanceRec2);
                                    pdrPerformanceRec3.setFilename(fsFileInfo10.getName());
                                    pdrPerformanceRec3.setFileExtension(fsFileInfo10.getExtension());
                                    pdrPerformanceRec3.setJobSize(fsFileInfo10.getSize());
                                    pdrPerformanceRec3.setProcessElementId(string4 + "-" + n3);
                                    pdrPerformanceRec3.setProcessElementParentId(pdrPerformanceRec2.getProcessElementId());
                                    pdrPerformanceRec3.setConfidentiality(pdrPerformanceRec2.getConfidentiality());
                                    this.deriveParametersFromFile(fsFileInfo10, pdrPerformanceRec3);
                                    pdrMonitorManager.getInstance().addRecord(pdrPerformanceRec3);
                                    ++n3;
                                }
                            }
                            break block54;
                        }
                        if (fsFileInfo4 != null && list3 == null) {
                            // empty if block
                        }
                    }
                    catch (Exception exception) {
                        fsConnectionInt2.releaseFileLock(fsFileInfo2);
                        lockManager.deleteTask(fsFileInfo2.getUniqueId());
                        Util_Logger.error(logger, "Detected error processing file " + fsFileInfo2.getFilename() + " in thread ID " + this.getId(), exception);
                    }
                    finally {
                        fsConnectionInt2.releaseFileLock(fsFileInfo2);
                        lockManager.deleteTask(fsFileInfo2.getUniqueId());
                    }
                }
                try {
                    if (bl) {
                        Thread.sleep(this.getPauseInterval());
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                Util_Logger.error(logger, "Detected problem consuming files from " + string2 + " in thread ID " + this.getId() + ": " + exception.getMessage(), exception);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDirectoryListingFile(fsConnectionInt fsConnectionInt2, List<String> list) throws Exception {
        if (!Util.isBlank(this.itsDestinationDirListingFile)) {
            for (String string : list) {
                Map<String, fsFileInfo> map = fsConnectionInt2.listFiles(string, null, null);
                File file = new File(this.getHoldingDir() + "/" + this.getId() + "/");
                if (file.mkdirs()) {
                    Util_Logger.debug(logger, "Created folder " + file.getPath());
                }
                OutputStreamWriter outputStreamWriter = null;
                PrintWriter printWriter = null;
                try {
                    Object object;
                    File file2 = new File(file, this.itsDestinationDirListingFile);
                    FileUtilities.deleteFile(file2);
                    outputStreamWriter = new FileWriter(file2);
                    printWriter = new PrintWriter(outputStreamWriter);
                    if (this.itsDestinationDirListingFile.toLowerCase().endsWith(".xml")) {
                        object = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
                        printWriter.print("<FILES modified='");
                        printWriter.print(((DateFormat)object).format(new Date()));
                        printWriter.println("'>");
                        for (fsFileInfo fsFileInfo2 : map.values()) {
                            if (fsFileInfo2.isDirectory()) continue;
                            printWriter.print("<FILE name='");
                            printWriter.print(fsFileInfo2.getFilename());
                            printWriter.print("' modified='");
                            printWriter.print(((DateFormat)object).format(fsFileInfo2.getModifiedDate()));
                            printWriter.println("'/>");
                        }
                        printWriter.println("</FILES>");
                    } else {
                        for (fsFileInfo fsFileInfo3 : map.values()) {
                            if (fsFileInfo3.isDirectory()) continue;
                            printWriter.println(fsFileInfo3.getFilename());
                        }
                    }
                    printWriter.flush();
                    outputStreamWriter.flush();
                    printWriter.close();
                    outputStreamWriter.close();
                    object = new fsFileInfo(file2);
                    fsConnectionInt2.putFile((fsFileInfo)object, string, true, null);
                }
                catch (Exception exception) {
                    Util_Logger.errorNoRaise(logger, "Detected problem writing directory listing file for " + string + " in thread ID " + this.getId() + ": " + exception.getMessage(), exception);
                }
                finally {
                    try {
                        printWriter.close();
                    }
                    catch (Exception exception) {}
                    try {
                        outputStreamWriter.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int pollAndProcessDirectory(String string, String string2, List<String> list, fsConnectionInt fsConnectionInt2) throws ApplicationException {
        int n2 = 0;
        try {
            Util_Logger.debug(logger, "Commencing poll cycle in thread " + this.getId());
            this.startPollCycleDirectory(string2);
            boolean bl = true;
            while (bl && this.getIsRunning()) {
                bl = false;
                List<fsFileInfo> list2 = this.pollSource(fsConnectionInt2, string, string2);
                this.preProcessSourceDirList(string2, list2);
                if (list2 != null) {
                    Util_Logger.debug(logger, "Processing directory listing in thread " + this.getId());
                    if (list2.size() <= 0) continue;
                    if (this.logDirectoryEntry()) {
                        this.logStart(string2, list);
                    }
                    fsConnectionInt fsConnectionInt3 = null;
                    try {
                        Util_Logger.debug(logger, "Waiting for data source connection from pool in thread " + this.getId());
                        fsConnectionInt3 = this.getDestinationConnection();
                        Util_Logger.debug(logger, "Got data connection from pool in thread " + this.getId());
                        fsConnectionInt2.changeDir(string2);
                        ArrayList<String> arrayList = new ArrayList<String>();
                        if (list != null) {
                            for (String exception : list) {
                                boolean bl2 = false;
                                try {
                                    if (exception.contains("{") && exception.contains("}")) {
                                        Util_Logger.debug(logger, "Skipping existance check for [" + exception + "] as it contains file based parameters");
                                        bl2 = true;
                                    } else {
                                        fsConnectionInt3.changeDir(exception);
                                        bl2 = true;
                                    }
                                }
                                catch (Exception exception2) {
                                    if (this.itsDirectoryCreate) {
                                        try {
                                            fsConnectionInt3.makeDir(exception);
                                            fsConnectionInt3.changeDir(exception);
                                            bl2 = true;
                                        }
                                        catch (Exception exception3) {
                                            Util_Logger.warning(logger, "Error creating destination directory: " + exception3.getMessage(), exception3);
                                        }
                                    }
                                    if (this.itsDirectoryRecurse) {
                                        Util_Logger.warning(logger, "Skipping processing of directory " + String.valueOf(list) + " as not present in destination");
                                    }
                                    Util_Logger.error(logger, "Error destination directory " + String.valueOf(list) + " does not exist: " + exception2.getMessage(), exception2);
                                }
                                if (!bl2) continue;
                                arrayList.add(exception);
                            }
                        }
                        if (arrayList.size() > 0) {
                            ArrayList arrayList2 = new ArrayList();
                            if (this.requiresDestinationDirectoryListing()) {
                                for (String string3 : arrayList) {
                                    arrayList2.add(fsConnectionInt3.listFiles(string3, null, null));
                                }
                            }
                            for (fsFileInfo fsFileInfo2 : list2) {
                                if (!this.getIsRunning()) break;
                                if (fsFileInfo2.isDirectory()) continue;
                                boolean bl3 = this.processSingleFile(fsConnectionInt2, string, string2, fsFileInfo2, fsConnectionInt3, arrayList, arrayList2);
                                if (bl3) {
                                    ++n2;
                                }
                                if (this.getProcessLimitFiles() <= 0 || n2 < this.getProcessLimitFiles()) continue;
                                bl = false;
                                break;
                            }
                            try {
                                this.writeDirectoryListingFile(fsConnectionInt3, arrayList);
                            }
                            catch (Exception exception) {
                                Util_Logger.errorNoRaise(logger, "Detected problem writing directory listing file in thread ID " + this.getId() + ": " + exception.getMessage(), exception);
                            }
                            this.freeDestinationConnection(fsConnectionInt3);
                            fsConnectionInt3 = null;
                            for (fsFileInfo fsFileInfo3 : list2) {
                                if (!this.getIsRunning()) break;
                                if (!fsFileInfo3.isDirectory()) continue;
                                int n3 = this.processSingleDirectory(fsConnectionInt2, string, string2, fsFileInfo3, arrayList);
                                if (this.getProcessLimitFiles() <= 0 || (n2 += n3) < this.getProcessLimitFiles()) continue;
                                bl = false;
                                break;
                            }
                        }
                        this.freeDestinationConnection(fsConnectionInt3);
                        continue;
                    }
                    catch (Exception exception) {
                        try {
                            try {
                                fsConnectionInt3.disconnect();
                            }
                            catch (Exception exception3) {
                                // empty catch block
                            }
                            if (exception instanceof InterruptedException) {
                                Thread.currentThread().interrupt();
                            } else {
                                Util_Logger.error(logger, "Detected problem processing files from " + string2 + " in thread ID " + this.getId() + ": " + exception.getMessage(), exception);
                            }
                            this.freeDestinationConnection(fsConnectionInt3);
                            continue;
                        }
                        catch (Throwable throwable) {
                            this.freeDestinationConnection(fsConnectionInt3);
                            throw throwable;
                        }
                    }
                }
                Util_Logger.error(logger, "Detected network problem accessing " + string2 + " in thread ID " + this.getId(), null);
            }
            if (bl) {
                Util_Logger.info(logger, "Reached file process limit of " + this.getProcessLimitFiles() + " files in thread " + this.getId() + ", repolling source directory");
            } else {
                Util_Logger.debug(logger, "Successfully completed file process in thread ID " + this.getId());
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Detected problem processing files from " + string2 + " in thread ID " + this.getId() + ": " + exception.getMessage(), exception);
        }
        return n2;
    }

    @Override
    public String getDataSourceId() {
        return this.itsDataSourceId;
    }

    public String getDataDestinationId() {
        return this.itsDataDestinationId;
    }

    public String getHubManagementAPIURL() {
        return this.itsHubManagementAPIURL;
    }

    public String getHubManagementAPIHeaderValues() {
        return this.itsHubManagementAPIHeaderValues;
    }

    public String getSourceDirListURL() {
        return this.itsSourceDirListURL;
    }

    public String getSourceAPIHeaderValues() {
        return this.itsSourceAPIHeaderValues;
    }

    public String getSourceAckDir() {
        return this.itsSourceAckDir;
    }

    public String getSourceAckAPIHeaderValues() {
        return this.itsSourceAckAPIHeaderValues;
    }

    public String getSourceFilenameMask() {
        return this.itsSourceFilenameMask;
    }

    protected fsConnectionInt getSourceConnection() {
        fsConnectionFactoryInt fsConnectionFactoryInt2 = this.itsDataSource;
        fsConnectionInt fsConnectionInt2 = fsConnectionFactoryInt2.getConnection(this.itsDataSourceId);
        if (this.getTrottleBytesPerSecond() > 0) {
            fsConnectionInt2.setBandwidthThrottle(this.getTrottleBytesPerSecond());
        }
        if (this.itsTransferBufferSize > 0) {
            fsConnectionInt2.setTransferBufferSize(this.itsTransferBufferSize);
        }
        return fsConnectionInt2;
    }

    protected void freeSourceConnection(fsConnectionInt fsConnectionInt2) {
        if (fsConnectionInt2 != null) {
            fsConnectionFactoryInt fsConnectionFactoryInt2 = this.itsDataSource;
            fsConnectionFactoryInt2.freeConnection(fsConnectionInt2);
        }
    }

    protected fsConnectionInt getDestinationConnection() {
        fsConnectionFactoryInt fsConnectionFactoryInt2 = this.itsDataDestination;
        fsConnectionInt fsConnectionInt2 = fsConnectionFactoryInt2.getConnection(this.itsDataDestinationId);
        if (this.getTrottleBytesPerSecond() > 0) {
            fsConnectionInt2.setBandwidthThrottle(this.getTrottleBytesPerSecond());
        }
        if (this.itsTransferBufferSize > 0) {
            fsConnectionInt2.setTransferBufferSize(this.itsTransferBufferSize);
        }
        return fsConnectionInt2;
    }

    protected void freeDestinationConnection(fsConnectionInt fsConnectionInt2) {
        if (fsConnectionInt2 != null) {
            fsConnectionFactoryInt fsConnectionFactoryInt2 = this.itsDataDestination;
            fsConnectionFactoryInt2.freeConnection(fsConnectionInt2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollAndProcessDirectory(String string, String string2, String string3) throws ApplicationException {
        fsConnectionInt fsConnectionInt2 = null;
        try {
            fsConnectionInt2 = this.getSourceConnection();
            String string4 = this.getSourceDir(string2, string3);
            if (this.itsSubDirListDest) {
                this.pollAndProcessDirectory(string, string4, this.getDestinationDir(string3), fsConnectionInt2);
            } else {
                this.pollAndProcessDirectory(string, string4, this.getDestinationDir(null), fsConnectionInt2);
            }
        }
        catch (Exception exception) {
            try {
                if (fsConnectionInt2 != null) {
                    fsConnectionInt2.disconnect();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Util_Logger.error(logger, "Detected problem processing files from " + this.getSourceDir(string2, string3) + " in thread ID " + this.getId() + ": " + exception.getMessage(), exception);
        }
        finally {
            this.freeSourceConnection(fsConnectionInt2);
        }
    }

    protected List<String> resolveSourceDirectories() throws Exception {
        return Util.getList(this.itsSourceDir, ',');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeCycle() throws ApplicationException {
        try {
            if (this.getIsActive()) {
                if (this.getIsRunning()) {
                    this.itsIsProcessing = true;
                    List<String> list = this.resolveSourceDirectories();
                    for (String string : list) {
                        if (!this.logDirectoryEntry()) {
                            Util_Logger.info(logger, "Commencing poll cycle of " + string + " in thread " + this.getId());
                        }
                        this.startPollCycle(string);
                        if (this.itsSubDirList == null) {
                            this.pollAndProcessDirectory(string, string, null);
                        } else if (this.itsSubDirList.size() == 0) {
                            this.pollAndProcessDirectory(string, string, null);
                        } else {
                            for (String string2 : this.itsSubDirList) {
                                if (Util.isBlank(string2)) {
                                    this.pollAndProcessDirectory(string, string, null);
                                    continue;
                                }
                                this.pollAndProcessDirectory(string, string, string2);
                            }
                        }
                        this.completePollCycle(string);
                        if (this.logDirectoryEntry()) continue;
                        Util_Logger.info(logger, "Completed poll cycle of " + string + " in thread " + this.getId());
                    }
                    this.updateProcessStats();
                } else {
                    Util_Logger.info(logger, "Skipping thread execution as shutdown is in progress");
                }
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Detected file download error: " + exception.getMessage(), exception);
        }
        finally {
            this.itsIsProcessing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.itsIsRunningInThread = true;
        Util_Logger.info(logger, "Initiated thread " + this.getId() + " from source directory: " + this.itsSourceDir + " via " + this.itsDataSource.getName() + " to destination directory: " + this.itsDestinationDir + " via " + this.itsDataDestination.getName());
        while (this.getIsRunning()) {
            int n2 = this.getPollingInterval();
            try {
                this.executeCycle();
            }
            catch (Exception exception) {
                LockManager.getInstance().cleanQueue(Thread.currentThread());
                n2 = this.getFailWaitInterval();
            }
            if (!this.getIsRunning()) continue;
            try {
                if (this.getDataSourceIsEventBased()) {
                    Object object = this.itsWaitLock;
                    synchronized (object) {
                        this.itsWaitLock.wait(n2);
                        continue;
                    }
                }
                Thread.sleep(n2);
            }
            catch (Exception exception) {}
        }
        Util_Logger.info(logger, "Batcher thread " + this.getId() + " stopped");
        this.itsIsReady = false;
    }
}

