/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Processor;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.FileSystem.fsConnectionInt;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.FileSystem.fsProcessStatus;
import au.com.aemo.Common.Files.FileMaskSpecification;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerBase;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerConfig;
import au.com.nemmco.Pdr.Batcher.Processor.pdrFileCacheManager;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrBatcherHandlerConsumerCache
extends pdrBatcherHandlerBase {
    private static Logger logger = LoggerFactory.getLogger(pdrBatcherHandlerConsumerCache.class);
    private String CurrentSource;
    private String CurrentDirectory;
    private FileMaskSpecification FileMaskSpec;

    public pdrBatcherHandlerConsumerCache(pdrBatcherHandlerConfig pdrBatcherHandlerConfig2) throws ApplicationException {
        super(pdrBatcherHandlerConfig2);
        this.FileMaskSpec = pdrBatcherHandlerConfig2.FileMaskSpec;
    }

    @Override
    protected boolean requiresDestinationDirectoryListing() {
        return false;
    }

    @Override
    protected boolean logDirectoryEntry() {
        return true;
    }

    @Override
    protected boolean processFileCheck(fsFileInfo fsFileInfo2, Map<String, fsFileInfo> map, boolean bl) {
        pdrFileCacheManager pdrFileCacheManager2 = pdrFileCacheManager.getInstance();
        return pdrFileCacheManager2.processFileCheck(this.getDataSourceId(), fsFileInfo2.getDirectory(), fsFileInfo2);
    }

    @Override
    protected boolean removeSourceFileAfterProcessing() {
        return false;
    }

    @Override
    protected boolean downloadSourceFile() {
        return true;
    }

    @Override
    protected void startPollCycle(String string) {
    }

    @Override
    protected void startPollCycleDirectory(String string) {
    }

    @Override
    protected void preProcessSourceDirList(String string, List<fsFileInfo> list) {
    }

    @Override
    protected void completePollCycle(String string) {
    }

    @Override
    protected List<fsFileInfo> pollSource(fsConnectionInt fsConnectionInt2, String string, String string2) throws Exception {
        List<fsFileInfo> list = super.pollSource(fsConnectionInt2, string, string2);
        this.CurrentSource = fsConnectionInt2.getDataSourceId();
        this.CurrentDirectory = string2;
        pdrFileCacheManager pdrFileCacheManager2 = pdrFileCacheManager.getInstance();
        List<fsFileInfo> list2 = pdrFileCacheManager2.processDirectoryList(this.CurrentSource, this.CurrentDirectory, list, super.getConfig().FileMaskSpec);
        return list2;
    }

    @Override
    protected void fileProcessSuccess(fsFileInfo fsFileInfo2) {
        pdrFileCacheManager.getInstance().processedFile(this.CurrentSource, this.CurrentDirectory, fsFileInfo2);
        super.fileProcessSuccess(fsFileInfo2);
    }

    @Override
    protected fsProcessStatus processSingleFileAction(fsConnectionInt fsConnectionInt2, fsFileInfo fsFileInfo2, fsFileInfo fsFileInfo3, String string, fsConnectionInt fsConnectionInt3, String string2, Map<String, fsFileInfo> map, boolean bl, boolean bl2) {
        fsProcessStatus fsProcessStatus2 = new fsProcessStatus();
        if (fsConnectionInt3.logOperations()) {
            Util_Logger.info(logger, "Now putting " + fsFileInfo3.getFilename() + " to " + string2 + " in thread " + this.getId());
        }
        try {
            if (this.getConfig().AllowOverwrite && fsConnectionInt3.exists(string2, fsFileInfo3.getFilename())) {
                fsConnectionInt3.deleteFile(string2, fsFileInfo3.getFilename());
            }
            fsProcessStatus2 = fsConnectionInt3.putFile(fsFileInfo3, string2, bl2, this.getHoldingDir());
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Detected FTP error: " + exception.getMessage() + " in thread " + this.getId(), exception);
        }
        return fsProcessStatus2;
    }
}

