/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Processor;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.FileSystem.fsConnectionInt;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.FileSystem.fsProcessStatus;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerBase;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerConfig;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrBatcherHandlerPurge
extends pdrBatcherHandlerBase {
    private static Logger logger = LoggerFactory.getLogger(pdrBatcherHandlerPurge.class);
    private int itsRetentionTimeMins;
    private int itsRemovedFileCount;
    private Date itsPurgeBeforeDate;

    public pdrBatcherHandlerPurge(pdrBatcherHandlerConfig pdrBatcherHandlerConfig2) throws ApplicationException {
        super(pdrBatcherHandlerConfig2);
        this.itsRetentionTimeMins = pdrBatcherHandlerConfig2.RetentionTimeMins;
    }

    @Override
    protected boolean requiresDestinationDirectoryListing() {
        return false;
    }

    @Override
    protected boolean logDirectoryEntry() {
        return false;
    }

    @Override
    protected boolean removeSourceFileAfterProcessing() {
        return true;
    }

    @Override
    protected boolean downloadSourceFile() {
        return false;
    }

    @Override
    protected void startPollCycle(String string) {
        this.itsRemovedFileCount = 0;
        if (this.itsRetentionTimeMins > 0) {
            this.itsPurgeBeforeDate = Util.dateOffset(new Date(), -this.itsRetentionTimeMins, 12);
        } else {
            Util_Logger.warning(logger, "Retention time is not defined for purging thread " + this.getId());
        }
    }

    @Override
    protected void startPollCycleDirectory(String string) {
    }

    @Override
    protected void preProcessSourceDirList(String string, List<fsFileInfo> list) {
    }

    @Override
    protected void completePollCycle(String string) {
        if (this.itsRemovedFileCount > 0) {
            Util_Logger.info(logger, "Purged " + this.itsRemovedFileCount + " files from directory " + string + " with last modified date < " + Util.dateToStr(this.itsPurgeBeforeDate, "dd-MM-yyyy HH:mm:ss"));
            this.itsRemovedFileCount = 0;
        }
    }

    @Override
    protected boolean processFileCheck(fsFileInfo fsFileInfo2, Map<String, fsFileInfo> map, boolean bl) {
        boolean bl2 = false;
        if (this.itsPurgeBeforeDate != null && fsFileInfo2 != null && fsFileInfo2.getModifiedDate().before(this.itsPurgeBeforeDate)) {
            bl2 = true;
            ++this.itsRemovedFileCount;
        }
        return bl2;
    }

    @Override
    protected fsProcessStatus processSingleFileAction(fsConnectionInt fsConnectionInt2, fsFileInfo fsFileInfo2, fsFileInfo fsFileInfo3, String string, fsConnectionInt fsConnectionInt3, String string2, Map<String, fsFileInfo> map, boolean bl, boolean bl2) {
        fsProcessStatus fsProcessStatus2 = new fsProcessStatus();
        fsProcessStatus2.setProcessSuccess();
        return fsProcessStatus2;
    }
}

