/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Processor;

import au.com.aemo.Common.Application.ConfigurationManager;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.FileSystem.fsFileLockInt;
import au.com.aemo.Common.Files.FileMaskSpecification;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Batcher.IO.pdrBatcherDataIOInt;
import au.com.nemmco.Pdr.Batcher.IO.pdrBatcherDataIOManager;
import au.com.nemmco.Pdr.Batcher.Processor.pdrDirectoryCache;
import au.com.nemmco.Pdr.Batcher.Processor.pdrSourceCache;
import com.google.gson.reflect.TypeToken;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class pdrFileCacheManager {
    private static Logger logger = LoggerFactory.getLogger(pdrFileCacheManager.class);
    private volatile Map<String, pdrSourceCache> itsSourceCache = new ConcurrentHashMap<String, pdrSourceCache>();
    private String itsCacheStateFile;
    private volatile Date itsLastPersisted;
    private int itsCacheStateFileWriteMins;
    private int itsReplicationDelaySecs;
    private volatile boolean itsHasUpdates;
    private static boolean hasInstance = false;

    private pdrFileCacheManager() {
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        this.itsCacheStateFile = configurationManager.getProperty("batcher_file_manager_cache", "file_manager_cache_state.txt");
        this.itsCacheStateFileWriteMins = Integer.parseInt(configurationManager.getProperty("batcher_file_manager_cache_write_mins", "5"));
        this.itsReplicationDelaySecs = Integer.parseInt(configurationManager.getProperty("batcher_file_manager_cache_replication_delay_secs", "-1"));
        this.itsSourceCache = this.loadCacheFromFile();
        this.itsLastPersisted = new Date();
        this.itsHasUpdates = false;
        hasInstance = true;
    }

    public static pdrFileCacheManager getInstance() {
        return SingletonHolder.instance;
    }

    public static void stop() {
        if (hasInstance) {
            pdrFileCacheManager.getInstance().saveCacheToFile();
        }
    }

    private synchronized pdrDirectoryCache getDirectoryCache(String string, String string2) {
        pdrDirectoryCache pdrDirectoryCache2;
        pdrSourceCache pdrSourceCache2 = this.itsSourceCache.get(string);
        if (pdrSourceCache2 == null) {
            pdrSourceCache2 = new pdrSourceCache();
            this.itsSourceCache.put(string, pdrSourceCache2);
        }
        if ((pdrDirectoryCache2 = pdrSourceCache2.DirList.get(string2)) == null) {
            pdrDirectoryCache2 = new pdrDirectoryCache();
            pdrSourceCache2.DirList.put(string2, pdrDirectoryCache2);
        }
        return pdrDirectoryCache2;
    }

    private boolean processFileCheck(pdrDirectoryCache pdrDirectoryCache2, fsFileInfo fsFileInfo2) {
        boolean bl = false;
        Date date = pdrDirectoryCache2.FileList.get(fsFileInfo2.getFilename());
        if (date == null) {
            bl = true;
        } else if (fsFileInfo2.getModifiedDate() != null && fsFileInfo2.getModifiedDate().after(date)) {
            bl = true;
        }
        if (bl && this.itsReplicationDelaySecs > 0 && fsFileInfo2.getModifiedDate() != null) {
            Date date2 = Util.dateOffset(new Date(), -this.itsReplicationDelaySecs, 13);
            if (fsFileInfo2.getModifiedDate().after(date2)) {
                Util_Logger.debug(logger, "Delaying replication for file [" + fsFileInfo2.getFilename() + "], modified date is " + Util.dateToStr(fsFileInfo2.getModifiedDate(), "dd/MM/yyyy HH:mm:ss") + ", replication delay is [" + this.itsReplicationDelaySecs + "] seconds");
                bl = false;
            }
        }
        return bl;
    }

    public boolean processFileCheck(String string, String string2, fsFileInfo fsFileInfo2) {
        pdrDirectoryCache pdrDirectoryCache2 = this.getDirectoryCache(string, string2);
        return this.processFileCheck(pdrDirectoryCache2, fsFileInfo2);
    }

    public List<fsFileInfo> processDirectoryList(String string, String string2, List<fsFileInfo> list, FileMaskSpecification fileMaskSpecification) {
        pdrDirectoryCache pdrDirectoryCache2 = this.getDirectoryCache(string, string2);
        ArrayList<fsFileInfo> arrayList = new ArrayList<fsFileInfo>();
        for (fsFileInfo object2 : list) {
            if (!this.processFileCheck(pdrDirectoryCache2, object2)) continue;
            arrayList.add(object2);
        }
        HashMap hashMap = new HashMap();
        for (fsFileInfo fsFileInfo2 : list) {
            hashMap.put(fsFileInfo2.getFilename(), fsFileInfo2);
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string3 : pdrDirectoryCache2.FileList.keySet()) {
            if (!fileMaskSpecification.checkFileMask(string3) || hashMap.containsKey(string3)) continue;
            arrayList2.add(string3);
        }
        for (String string3 : arrayList2) {
            Util_Logger.debug(logger, "Removing file " + string3 + " from pdrFileCacheManager as it has been purged from source");
            pdrDirectoryCache2.FileList.remove(string3);
        }
        this.itsHasUpdates = true;
        return arrayList;
    }

    public void processedFile(String string, String string2, fsFileInfo fsFileInfo2) {
        pdrDirectoryCache pdrDirectoryCache2 = this.getDirectoryCache(string, string2);
        pdrDirectoryCache2.FileList.put(fsFileInfo2.getFilename(), fsFileInfo2.getModifiedDate());
        this.itsHasUpdates = true;
        Date date = Util.dateOffset(new Date(), -this.itsCacheStateFileWriteMins, 12);
        if (this.itsLastPersisted.before(date)) {
            this.saveCacheToFile();
        }
    }

    @SuppressFBWarnings(value={"DM_EXIT"}, justification="Fatal configuration error requires exit from application")
    private Map<String, pdrSourceCache> loadCacheFromFile() {
        Map<String, pdrSourceCache> map = new ConcurrentHashMap<String, pdrSourceCache>();
        try {
            pdrBatcherDataIOInt pdrBatcherDataIOInt2 = pdrBatcherDataIOManager.getInstance().getProvider();
            fsFileInfo fsFileInfo2 = pdrBatcherDataIOInt2.resolveCacheFilename(this.itsCacheStateFile);
            fsFileLockInt fsFileLockInt2 = pdrBatcherDataIOInt2.lockCacheFile(fsFileInfo2);
            if (fsFileLockInt2.isValid()) {
                fsFileInfo2.setLockData(fsFileLockInt2);
                String string = pdrBatcherDataIOInt2.loadCacheFile(fsFileInfo2);
                map = (Map)JsonUtilities.fromJson(string, new TypeToken<Map<String, pdrSourceCache>>(){}.getType());
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                if (map != null) {
                    n2 = map.size();
                    for (pdrSourceCache pdrSourceCache2 : map.values()) {
                        if (pdrSourceCache2.DirList == null) continue;
                        for (pdrDirectoryCache pdrDirectoryCache2 : pdrSourceCache2.DirList.values()) {
                            ++n3;
                            if (pdrDirectoryCache2.FileList == null) continue;
                            n4 += pdrDirectoryCache2.FileList.size();
                        }
                    }
                }
                Util_Logger.info(logger, "Loaded file cache state from " + this.itsCacheStateFile + ", detected " + n2 + " data sources, " + n3 + " directories, " + n4 + " files");
            } else {
                Util_Logger.errorNoRaise(logger, "Error opening " + this.itsCacheStateFile + " as it is being used by another batcher instance. Configure property batcher_file_manager_cache to a unique filename");
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error loading cache state from file " + this.itsCacheStateFile + ": " + exception.getMessage(), exception);
            Util_Logger.warning(logger, "Detected invalid or missing cache file " + this.itsCacheStateFile + ", resetting state");
        }
        if (map == null) {
            map = new ConcurrentHashMap();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveCacheToFile() {
        if (this.itsHasUpdates) {
            try {
                String string = null;
                Object object = this.itsSourceCache;
                synchronized (object) {
                    string = JsonUtilities.toJson(this.itsSourceCache);
                }
                object = pdrBatcherDataIOManager.getInstance().getProvider();
                fsFileInfo fsFileInfo2 = object.resolveCacheFilename(this.itsCacheStateFile);
                object.saveCacheFile(fsFileInfo2, string);
                this.itsLastPersisted = new Date();
                this.itsHasUpdates = false;
                Util_Logger.info(logger, "Persisted state to cache state file " + this.itsCacheStateFile);
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "File cache manager save failed: " + exception.getMessage(), exception);
            }
        }
    }

    private static class SingletonHolder {
        private static pdrFileCacheManager instance = new pdrFileCacheManager();

        private SingletonHolder() {
        }
    }
}

