/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Translation;

import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.Files.FileNameTokenResolver;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Batcher.Translation.aseXMLCSVExtractConfig;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationBase;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationInt;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class pdrFileTranslationASEXMLtoCSV
extends pdrFileTranslationBase
implements pdrFileTranslationInt {
    private static Logger logger = LoggerFactory.getLogger(pdrFileTranslationASEXMLtoCSV.class);
    public static final String JSON_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSX";
    public static final String NEMREPORTS_DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";
    private static final String PARAM_DATA = "data";
    private static final String PARAM_NAME = "name";

    public pdrFileTranslationASEXMLtoCSV() {
        super("ASEXML_TO_CSV");
        super.registerParam("d", PARAM_DATA, true, "The XML element name(s) containing the CSV data");
        super.registerParam("n", PARAM_NAME, true, "The name of the output file");
    }

    @Override
    public boolean acceptFile(fsFileInfo fsFileInfo2) {
        return fsFileInfo2.getFilename().toUpperCase().endsWith(".XML");
    }

    @Override
    public List<fsFileInfo> translateFile(fsFileInfo fsFileInfo2, String string, int n2) throws Exception {
        Object object;
        String string2;
        ArrayList<fsFileInfo> arrayList = new ArrayList<fsFileInfo>();
        String string3 = this.getParam(PARAM_DATA);
        List<String> list = null;
        list = string3.startsWith("file:") ? Files.readAllLines(Paths.get(string3.substring(5), new String[0])) : Arrays.asList(Util.getColumns(string3, ','));
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (String object22 : list) {
            if (Util.isBlank(object22) || object22.startsWith("#") || ((String[])(string2 = Util.getColumns(object22, ':'))).length != 2) continue;
            object = new aseXMLCSVExtractConfig();
            ((aseXMLCSVExtractConfig)object).TransactionGroup = string2[0];
            ((aseXMLCSVExtractConfig)object).csvDataElement = string2[1];
            arrayList2.add(object);
        }
        String string4 = this.getParam(PARAM_NAME);
        String string5 = string + "/" + fsFileInfo2.getFilename();
        string2 = string + "/" + fsFileInfo2.getFilename() + ".tmp";
        object = new HashMap<String, String>();
        object.put(PARAM_NAME, fsFileInfo2.getName());
        object.put("ext", fsFileInfo2.getExtension());
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder exception = documentBuilderFactory.newDocumentBuilder();
            Document document = exception.parse(new File(string5));
            document.getDocumentElement().normalize();
            String string6 = null;
            NodeList nodeList = this.evaluateXPath(document, "/ase:aseXML/Header");
            if (nodeList == null) {
                throw new Exception("Header element not found in: " + string5);
            }
            if (nodeList.getLength() != 1) {
                throw new Exception("Header element not found in: " + string5);
            }
            Node i2 = nodeList.item(0);
            Element element = (Element)i2;
            this.addParameter(element, "From", (Map<String, String>)object, false);
            this.addParameter(element, "To", (Map<String, String>)object, false);
            this.addParameter(element, "MessageID", (Map<String, String>)object, false);
            this.addParameter(element, "MessageDate", (Map<String, String>)object, true);
            string6 = this.addParameter(element, "TransactionGroup", (Map<String, String>)object, false);
            this.addParameter(element, "Priority", (Map<String, String>)object, false);
            this.addParameter(element, "SecurityContext", (Map<String, String>)object, false);
            this.addParameter(element, "Market", (Map<String, String>)object, false);
            nodeList = this.evaluateXPath(document, "/ase:aseXML/Transactions/Transaction");
            if (nodeList == null) {
                Util_Logger.warning(logger, "Detected no transactions within " + fsFileInfo2.getFilename());
            } else if (nodeList.getLength() == 0) {
                Util_Logger.warning(logger, "Detected no transactions within " + fsFileInfo2.getFilename());
            } else {
                for (int i3 = 0; i3 < nodeList.getLength(); ++i3) {
                    Object object2;
                    Object object32;
                    element = (Element)nodeList.item(i3);
                    String string7 = this.addParameterAttribute(element, "transactionID", (Map<String, String>)object, false);
                    this.addParameterAttribute(element, "transactionDate", (Map<String, String>)object, true);
                    String string8 = null;
                    for (Object object32 : arrayList2) {
                        if (!((aseXMLCSVExtractConfig)object32).TransactionGroup.equalsIgnoreCase(string6) || (object2 = element.getElementsByTagName(((aseXMLCSVExtractConfig)object32).csvDataElement)) == null || object2.getLength() != 1) continue;
                        string8 = object2.item(0).getTextContent();
                        break;
                    }
                    if (Util.isBlank(string8)) {
                        Util_Logger.error(logger, "Unable to find CSV payload in transaction " + string7 + " within " + fsFileInfo2.getFilename());
                    } else {
                        string8 = string8.trim();
                    }
                    try (Object object4 = Files.newBufferedWriter(Paths.get(string2, new String[0]), new OpenOption[0]);){
                        ((Writer)object4).write(string8);
                        ((BufferedWriter)object4).flush();
                        ((BufferedWriter)object4).close();
                    }
                    object4 = FileNameTokenResolver.process(string4, (Map<String, String>)object);
                    object32 = string + "/" + (String)object4;
                    FileUtilities.renameFile(string2, (String)object32);
                    object2 = new fsFileInfo(fsFileInfo2);
                    ((fsFileInfo)object2).setDirectory(string);
                    ((fsFileInfo)object2).setFilename((String)object4);
                    ((fsFileInfo)object2).setSize(new File((String)object32).length());
                    arrayList.add((fsFileInfo)object2);
                }
            }
            FileUtilities.deleteFile(fsFileInfo2);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error processing aseXML to CSV translation: " + exception.getMessage(), exception);
        }
        return arrayList;
    }

    private String convertDate(String string) {
        String string2 = null;
        if (string != null) {
            string2 = string.indexOf("+") > 0 ? string.substring(0, string.indexOf("+")) : string;
            string2 = string2.replace(":", "");
        }
        return string2;
    }

    private NodeList evaluateXPath(Document document, String string) throws Exception {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        xPath.setNamespaceContext(new NamespaceResolver(document));
        XPathExpression xPathExpression = xPath.compile(string);
        NodeList nodeList = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
        return nodeList;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Safer to check and not make assumptions about external libraries that might change over time")
    private String addParameter(Element element, String string, Map<String, String> map, boolean bl) {
        String string2 = null;
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList != null) {
            if (nodeList.getLength() == 1) {
                string2 = nodeList.item(0).getTextContent();
                if (bl) {
                    string2 = this.convertDate(string2);
                }
                if (!Util.isBlank(string2)) {
                    map.put(string.toLowerCase(), string2);
                }
            } else if (nodeList.getLength() == 0) {
                Util_Logger.warning(logger, "Unable to find element " + string + " in aseXML header");
            } else {
                Util_Logger.warning(logger, "Detected multiple elements named " + string + " in aseXML header");
            }
        } else {
            Util_Logger.warning(logger, "Unable to find element " + string + " in aseXML header");
        }
        return string2;
    }

    private String addParameterAttribute(Element element, String string, Map<String, String> map, boolean bl) {
        Node node;
        String string2 = null;
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap != null && (node = namedNodeMap.getNamedItem(string)) != null) {
            string2 = node.getTextContent();
            if (bl) {
                string2 = this.convertDate(string2);
            }
        }
        if (!Util.isBlank(string2)) {
            map.put(string.toLowerCase(), string2);
        } else {
            Util_Logger.warning(logger, "Unable to find attribute " + string + " in element " + element.getTagName());
        }
        return string2;
    }

    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC"}, justification="Class cannot be static")
    private class NamespaceResolver
    implements NamespaceContext {
        private Document sourceDocument;

        public NamespaceResolver(Document document) {
            this.sourceDocument = document;
        }

        @Override
        public String getNamespaceURI(String string) {
            if (string.equals("")) {
                return this.sourceDocument.lookupNamespaceURI(null);
            }
            return this.sourceDocument.lookupNamespaceURI(string);
        }

        @Override
        public String getPrefix(String string) {
            return this.sourceDocument.lookupPrefix(string);
        }

        public Iterator getPrefixes(String string) {
            return null;
        }
    }
}

