/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Translation;

import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class pdrFileTranslationBase {
    private static Logger logger = LoggerFactory.getLogger(pdrFileTranslationBase.class);
    private String itsId;
    private Options options = new Options();
    private CommandLine cmd;
    private String itsDataSourceId;

    public pdrFileTranslationBase(String string) {
        this.itsId = string;
    }

    public String getId() {
        return this.itsId;
    }

    public void registerParamList(String string, String string2, boolean bl, String string3) {
        Option option = new Option(string, string2, true, string3);
        option.setRequired(bl);
        option.setArgs(-2);
        this.options.addOption(option);
    }

    public void registerParam(String string, String string2, boolean bl, String string3) {
        Option option = new Option(string, string2, true, string3);
        option.setRequired(bl);
        this.options.addOption(option);
    }

    public void registerOption(String string, String string2, String string3) {
        this.options.addOption(string, string2, false, string3);
    }

    public void parseParams(String[] stringArray) throws Exception {
        try {
            DefaultParser defaultParser = new DefaultParser();
            this.cmd = defaultParser.parse(this.options, stringArray);
        }
        catch (Exception exception) {
            try (StringWriter stringWriter = new StringWriter();
                 PrintWriter printWriter = new PrintWriter(stringWriter);){
                HelpFormatter helpFormatter = new HelpFormatter();
                helpFormatter.printHelp(printWriter, helpFormatter.getWidth(), this.itsId, null, this.options, helpFormatter.getLeftPadding(), helpFormatter.getDescPadding(), null, true);
                printWriter.flush();
                Util_Logger.info(logger, stringWriter.toString());
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new Exception("Error processing parameters for translator ID " + this.getId() + ": " + exception.getMessage(), exception);
        }
    }

    public String getParam(String string) {
        String string2 = null;
        if (!Util.isBlank(string) && this.cmd != null) {
            string2 = this.cmd.getOptionValue(string);
        }
        return string2;
    }

    public String[] getParamList(String string) {
        String[] stringArray = null;
        if (!Util.isBlank(string) && this.cmd != null) {
            stringArray = this.cmd.getOptionValues(string);
        }
        return stringArray;
    }

    public boolean hasParam(String string) {
        boolean bl = false;
        if (!Util.isBlank(string) && this.cmd != null) {
            bl = this.cmd.hasOption(string);
        }
        return bl;
    }

    protected boolean isTextFile(fsFileInfo fsFileInfo2) {
        return fsFileInfo2.getFilename().toUpperCase().endsWith(".CSV") || fsFileInfo2.getFilename().toUpperCase().endsWith(".TXT") || fsFileInfo2.getFilename().toUpperCase().endsWith(".LOG");
    }

    public String getDataSourceId() {
        return this.itsDataSourceId;
    }

    public void setDataSourceId(String string) {
        this.itsDataSourceId = string;
    }
}

