/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Translation;

import au.com.aemo.Common.CSV.Csv;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationBase;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationInt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrFileTranslationCSVtoJSON
extends pdrFileTranslationBase
implements pdrFileTranslationInt {
    private static Logger logger = LoggerFactory.getLogger(pdrFileTranslationCSVtoJSON.class);
    private final Csv csvParser = new Csv();
    private static final String PARAM_DATE_FORMAT = "date_format";
    private static final String PARAM_DATE_MIN_LENGTH = "date_min_length";

    public pdrFileTranslationCSVtoJSON() {
        super("CSV_TO_JSON");
        super.registerParam("d", PARAM_DATE_FORMAT, true, "The date format specification");
        super.registerParam("l", PARAM_DATE_MIN_LENGTH, true, "The minimum length of a date field");
    }

    @Override
    public boolean acceptFile(fsFileInfo fsFileInfo2) {
        return fsFileInfo2.getFilename().toUpperCase().endsWith(".FLATCSV");
    }

    @Override
    public List<fsFileInfo> translateFile(fsFileInfo fsFileInfo2, String string, int n2) throws Exception {
        ArrayList<fsFileInfo> arrayList = new ArrayList<fsFileInfo>();
        String string2 = this.getParam(PARAM_DATE_FORMAT);
        int n3 = Integer.parseInt(this.getParam(PARAM_DATE_MIN_LENGTH));
        String string3 = string + "/" + fsFileInfo2.getFilename();
        String string4 = string + "/" + fsFileInfo2.getFilename() + ".tmp";
        String string5 = fsFileInfo2.getName() + ".json";
        String string6 = string + "/" + string5;
        long l2 = 0L;
        String string7 = "";
        String[] stringArray = null;
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(Paths.get(string4, new String[0]), new OpenOption[0]);){
            Object object;
            try {
                object = new BufferedReader(new FileReader(string3));
                try {
                    while ((string7 = ((BufferedReader)object).readLine()) != null) {
                        String[] stringArray2 = this.csvParser.parse(string7);
                        if (++l2 == 1L) {
                            stringArray = stringArray2;
                            bufferedWriter.write("{\"data\": [");
                            continue;
                        }
                        if (l2 > 2L) {
                            bufferedWriter.write(",");
                        }
                        bufferedWriter.write("{");
                        for (int i2 = 0; i2 < stringArray.length; ++i2) {
                            if (i2 > 0) {
                                bufferedWriter.write(",");
                            }
                            bufferedWriter.write("\"");
                            bufferedWriter.write(stringArray[i2]);
                            bufferedWriter.write("\": ");
                            String string8 = null;
                            if (i2 < stringArray2.length && (string8 = stringArray2[i2]) != null && string8.length() >= n3) {
                                try {
                                    Date date = Util.strToDate(string8, string2);
                                    string8 = JsonUtilities.dateToStr(date);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (Util.isBlank(string8)) {
                                bufferedWriter.write("null");
                                continue;
                            }
                            bufferedWriter.write("\"");
                            bufferedWriter.write(string8);
                            bufferedWriter.write("\"");
                        }
                        bufferedWriter.write("}");
                    }
                    if (stringArray != null) {
                        bufferedWriter.write("]}");
                    }
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
                finally {
                    ((BufferedReader)object).close();
                }
            }
            catch (Exception exception) {
                Util_Logger.error(logger, "Error processing CSV to JSON translation: " + exception.getMessage(), exception);
            }
            FileUtilities.renameFile(string4, string6);
            FileUtilities.deleteFile(fsFileInfo2);
            object = new fsFileInfo(fsFileInfo2);
            ((fsFileInfo)object).setDirectory(string);
            ((fsFileInfo)object).setFilename(string5);
            ((fsFileInfo)object).setSize(new File(string6).length());
            arrayList.add((fsFileInfo)object);
        }
        return arrayList;
    }
}

