/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Translation;

import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationBase;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationInt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrFileTranslationFilter
extends pdrFileTranslationBase
implements pdrFileTranslationInt {
    private static Logger logger = LoggerFactory.getLogger(pdrFileTranslationFilter.class);
    private static final String PARAM_FIND = "find";
    private static final String PARAM_REGEX = "regex";
    private static final String PARAM_FILTER_TYPE = "filter";
    private static final String PARAM_FROM_LINE = "from_line";
    private static final String PARAM_TO_LINE = "to_line";
    private static final String PARAM_CASE_SENSITIVE = "case_sensitive";

    public pdrFileTranslationFilter() {
        super("FILTER");
        super.registerParam("f", PARAM_FIND, true, "The text or regular expression to find");
        super.registerOption("r", PARAM_REGEX, "Whether the find text is a REGEX");
        super.registerParam("ft", PARAM_FILTER_TYPE, true, "The filter type (include or exclude). If omitted assumes include");
        super.registerParam("fl", PARAM_FROM_LINE, false, "Only replace text occuring on or after this line in the file. If omitted assumes start of file");
        super.registerParam("t", PARAM_TO_LINE, false, "Only replace text occuring on or before this line in the file. If omitted assumes end of file");
        super.registerParam("cs", PARAM_CASE_SENSITIVE, false, "Whether the text search should be case sensitive. Default is N");
    }

    @Override
    public boolean acceptFile(fsFileInfo fsFileInfo2) {
        return this.isTextFile(fsFileInfo2);
    }

    @Override
    public List<fsFileInfo> translateFile(fsFileInfo fsFileInfo2, String string, int n2) throws Exception {
        ArrayList<fsFileInfo> arrayList = new ArrayList<fsFileInfo>();
        boolean bl = Util.isBlank(this.getParam(PARAM_CASE_SENSITIVE), "N").equalsIgnoreCase("Y");
        String string2 = this.getParam(PARAM_FIND);
        boolean bl2 = Util.isBlank(this.getParam(PARAM_FILTER_TYPE), "include").equalsIgnoreCase("include");
        String string3 = this.getParam(PARAM_FROM_LINE);
        Long l2 = Util.isBlank(string3) ? null : Long.valueOf(string3);
        String string4 = this.getParam(PARAM_TO_LINE);
        Long l3 = Util.isBlank(string4) ? null : Long.valueOf(string4);
        boolean bl3 = this.hasParam(PARAM_REGEX);
        if (Util.isBlank(string2)) {
            Util_Logger.warning(logger, "Missing parameter find in " + this.getId() + " translator, ignoring action");
            arrayList.add(fsFileInfo2);
        } else {
            String string5 = string + "/" + fsFileInfo2.getFilename();
            String string6 = string + "/" + fsFileInfo2.getFilename() + ".tmp";
            String string7 = bl ? string2 : string2.toLowerCase();
            Pattern pattern = null;
            if (bl3) {
                pattern = Pattern.compile(string7);
            }
            long l4 = 0L;
            boolean bl4 = false;
            String string8 = "";
            try (Object object = Files.newBufferedWriter(Paths.get(string6, new String[0]), new OpenOption[0]);){
                try (BufferedReader bufferedReader = new BufferedReader(new FileReader(string5));){
                    while ((string8 = bufferedReader.readLine()) != null) {
                        boolean bl5 = true;
                        if (l2 != null && ++l4 < l2) {
                            bl5 = false;
                        }
                        if (l3 != null && l4 > l3) {
                            bl5 = false;
                        }
                        boolean bl6 = true;
                        if (bl5) {
                            String string9;
                            String string10 = string9 = bl ? string8 : string8.toLowerCase();
                            if (bl3) {
                                Matcher matcher = pattern.matcher(string9);
                                bl6 = matcher.find();
                            } else {
                                boolean bl7 = bl6 = string9.indexOf(string7) >= 0;
                            }
                            if (!bl2) {
                                boolean bl8 = bl6 = !bl6;
                            }
                        }
                        if (!bl6) continue;
                        if (bl4) {
                            ((BufferedWriter)object).newLine();
                        }
                        ((Writer)object).write(string8);
                        bl4 = true;
                    }
                    bufferedReader.close();
                    ((BufferedWriter)object).flush();
                    ((BufferedWriter)object).close();
                }
                catch (Exception exception) {
                    Util_Logger.error(logger, "Error processing string replace translation: " + exception.getMessage(), exception);
                }
            }
            if (fsFileInfo2.getModifiedDate() != null) {
                object = new File(string6);
                ((File)object).setLastModified(fsFileInfo2.getModifiedDate().getTime());
            }
            FileUtilities.renameFile(string6, string5);
            object = new fsFileInfo(fsFileInfo2);
            ((fsFileInfo)object).setDirectory(string);
            ((fsFileInfo)object).setSize(new File(string5).length());
            arrayList.add((fsFileInfo)object);
        }
        return arrayList;
    }
}

