/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Translation;

import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationBase;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationInt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrFileTranslationInsert
extends pdrFileTranslationBase
implements pdrFileTranslationInt {
    private static Logger logger = LoggerFactory.getLogger(pdrFileTranslationInsert.class);
    private static final String PARAM_LINE = "line";
    private static final String PARAM_TEXT = "text";

    public pdrFileTranslationInsert() {
        super("INSERT");
        super.registerParam("l", PARAM_LINE, true, "Line number of the source file");
        super.registerParam("t", PARAM_TEXT, true, "The text to insert");
    }

    @Override
    public boolean acceptFile(fsFileInfo fsFileInfo2) {
        return this.isTextFile(fsFileInfo2);
    }

    @Override
    public List<fsFileInfo> translateFile(fsFileInfo fsFileInfo2, String string, int n2) throws Exception {
        ArrayList<fsFileInfo> arrayList = new ArrayList<fsFileInfo>();
        Long l2 = null;
        String string2 = this.getParam(PARAM_LINE);
        try {
            l2 = Util.isBlank(string2) ? null : Long.valueOf(string2);
        }
        catch (Exception exception) {
            Util_Logger.warning(logger, "Invalid line parameter (" + string2 + "), assuming +1");
            l2 = 1L;
        }
        String string3 = this.getParam(PARAM_TEXT);
        if (Util.isBlank(string3) || l2 == null) {
            Util_Logger.warning(logger, "Missing parameters line and text in " + this.getId() + " translator, ignoring action");
            arrayList.add(fsFileInfo2);
        } else {
            String string4 = string + "/" + fsFileInfo2.getFilename();
            String string5 = string + "/" + fsFileInfo2.getFilename() + ".tmp";
            boolean bl = false;
            long l3 = 0L;
            String string6 = "";
            try (Object object = Files.newBufferedWriter(Paths.get(string5, new String[0]), new OpenOption[0]);){
                try (BufferedReader bufferedReader = new BufferedReader(new FileReader(string4));){
                    while ((string6 = bufferedReader.readLine()) != null) {
                        if (++l3 == l2) {
                            ((Writer)object).write(string3);
                            ((BufferedWriter)object).newLine();
                            bl = true;
                        }
                        ((Writer)object).write(string6);
                        ((BufferedWriter)object).newLine();
                    }
                    bufferedReader.close();
                    ((BufferedWriter)object).flush();
                    ((BufferedWriter)object).close();
                }
                catch (Exception exception) {
                    Util_Logger.error(logger, "Error processing insert translation: " + exception.getMessage(), exception);
                }
            }
            if (!bl) {
                Util_Logger.warning(logger, "Reached end of file " + fsFileInfo2.getFilename() + " [lines = " + l3 + "] before INSERT translator specified at line " + l2);
            }
            if (fsFileInfo2.getModifiedDate() != null) {
                object = new File(string5);
                ((File)object).setLastModified(fsFileInfo2.getModifiedDate().getTime());
            }
            FileUtilities.renameFile(string5, string4);
            object = new fsFileInfo(fsFileInfo2);
            ((fsFileInfo)object).setDirectory(string);
            ((fsFileInfo)object).setSize(new File(string4).length());
            arrayList.add((fsFileInfo)object);
        }
        return arrayList;
    }
}

