/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Translation;

import au.com.aemo.Common.FileSystem.fsEventData;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Batcher.Translation.jsonVariable;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationBase;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationInt;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrFileTranslationJSONVariable
extends pdrFileTranslationBase
implements pdrFileTranslationInt {
    private static Logger logger = LoggerFactory.getLogger(pdrFileTranslationJSONVariable.class);
    private static final int NO_PARAMS = 5;
    private static final String PARAM_EXISTS = "exists";
    private static final String PARAM_VARIABLE = "variable";
    private static final String PARAM_PATH = "path";

    public pdrFileTranslationJSONVariable() {
        super("JSON_VARIABLE");
        for (int i2 = 1; i2 <= 5; ++i2) {
            super.registerParam("v" + i2, PARAM_VARIABLE + i2, false, "The variable name");
            super.registerParam("p" + i2, PARAM_PATH + i2, i2 == 1, "The JSON path for a variable to be made available to file rename");
            super.registerOption("e" + i2, PARAM_EXISTS + i2, "Set this flag to return true if the JSON path exists");
        }
    }

    @Override
    public boolean acceptFile(fsFileInfo fsFileInfo2) {
        return fsFileInfo2.getFilename().toUpperCase().endsWith(".JSON");
    }

    private void evaluateVariable(JsonObject jsonObject, jsonVariable jsonVariable2) throws Exception {
        try {
            if (Util.isBlank(jsonVariable2.Name)) {
                jsonVariable2.Name = jsonVariable2.JsonPath.substring(jsonVariable2.JsonPath.lastIndexOf(".") + 1);
            }
            JsonElement jsonElement = (JsonElement)JsonPath.read((Object)jsonObject, (String)jsonVariable2.JsonPath, (Predicate[])new Predicate[0]);
            if (jsonVariable2.CheckExists) {
                jsonVariable2.Value = "true";
            } else {
                String string = jsonElement.getAsString();
                try {
                    Date date = JsonUtilities.strToDate(string);
                    jsonVariable2.Value = Util.dateToStr(date, "yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
                }
                catch (Exception exception) {
                    jsonVariable2.Value = string;
                }
            }
        }
        catch (Exception exception) {
            if (jsonVariable2.CheckExists) {
                jsonVariable2.Value = "false";
            }
            throw exception;
        }
    }

    @Override
    public List<fsFileInfo> translateFile(fsFileInfo fsFileInfo2, String string, int n2) throws Exception {
        jsonVariable jsonVariable2;
        ArrayList<fsFileInfo> arrayList = new ArrayList<fsFileInfo>();
        ArrayList<jsonVariable> arrayList2 = new ArrayList<jsonVariable>();
        for (int i2 = 1; i2 <= 5; ++i2) {
            if (!this.hasParam(PARAM_PATH + i2)) continue;
            jsonVariable2 = new jsonVariable();
            jsonVariable2.Name = this.getParam(PARAM_VARIABLE + i2);
            jsonVariable2.JsonPath = this.getParam(PARAM_PATH + i2);
            jsonVariable2.CheckExists = this.hasParam(PARAM_EXISTS + i2);
            arrayList2.add(jsonVariable2);
        }
        String string2 = string + "/" + fsFileInfo2.getFilename();
        jsonVariable2 = null;
        try {
            jsonVariable2 = JsonUtilities.getJsonObjectFromFile(string2);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error parsing JSON file [" + fsFileInfo2.getFilename() + "]: " + exception.getMessage(), exception);
        }
        for (jsonVariable jsonVariable3 : arrayList2) {
            this.evaluateVariable((JsonObject)jsonVariable2, jsonVariable3);
            if (jsonVariable3.Value == null) continue;
            fsEventData fsEventData2 = fsFileInfo2.getEventData();
            if (fsEventData2 == null) {
                fsEventData2 = new fsEventData();
                fsFileInfo2.setEventData(fsEventData2);
            }
            fsEventData2.addEventParameter(jsonVariable3.Name, jsonVariable3.Value);
        }
        arrayList.add(fsFileInfo2);
        return arrayList;
    }
}

