/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Translation;

import au.com.aemo.Common.CSV.CsvWriter;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationBase;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationInt;
import au.com.nemmco.Pdr.Common.JSON.MarketJsonColumn;
import au.com.nemmco.Pdr.Common.JSON.marketJsonListener;
import au.com.nemmco.Pdr.Common.JSON.marketJsonParser;
import au.com.nemmco.Pdr.Common.JSON.marketJsonReportRecord;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrFileTranslationJSONtoNEMCSV
extends pdrFileTranslationBase
implements pdrFileTranslationInt,
marketJsonListener {
    private static Logger logger = LoggerFactory.getLogger(pdrFileTranslationJSONtoNEMCSV.class);
    public static final String NEMREPORTS_DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";
    public static final String NEMREPORTS_TIMESTAMP_FORMAT = "yyyy/MM/dd HH:mm:ss.SSS";
    private CsvWriter w;
    private long LineNo;
    private String CurrReportName;
    private String CurrReportSubType;
    private String CurrReportVersion;
    private DateTimeFormatter csvDateFormat = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
    private DateTimeFormatter csvTimestampFormat = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss.SSS");

    public pdrFileTranslationJSONtoNEMCSV() {
        super("JSON_TO_NEMCSV");
    }

    @Override
    public boolean acceptFile(fsFileInfo fsFileInfo2) {
        return fsFileInfo2.getFilename().toUpperCase().endsWith(".JSON");
    }

    @Override
    public List<fsFileInfo> translateFile(fsFileInfo fsFileInfo2, String string, int n2) throws Exception {
        ArrayList<fsFileInfo> arrayList = new ArrayList<fsFileInfo>();
        String string2 = string + "/" + fsFileInfo2.getFilename();
        String string3 = string + "/" + fsFileInfo2.getFilename() + ".tmp";
        String string4 = fsFileInfo2.getName() + ".csv";
        String string5 = string + "/" + string4;
        this.LineNo = 0L;
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(Paths.get(string3, new String[0]), new OpenOption[0]);){
            Object object;
            this.w = new CsvWriter(bufferedWriter);
            try {
                object = new FileInputStream(string2);
                try {
                    marketJsonParser marketJsonParser2 = new marketJsonParser();
                    marketJsonParser2.registerListener(this);
                    marketJsonParser2.convert((InputStream)object);
                    ++this.LineNo;
                    this.w.put("C");
                    this.w.put("END OF REPORT");
                    this.w.put(Long.toString(this.LineNo));
                    this.w.nl();
                    this.w.flush();
                    this.w.close();
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
                finally {
                    ((FileInputStream)object).close();
                }
            }
            catch (Exception exception) {
                Util_Logger.error(logger, "Error processing JSON to NEMCSV translation: " + exception.getMessage(), exception);
            }
            FileUtilities.renameFile(string3, string5);
            FileUtilities.deleteFile(fsFileInfo2);
            object = new fsFileInfo(fsFileInfo2);
            ((fsFileInfo)object).setDirectory(string);
            ((fsFileInfo)object).setFilename(string4);
            ((fsFileInfo)object).setSize(new File(string5).length());
            arrayList.add((fsFileInfo)object);
        }
        return arrayList;
    }

    @Override
    public void processHeader(Map<String, String> map) throws Exception {
        this.w.put("C");
        this.w.put(map.get("source"));
        this.w.put(map.get("file_id"));
        this.w.put(map.get("from"));
        this.w.put(map.get("to"));
        LocalDateTime localDateTime = JsonUtilities.strToDateTime(map.get("creation_date"));
        this.w.put(localDateTime.format(new DateTimeFormatterBuilder().appendPattern("yyyy/MM/dd").toFormatter()));
        this.w.put(localDateTime.format(new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").toFormatter()));
        this.w.put(map.get("event_queue_id"));
        this.w.put(map.get("data_model_file_id"));
        this.w.put(map.get("event_group_id"));
        this.w.nl();
        ++this.LineNo;
    }

    @Override
    public void processInfo(marketJsonReportRecord marketJsonReportRecord2) throws Exception {
        int n2 = marketJsonReportRecord2.Id.indexOf("_");
        this.CurrReportName = marketJsonReportRecord2.Id.substring(0, n2);
        this.CurrReportSubType = marketJsonReportRecord2.Id.substring(n2 + 1);
        this.CurrReportVersion = marketJsonReportRecord2.Version;
        this.w.put("I");
        this.w.put(this.CurrReportName);
        this.w.put(this.CurrReportSubType);
        this.w.put(this.CurrReportVersion);
        for (MarketJsonColumn marketJsonColumn : marketJsonReportRecord2.Columns) {
            this.w.put(marketJsonColumn.getName());
        }
        this.w.nl();
        ++this.LineNo;
    }

    @Override
    public void processData(marketJsonReportRecord marketJsonReportRecord2, Map<String, String> map) throws Exception {
        this.w.put("D");
        this.w.put(this.CurrReportName);
        this.w.put(this.CurrReportSubType);
        this.w.put(this.CurrReportVersion);
        for (MarketJsonColumn marketJsonColumn : marketJsonReportRecord2.Columns) {
            boolean bl;
            String string = map.get(marketJsonColumn.getName());
            boolean bl2 = bl = marketJsonColumn.getIsDate() != null ? marketJsonColumn.getIsDate() : true;
            if (bl && !Util.isBlank(string)) {
                try {
                    LocalDateTime localDateTime = JsonUtilities.strToDateTime(string);
                    DateTimeFormatter dateTimeFormatter = this.csvDateFormat;
                    if (localDateTime.getNano() != 0) {
                        dateTimeFormatter = this.csvTimestampFormat;
                    }
                    string = localDateTime.format(dateTimeFormatter);
                    marketJsonColumn.setIsDate(true);
                }
                catch (Exception exception) {
                    marketJsonColumn.setIsDate(false);
                }
            }
            this.w.put(string);
        }
        this.w.nl();
        ++this.LineNo;
    }
}

