/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Translation;

import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationBase;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationInt;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrFileTranslationOSScript
extends pdrFileTranslationBase
implements pdrFileTranslationInt {
    private static Logger logger = LoggerFactory.getLogger(pdrFileTranslationOSScript.class);
    private static final String PARAM_NAME = "name";
    private static final String PARAM_DELETE = "delete";

    public pdrFileTranslationOSScript() {
        super("SCRIPT");
        super.registerParam("l", PARAM_NAME, true, "Operating system script file to execute");
        super.registerOption("d", PARAM_DELETE, "Set this option if the external script can remove the input file (e.g. virus scan)");
    }

    @Override
    public boolean acceptFile(fsFileInfo fsFileInfo2) {
        return true;
    }

    @Override
    public List<fsFileInfo> translateFile(fsFileInfo fsFileInfo2, String string, int n2) throws Exception {
        ArrayList<fsFileInfo> arrayList = new ArrayList<fsFileInfo>();
        String string2 = this.getParam(PARAM_NAME);
        boolean bl = this.hasParam(PARAM_DELETE);
        if (string2 == null) {
            Util_Logger.warning(logger, "Missing parameter name in " + this.getId() + " translator, ignoring action");
            arrayList.add(fsFileInfo2);
        } else {
            Object object;
            Comparable<StringBuilder> comparable;
            boolean bl2 = System.getProperty("os.name").toLowerCase().startsWith("windows");
            if (logger.isDebugEnabled()) {
                Util_Logger.debug(logger, "Command: " + string2.toString());
            }
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (bl2) {
                arrayList2.add("cmd");
                arrayList2.add("/c");
            } else {
                arrayList2.add("/bin/bash");
                arrayList2.add("-c");
            }
            arrayList2.add(string2);
            String string3 = string + "/" + fsFileInfo2.getFilename();
            if (bl2) {
                arrayList2.add(string3.replace('/', '\\'));
            } else {
                arrayList2.add(string3);
            }
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.command(arrayList2);
            Process process = processBuilder.start();
            process.waitFor();
            if (process.exitValue() != 0) {
                comparable = new StringBuilder();
                object = new Scanner(process.getErrorStream());
                while (((Scanner)object).hasNextLine()) {
                    String string4 = ((Scanner)object).nextLine();
                    if (((StringBuilder)comparable).length() > 0) {
                        ((StringBuilder)comparable).append("\r\n");
                    }
                    ((StringBuilder)comparable).append(string4);
                }
                Util_Logger.error(logger, "Error processing OS script translation: " + ((StringBuilder)comparable).toString());
            }
            if (((File)(comparable = new File(string3))).exists()) {
                object = new fsFileInfo(fsFileInfo2);
                ((fsFileInfo)object).setDirectory(string);
                ((fsFileInfo)object).setSize(((File)comparable).length());
                arrayList.add((fsFileInfo)object);
            } else if (bl) {
                Util_Logger.warning(logger, "Input file [" + fsFileInfo2.getFilename() + "] removed following OS script [" + string2 + "] translation");
            } else {
                Util_Logger.error(logger, "Detected file [" + fsFileInfo2.getFilename() + "] no longer available following OS script [" + string2 + "] translation");
            }
        }
        return arrayList;
    }
}

