/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Common.JSON;

import au.com.aemo.Common.Java.Util;
import au.com.nemmco.Pdr.Common.JSON.MarketJsonColumn;
import au.com.nemmco.Pdr.Common.JSON.marketJsonListener;
import au.com.nemmco.Pdr.Common.JSON.marketJsonReportRecord;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class marketJsonParser {
    private Integer inHeader;
    private Integer inReports;
    private int docLevel;
    private marketJsonReportRecord currReport;
    private boolean firstRow = false;
    private marketJsonListener Listener;
    private boolean headerOnly = false;

    public void setHeaderOnly(boolean bl) {
        this.headerOnly = bl;
    }

    public void registerListener(marketJsonListener marketJsonListener2) {
        this.Listener = marketJsonListener2;
    }

    public void convert(InputStream inputStream) throws Exception {
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
             JsonReader jsonReader = new JsonReader((Reader)inputStreamReader);){
            this.docLevel = 0;
            this.handleJsonObject("$", 1, jsonReader);
        }
    }

    private Map<String, String> handleJsonObject(String string, int n2, JsonReader jsonReader) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        jsonReader.beginObject();
        this.docLevel += n2;
        while (jsonReader.hasNext()) {
            JsonToken jsonToken = jsonReader.peek();
            if (!jsonToken.equals((Object)JsonToken.NAME)) continue;
            String string2 = jsonReader.nextName();
            String string3 = string + "." + string2;
            if (string3.equalsIgnoreCase("$.data.header")) {
                this.inHeader = this.docLevel;
            }
            boolean bl = false;
            if (string3.equalsIgnoreCase("$.data.reports")) {
                this.inReports = this.docLevel;
                if (this.headerOnly) {
                    jsonReader.skipValue();
                    bl = true;
                }
            }
            if ((jsonToken = jsonReader.peek()).equals((Object)JsonToken.BEGIN_OBJECT)) {
                this.handleJsonObject(string3, 1, jsonReader);
                continue;
            }
            if (jsonToken.equals((Object)JsonToken.BEGIN_ARRAY)) {
                this.handleJsonArray(string3, jsonReader);
                continue;
            }
            if (jsonToken.equals((Object)JsonToken.STRING) || jsonToken.equals((Object)JsonToken.NUMBER) || jsonToken.equals((Object)JsonToken.NULL)) {
                String string4 = null;
                switch (jsonToken) {
                    case STRING: {
                        string4 = jsonReader.nextString();
                        break;
                    }
                    case NUMBER: {
                        string4 = jsonReader.nextString();
                        break;
                    }
                    case NULL: {
                        jsonReader.nextNull();
                        break;
                    }
                    default: {
                        throw new Exception("Unhandled token [" + String.valueOf(jsonToken) + "] in JSON object");
                    }
                }
                if (this.inReports != null) {
                    if (this.docLevel == this.inReports + 1) {
                        if (this.currReport == null) {
                            this.currReport = new marketJsonReportRecord();
                        }
                        if (string2.equalsIgnoreCase("Id")) {
                            this.currReport.Id = string4;
                        } else if (string2.equalsIgnoreCase("Version")) {
                            this.currReport.Version = string4;
                        }
                    }
                    if (this.docLevel == this.inReports + 2 && this.firstRow) {
                        this.currReport.Columns.add(new MarketJsonColumn(string2));
                    }
                }
                if (Util.isBlank(string4)) continue;
                hashMap.put(string2, string4);
                continue;
            }
            if (bl) continue;
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        this.docLevel -= n2;
        if (this.inHeader != null && this.inHeader == this.docLevel) {
            if (this.Listener != null) {
                this.Listener.processHeader(hashMap);
            }
            this.inHeader = null;
        }
        return hashMap;
    }

    private void handleJsonArray(String string, JsonReader jsonReader) throws Exception {
        jsonReader.beginArray();
        ++this.docLevel;
        if (this.inReports != null) {
            if (this.docLevel == this.inReports + 1) {
                this.currReport = new marketJsonReportRecord();
            }
            if (this.docLevel == this.inReports + 2) {
                this.firstRow = true;
            }
        }
        int n2 = 0;
        while (true) {
            JsonToken jsonToken;
            if ((jsonToken = jsonReader.peek()).equals((Object)JsonToken.END_ARRAY)) {
                jsonReader.endArray();
                --this.docLevel;
                if (this.inReports == null) break;
                this.currReport = null;
                if (this.inReports != this.docLevel) break;
                this.inReports = null;
                break;
            }
            if (jsonToken.equals((Object)JsonToken.BEGIN_OBJECT)) {
                String string2 = string + "[" + n2 + "]";
                Map<String, String> map = this.handleJsonObject(string2, 0, jsonReader);
                if (this.inReports != null) {
                    if (this.firstRow) {
                        if (this.Listener != null) {
                            this.Listener.processInfo(this.currReport);
                        }
                        this.firstRow = false;
                    }
                    if (this.docLevel == this.inReports + 2 && this.Listener != null) {
                        this.Listener.processData(this.currReport, map);
                    }
                }
            }
            ++n2;
        }
    }
}

