/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Common.Monitor;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.Application.ApplicationInt;
import au.com.aemo.Common.FileSystem.FilesystemManager;
import au.com.aemo.Common.FileSystem.fsConnectionFileFilter;
import au.com.aemo.Common.FileSystem.fsConnectionInt;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.FileSystem.fsFileTypeEnum;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebServer;
import au.com.aemo.Common.XML.XmlUtilities;
import au.com.nemmco.Pdr.Common.Monitor.pdrLoggerRec;
import au.com.nemmco.Pdr.Common.Monitor.pdrLoggerRecAck;
import au.com.nemmco.Pdr.Common.Monitor.pdrMonitorConfig;
import au.com.nemmco.Pdr.Common.Monitor.pdrMonitorDataSet;
import au.com.nemmco.Pdr.Common.Monitor.pdrMonitorLogger;
import au.com.nemmco.Pdr.Common.Monitor.pdrMonitorRec;
import au.com.nemmco.Pdr.Common.Monitor.pdrPerformanceRec;
import com.thoughtworks.xstream.XStream;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.nio.file.Files;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrMonitorManager {
    private static Logger logger = LoggerFactory.getLogger(pdrMonitorManager.class);
    public static final String TYPE_LOGGER = "logger";
    public static final String TYPE_PERF = "perf";
    private volatile List<pdrMonitorRec> itsPerfRecords;
    private volatile List<pdrMonitorRec> itsLogRecords;
    private String itsAppName;
    private String itsAppVersion;
    private String itsAppInstanceId;
    private String itsHostname;
    private String itsOverflowDir;
    private String itsTempDir;
    private int itsMaxCacheRecords;
    private DateFormat formatter = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS");
    private String itsRemoteUUID;
    private boolean itsHasValidConfig = false;

    private pdrMonitorManager() {
        this.itsPerfRecords = new ArrayList<pdrMonitorRec>();
        this.itsLogRecords = new ArrayList<pdrMonitorRec>();
    }

    public static pdrMonitorManager getInstance() {
        return SingletonHolder.instance;
    }

    public void init(pdrMonitorConfig pdrMonitorConfig2) throws ApplicationException {
        Object object;
        boolean bl = true;
        this.itsAppInstanceId = pdrMonitorConfig2.itsAppInstanceId;
        this.itsOverflowDir = pdrMonitorConfig2.itsOverflowDir;
        this.itsTempDir = System.getProperty("java.io.tmpdir");
        this.itsMaxCacheRecords = pdrMonitorConfig2.itsMaxCacheRecords;
        if (!Util.isBlank(this.itsOverflowDir)) {
            try {
                object = FilesystemManager.getInstance().getInternalConnection();
                if (!object.exists(this.itsOverflowDir, null)) {
                    Util_Logger.errorNoRaise(logger, "Detected missing peformance overflow directory [" + this.itsOverflowDir + "]");
                    bl = false;
                }
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        if (pdrMonitorConfig2.enableListener) {
            Util_Logger.addListener(new pdrMonitorLogger());
        } else {
            Util_Logger.warning(logger, "Disabling pdrMonitor as performance_overflow_dir is not defined");
        }
        object = WebServer.getInstance();
        if (((WebServer)object).getIsEnabled()) {
            ((WebServer)object).addHandlersFromPackage("au.com.nemmco.Pdr.Common.API");
        }
        this.itsHasValidConfig = bl;
        if (!this.itsHasValidConfig) {
            Util_Logger.error(logger, "Detected invalid monitor configuation, aborting startup");
        }
    }

    public void init(Properties properties) throws ApplicationException {
        pdrMonitorConfig pdrMonitorConfig2 = new pdrMonitorConfig();
        pdrMonitorConfig2.itsAppInstanceId = Util.getProperty(properties, "instance_identifier", "");
        pdrMonitorConfig2.itsOverflowDir = Util.getProperty(properties, "performance_overflow_dir", null);
        pdrMonitorConfig2.itsMaxCacheRecords = Integer.parseInt(Util.getProperty(properties, "performance_cache_max_queue_size", "100"));
        pdrMonitorConfig2.enableListener = !Util.isBlank(pdrMonitorConfig2.itsOverflowDir);
        this.init(pdrMonitorConfig2);
    }

    public void setAppDetails(ApplicationInt applicationInt) {
        this.itsHostname = System.getProperty("hostname");
        this.itsAppName = applicationInt.getAppName();
        this.itsAppVersion = applicationInt.getAppVersion();
    }

    private void updateRec(pdrMonitorRec pdrMonitorRec2) {
        pdrMonitorRec2.setAppName(this.itsAppName);
        pdrMonitorRec2.setAppVersion(this.itsAppVersion);
        pdrMonitorRec2.setAppInstanceId(this.itsAppInstanceId);
        pdrMonitorRec2.setHostName(this.itsHostname);
    }

    public synchronized void checkUUID(String string) {
        if (string != null) {
            if (this.itsRemoteUUID != null && !this.itsRemoteUUID.equalsIgnoreCase(string)) {
                Util_Logger.warning(logger, "Detected new pdrMonitor instance connecting to this application");
            }
            this.itsRemoteUUID = string;
        }
    }

    public void addRecord(pdrMonitorRec pdrMonitorRec2) {
        this.updateRec(pdrMonitorRec2);
        List<pdrMonitorRec> list = null;
        String string = null;
        if (pdrMonitorRec2 instanceof pdrLoggerRec) {
            list = this.itsLogRecords;
            string = TYPE_LOGGER;
        } else if (pdrMonitorRec2 instanceof pdrPerformanceRec) {
            list = this.itsPerfRecords;
            string = TYPE_PERF;
        }
        if (list != null) {
            list.add(pdrMonitorRec2);
            if (!Util.isBlank(this.itsOverflowDir)) {
                if (list.size() > 2 * this.itsMaxCacheRecords) {
                    try {
                        this.flushList(string, list, this.itsMaxCacheRecords);
                    }
                    catch (Exception exception) {
                        Util_Logger.errorNoRaise(logger, "Error flushing " + string + " data cache: " + exception.getMessage(), exception);
                    }
                }
            } else {
                while (list.size() > this.itsMaxCacheRecords) {
                    list.remove(0);
                }
            }
        }
    }

    private String getTransactionFilename(String string) {
        return this.itsAppName + "_" + this.itsAppInstanceId + "_" + string + ".xml";
    }

    private String serializeLogRecords(pdrMonitorDataSet pdrMonitorDataSet2) {
        XStream xStream = XmlUtilities.getConverter();
        xStream.processAnnotations(pdrMonitorDataSet.class);
        xStream.processAnnotations(pdrLoggerRec.class);
        xStream.processAnnotations(pdrPerformanceRec.class);
        return xStream.toXML((Object)pdrMonitorDataSet2);
    }

    private String persistToFile(pdrMonitorDataSet pdrMonitorDataSet2, String string) throws Exception {
        String string2 = this.formatter.format(new Date()) + "_" + string;
        pdrMonitorDataSet2.setTransactionId(string2);
        String string3 = this.serializeLogRecords(pdrMonitorDataSet2);
        String string4 = this.getTransactionFilename(string2);
        fsConnectionInt fsConnectionInt2 = FilesystemManager.getInstance().getInternalConnection();
        fsConnectionInt2.writeData(this.itsOverflowDir, string4, string3.getBytes(), null, null);
        return string3;
    }

    private String checkOverflow(final String string) throws Exception {
        String string2 = null;
        final String string3 = this.itsAppName + "_" + this.itsAppInstanceId;
        fsConnectionFileFilter fsConnectionFileFilter2 = new fsConnectionFileFilter(){

            @Override
            public boolean accept(fsFileInfo fsFileInfo2) {
                String string2 = "_" + string + ".xml";
                return fsFileInfo2.getFilename().toLowerCase().startsWith(string3.toLowerCase()) && fsFileInfo2.getFilename().toLowerCase().endsWith(string2.toLowerCase());
            }
        };
        fsConnectionInt fsConnectionInt2 = FilesystemManager.getInstance().getInternalConnection();
        Map<String, fsFileInfo> map = fsConnectionInt2.listFiles(this.itsOverflowDir, fsConnectionFileFilter2, null);
        fsFileInfo fsFileInfo2 = null;
        for (fsFileInfo fsFileInfo3 : map.values()) {
            if (fsFileInfo2 == null) {
                fsFileInfo2 = fsFileInfo3;
                continue;
            }
            if (!fsFileInfo2.getModifiedDate().after(fsFileInfo3.getModifiedDate())) continue;
            fsFileInfo2 = fsFileInfo3;
        }
        if (fsFileInfo2 != null) {
            String string4 = this.itsTempDir + "/" + fsFileInfo2.getFilename();
            fsConnectionInt2.getFile(fsFileInfo2, this.itsTempDir);
            string2 = new String(Files.readAllBytes(new File(string4).toPath()));
            FileUtilities.deleteFile(string4);
        }
        return string2;
    }

    public void stop() {
        if (this.itsHasValidConfig) {
            try {
                this.flushList(TYPE_LOGGER, this.itsLogRecords, -1);
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Error flushing log data to disk: " + exception.getMessage(), exception);
            }
            try {
                this.flushList(TYPE_PERF, this.itsPerfRecords, -1);
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Error flushing performance data to disk: " + exception.getMessage(), exception);
            }
        }
    }

    private pdrMonitorDataSet<pdrMonitorRec> buildMonitorDataSet(List<pdrMonitorRec> list, int n2) throws Exception {
        pdrMonitorDataSet<pdrMonitorRec> pdrMonitorDataSet2 = new pdrMonitorDataSet<pdrMonitorRec>();
        int n3 = list.size();
        if (n2 > 0) {
            n3 = Math.min(list.size(), this.itsMaxCacheRecords);
        }
        CopyOnWriteArrayList<pdrMonitorRec> copyOnWriteArrayList = new CopyOnWriteArrayList<pdrMonitorRec>(list);
        pdrMonitorDataSet2.addData(copyOnWriteArrayList.subList(0, n3));
        return pdrMonitorDataSet2;
    }

    private String flushList(String string, List<pdrMonitorRec> list, int n2) throws Exception {
        String string2 = null;
        if (!Util.isBlank(this.itsOverflowDir)) {
            pdrMonitorDataSet<pdrMonitorRec> pdrMonitorDataSet2 = this.buildMonitorDataSet(list, n2);
            string2 = this.persistToFile(pdrMonitorDataSet2, string);
            for (pdrMonitorRec pdrMonitorRec2 : pdrMonitorDataSet2.getMonitorRecs()) {
                list.remove(pdrMonitorRec2);
            }
            Util_Logger.info(logger, "Flushed internal monitor cache for " + string + " records, cache now has " + list.size() + " records");
        }
        return string2;
    }

    private String getLatestRecs(String string, List<pdrMonitorRec> list) throws Exception {
        String string2 = null;
        if (!Util.isBlank(this.itsOverflowDir)) {
            string2 = list.size() > 0 ? this.flushList(string, list, this.itsMaxCacheRecords) : this.checkOverflow(string);
        } else {
            pdrMonitorDataSet<pdrMonitorRec> pdrMonitorDataSet2 = this.buildMonitorDataSet(list, -1);
            string2 = this.serializeLogRecords(pdrMonitorDataSet2);
        }
        return string2;
    }

    public String getLatestPerfRecs() throws Exception {
        return this.getLatestRecs(TYPE_PERF, this.itsPerfRecords);
    }

    public String getLatestLogRecs() throws Exception {
        return this.getLatestRecs(TYPE_LOGGER, this.itsLogRecords);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Exposed mutable objects are to internal trusted code")
    public List<pdrMonitorRec> getCurrentLogRecs() throws Exception {
        return this.itsLogRecords;
    }

    public int acknowledgeLogMessages(List<pdrLoggerRecAck> list) {
        int n2 = 0;
        if (list != null && this.itsLogRecords != null) {
            ArrayList<pdrMonitorRec> arrayList = new ArrayList<pdrMonitorRec>(this.itsLogRecords);
            block0: for (pdrMonitorRec pdrMonitorRec2 : arrayList) {
                pdrLoggerRec pdrLoggerRec2;
                if (!(pdrMonitorRec2 instanceof pdrLoggerRec) || Util.isBlank((pdrLoggerRec2 = (pdrLoggerRec)pdrMonitorRec2).getUUID())) continue;
                for (pdrLoggerRecAck pdrLoggerRecAck2 : list) {
                    if (pdrLoggerRecAck2.UUID == null || !pdrLoggerRec2.getUUID().equalsIgnoreCase(pdrLoggerRecAck2.UUID)) continue;
                    pdrLoggerRec2.setAcknowledged(pdrLoggerRecAck2.Acknowleged);
                    ++n2;
                    continue block0;
                }
            }
        }
        return n2;
    }

    public boolean acknowledgeReceipt(String string) throws Exception {
        boolean bl = false;
        if (Util.isInteger(string.substring(0, 1))) {
            String string2 = this.getTransactionFilename(string);
            fsFileInfo fsFileInfo2 = new fsFileInfo();
            fsFileInfo2.setFilename(string2);
            fsFileInfo2.setDirectory(this.itsOverflowDir);
            fsFileInfo2.setFileType(fsFileTypeEnum.FILE);
            fsConnectionInt fsConnectionInt2 = FilesystemManager.getInstance().getInternalConnection();
            if (fsConnectionInt2.exists(fsFileInfo2)) {
                try {
                    fsConnectionInt2.deleteFile(this.itsOverflowDir, string2);
                    Util_Logger.info(logger, "Processed acknowledgement receipt for TransactionId " + string);
                    bl = true;
                }
                catch (Exception exception) {
                    Util_Logger.error(logger, "Detected error acknowledging TransactionId " + string + ": " + exception.getMessage(), exception);
                }
            } else {
                Util_Logger.warning(logger, "Received acknowledgement receipt for TransactionId " + string + " which has aready been acknowledged");
            }
        } else {
            Util_Logger.error(logger, "Invalid TransactionId detected: " + string);
        }
        return bl;
    }

    private static class SingletonHolder {
        private static pdrMonitorManager instance = new pdrMonitorManager();

        private SingletonHolder() {
        }
    }
}

