/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1BitString;
import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1OutputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.ASN1Util;
import com.enterprisedt.bouncycastle.asn1.DERExternal;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.DLExternal;
import com.enterprisedt.bouncycastle.asn1.c;
import com.enterprisedt.bouncycastle.util.Objects;
import java.io.IOException;

public abstract class ASN1External
extends ASN1Primitive {
    static final c a = new c(ASN1External.class, 8){

        @Override
        ASN1Primitive a(ASN1Sequence aSN1Sequence) {
            return aSN1Sequence.f();
        }
    };
    ASN1ObjectIdentifier b;
    ASN1Integer c;
    ASN1Primitive d;
    int e;
    ASN1Primitive f;

    public static ASN1External getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1External) {
            return (ASN1External)obj;
        }
        if (obj instanceof ASN1Encodable) {
            ASN1Primitive aSN1Primitive = ((ASN1Encodable)obj).toASN1Primitive();
            if (aSN1Primitive instanceof ASN1External) {
                return (ASN1External)aSN1Primitive;
            }
        } else if (obj instanceof byte[]) {
            try {
                return (ASN1External)a.a((byte[])obj);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("failed to construct external from byte[]: " + iOException.getMessage());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1External getInstance(ASN1TaggedObject taggedObject, boolean explicit) {
        return (ASN1External)a.a(taggedObject, explicit);
    }

    ASN1External(ASN1Sequence sequence) {
        int n2 = 0;
        ASN1Primitive aSN1Primitive = ASN1External.a(sequence, n2);
        if (aSN1Primitive instanceof ASN1ObjectIdentifier) {
            this.b = (ASN1ObjectIdentifier)aSN1Primitive;
            aSN1Primitive = ASN1External.a(sequence, ++n2);
        }
        if (aSN1Primitive instanceof ASN1Integer) {
            this.c = (ASN1Integer)aSN1Primitive;
            aSN1Primitive = ASN1External.a(sequence, ++n2);
        }
        if (!(aSN1Primitive instanceof ASN1TaggedObject)) {
            this.d = aSN1Primitive;
            aSN1Primitive = ASN1External.a(sequence, ++n2);
        }
        if (sequence.size() != n2 + 1) {
            throw new IllegalArgumentException("input sequence too large");
        }
        if (!(aSN1Primitive instanceof ASN1TaggedObject)) {
            throw new IllegalArgumentException("No tagged object found in sequence. Structure doesn't seem to be of type External");
        }
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Primitive;
        this.e = ASN1External.a(aSN1TaggedObject.getTagNo());
        this.f = ASN1External.a(aSN1TaggedObject);
    }

    ASN1External(ASN1ObjectIdentifier directReference, ASN1Integer indirectReference, ASN1Primitive dataValueDescriptor, DERTaggedObject externalData) {
        this.b = directReference;
        this.c = indirectReference;
        this.d = dataValueDescriptor;
        this.e = ASN1External.a(externalData.getTagNo());
        this.f = ASN1External.a(externalData);
    }

    ASN1External(ASN1ObjectIdentifier directReference, ASN1Integer indirectReference, ASN1Primitive dataValueDescriptor, int encoding, ASN1Primitive externalData) {
        this.b = directReference;
        this.c = indirectReference;
        this.d = dataValueDescriptor;
        this.e = ASN1External.a(encoding);
        this.f = ASN1External.a(encoding, externalData);
    }

    abstract ASN1Sequence d();

    @Override
    int a(boolean bl) throws IOException {
        return this.d().a(bl);
    }

    @Override
    void a(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.a(bl, 40);
        this.d().a(aSN1OutputStream, false);
    }

    @Override
    ASN1Primitive b() {
        return new DERExternal(this.b, this.c, this.d, this.e, this.f);
    }

    @Override
    ASN1Primitive c() {
        return new DLExternal(this.b, this.c, this.d, this.e, this.f);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.b) ^ Objects.hashCode(this.c) ^ Objects.hashCode(this.d) ^ this.e ^ this.f.hashCode();
    }

    @Override
    boolean a() {
        return true;
    }

    @Override
    boolean a(ASN1Primitive aSN1Primitive) {
        if (this == aSN1Primitive) {
            return true;
        }
        if (!(aSN1Primitive instanceof ASN1External)) {
            return false;
        }
        ASN1External aSN1External = (ASN1External)aSN1Primitive;
        return Objects.areEqual(this.b, aSN1External.b) && Objects.areEqual(this.c, aSN1External.c) && Objects.areEqual(this.d, aSN1External.d) && this.e == aSN1External.e && this.f.equals(aSN1External.f);
    }

    public ASN1Primitive getDataValueDescriptor() {
        return this.d;
    }

    public ASN1ObjectIdentifier getDirectReference() {
        return this.b;
    }

    public int getEncoding() {
        return this.e;
    }

    public ASN1Primitive getExternalContent() {
        return this.f;
    }

    public ASN1Integer getIndirectReference() {
        return this.c;
    }

    private static int a(int n2) {
        if (n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException("invalid encoding value: " + n2);
        }
        return n2;
    }

    private static ASN1Primitive a(int n2, ASN1Primitive aSN1Primitive) {
        switch (n2) {
            case 1: {
                return ASN1OctetString.a.a(aSN1Primitive);
            }
            case 2: {
                return ASN1BitString.a.a(aSN1Primitive);
            }
        }
        return aSN1Primitive;
    }

    private static ASN1Primitive a(ASN1TaggedObject aSN1TaggedObject) {
        int n2 = aSN1TaggedObject.getTagClass();
        int n3 = aSN1TaggedObject.getTagNo();
        if (128 != n2) {
            throw new IllegalArgumentException("invalid tag: " + ASN1Util.getTagText(n2, n3));
        }
        switch (n3) {
            case 0: {
                return aSN1TaggedObject.getExplicitBaseObject().toASN1Primitive();
            }
            case 1: {
                return ASN1OctetString.getInstance(aSN1TaggedObject, false);
            }
            case 2: {
                return ASN1BitString.getInstance(aSN1TaggedObject, false);
            }
        }
        throw new IllegalArgumentException("invalid tag: " + ASN1Util.getTagText(n2, n3));
    }

    private static ASN1Primitive a(ASN1Sequence aSN1Sequence, int n2) {
        if (aSN1Sequence.size() <= n2) {
            throw new IllegalArgumentException("too few objects in input sequence");
        }
        return aSN1Sequence.getObjectAt(n2).toASN1Primitive();
    }
}

