/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1OutputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.OIDTokenizer;
import com.enterprisedt.bouncycastle.asn1.c;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class ASN1RelativeOID
extends ASN1Primitive {
    static final c a = new c(ASN1RelativeOID.class, 13){

        @Override
        ASN1Primitive a(DEROctetString dEROctetString) {
            return ASN1RelativeOID.a(dEROctetString.getOctets(), false);
        }
    };
    private final String b;
    private byte[] c;

    public static ASN1RelativeOID fromContents(byte[] contents) {
        return ASN1RelativeOID.a(contents, true);
    }

    public static ASN1RelativeOID getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1RelativeOID) {
            return (ASN1RelativeOID)obj;
        }
        if (obj instanceof ASN1Encodable) {
            ASN1Primitive aSN1Primitive = ((ASN1Encodable)obj).toASN1Primitive();
            if (aSN1Primitive instanceof ASN1RelativeOID) {
                return (ASN1RelativeOID)aSN1Primitive;
            }
        } else if (obj instanceof byte[]) {
            byte[] byArray = (byte[])obj;
            try {
                return (ASN1RelativeOID)a.a(byArray);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("failed to construct relative OID from byte[]: " + iOException.getMessage());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1RelativeOID getInstance(ASN1TaggedObject taggedObject, boolean explicit) {
        return (ASN1RelativeOID)a.a(taggedObject, explicit);
    }

    public ASN1RelativeOID(String identifier) {
        if (identifier == null) {
            throw new NullPointerException("'identifier' cannot be null");
        }
        if (!ASN1RelativeOID.a(identifier, 0)) {
            throw new IllegalArgumentException("string " + identifier + " not a relative OID");
        }
        this.b = identifier;
    }

    ASN1RelativeOID(ASN1RelativeOID oid, String branchID) {
        if (!ASN1RelativeOID.a(branchID, 0)) {
            throw new IllegalArgumentException("string " + branchID + " not a valid OID branch");
        }
        this.b = oid.getId() + "." + branchID;
    }

    private ASN1RelativeOID(byte[] contents, boolean clone) {
        StringBuffer stringBuffer = new StringBuffer();
        long l2 = 0L;
        BigInteger bigInteger = null;
        boolean bl = true;
        for (int i2 = 0; i2 != contents.length; ++i2) {
            int n2 = contents[i2] & 0xFF;
            if (l2 <= 0xFFFFFFFFFFFF80L) {
                l2 += (long)(n2 & 0x7F);
                if ((n2 & 0x80) == 0) {
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuffer.append('.');
                    }
                    stringBuffer.append(l2);
                    l2 = 0L;
                    continue;
                }
                l2 <<= 7;
                continue;
            }
            if (bigInteger == null) {
                bigInteger = BigInteger.valueOf(l2);
            }
            bigInteger = bigInteger.or(BigInteger.valueOf(n2 & 0x7F));
            if ((n2 & 0x80) == 0) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append('.');
                }
                stringBuffer.append(bigInteger);
                bigInteger = null;
                l2 = 0L;
                continue;
            }
            bigInteger = bigInteger.shiftLeft(7);
        }
        this.b = stringBuffer.toString();
        this.c = clone ? Arrays.clone(contents) : contents;
    }

    public ASN1RelativeOID branch(String branchID) {
        return new ASN1RelativeOID(this, branchID);
    }

    public String getId() {
        return this.b;
    }

    @Override
    public int hashCode() {
        return this.b.hashCode();
    }

    public String toString() {
        return this.getId();
    }

    @Override
    boolean a(ASN1Primitive aSN1Primitive) {
        if (this == aSN1Primitive) {
            return true;
        }
        if (!(aSN1Primitive instanceof ASN1RelativeOID)) {
            return false;
        }
        ASN1RelativeOID aSN1RelativeOID = (ASN1RelativeOID)aSN1Primitive;
        return this.b.equals(aSN1RelativeOID.b);
    }

    @Override
    int a(boolean bl) {
        return ASN1OutputStream.b(bl, this.d().length);
    }

    @Override
    void a(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.a(bl, 13, this.d());
    }

    @Override
    boolean a() {
        return false;
    }

    private void a(ByteArrayOutputStream byteArrayOutputStream) {
        OIDTokenizer oIDTokenizer = new OIDTokenizer(this.b);
        while (oIDTokenizer.hasMoreTokens()) {
            String string = oIDTokenizer.nextToken();
            if (string.length() <= 18) {
                ASN1RelativeOID.a(byteArrayOutputStream, Long.parseLong(string));
                continue;
            }
            ASN1RelativeOID.a(byteArrayOutputStream, new BigInteger(string));
        }
    }

    private synchronized byte[] d() {
        if (this.c == null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.a(byteArrayOutputStream);
            this.c = byteArrayOutputStream.toByteArray();
        }
        return this.c;
    }

    static ASN1RelativeOID a(byte[] byArray, boolean bl) {
        return new ASN1RelativeOID(byArray, bl);
    }

    static boolean a(String string, int n2) {
        int n3 = 0;
        int n4 = string.length();
        while (--n4 >= n2) {
            char c2 = string.charAt(n4);
            if (c2 == '.') {
                if (0 == n3 || n3 > 1 && string.charAt(n4 + 1) == '0') {
                    return false;
                }
                n3 = 0;
                continue;
            }
            if ('0' <= c2 && c2 <= '9') {
                ++n3;
                continue;
            }
            return false;
        }
        return 0 != n3 && (n3 <= true || string.charAt(n4 + 1) != '0');
    }

    static void a(ByteArrayOutputStream byteArrayOutputStream, long l2) {
        byte[] byArray = new byte[9];
        int n2 = 8;
        byArray[n2] = (byte)((int)l2 & 0x7F);
        while (l2 >= 128L) {
            byArray[--n2] = (byte)((int)(l2 >>= 7) | 0x80);
        }
        byteArrayOutputStream.write(byArray, n2, 9 - n2);
    }

    static void a(ByteArrayOutputStream byteArrayOutputStream, BigInteger bigInteger) {
        int n2 = (bigInteger.bitLength() + 6) / 7;
        if (n2 == 0) {
            byteArrayOutputStream.write(0);
        } else {
            BigInteger bigInteger2 = bigInteger;
            byte[] byArray = new byte[n2];
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                byArray[i2] = (byte)(bigInteger2.intValue() | 0x80);
                bigInteger2 = bigInteger2.shiftRight(7);
            }
            int n3 = n2 - 1;
            byArray[n3] = (byte)(byArray[n3] & 0x7F);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
        }
    }
}

