/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1BitString;
import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1Set;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObjectParser;
import com.enterprisedt.bouncycastle.asn1.ASN1Util;
import com.enterprisedt.bouncycastle.asn1.BERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.DLTaggedObject;
import com.enterprisedt.bouncycastle.asn1.c;
import com.enterprisedt.bouncycastle.asn1.d;
import com.enterprisedt.bouncycastle.asn1.e;
import com.enterprisedt.bouncycastle.asn1.k;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;

public abstract class ASN1TaggedObject
extends ASN1Primitive
implements ASN1TaggedObjectParser {
    final int a;
    final int b;
    final int c;
    final ASN1Encodable d;

    public static ASN1TaggedObject getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1TaggedObject) {
            return (ASN1TaggedObject)obj;
        }
        if (obj instanceof ASN1Encodable) {
            ASN1Primitive aSN1Primitive = ((ASN1Encodable)obj).toASN1Primitive();
            if (aSN1Primitive instanceof ASN1TaggedObject) {
                return (ASN1TaggedObject)aSN1Primitive;
            }
        } else if (obj instanceof byte[]) {
            try {
                return ASN1TaggedObject.c(ASN1TaggedObject.fromByteArray((byte[])obj));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("failed to construct tagged object from byte[]: " + iOException.getMessage());
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1TaggedObject getInstance(Object obj, int tagClass) {
        if (obj == null) {
            throw new NullPointerException("'obj' cannot be null");
        }
        ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(obj);
        if (tagClass != aSN1TaggedObject.getTagClass()) {
            throw new IllegalArgumentException("unexpected tag in getInstance: " + ASN1Util.getTagText(aSN1TaggedObject));
        }
        return aSN1TaggedObject;
    }

    public static ASN1TaggedObject getInstance(Object obj, int tagClass, int tagNo) {
        if (obj == null) {
            throw new NullPointerException("'obj' cannot be null");
        }
        ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(obj);
        if (!aSN1TaggedObject.hasTag(tagClass, tagNo)) {
            throw new IllegalArgumentException("unexpected tag in getInstance: " + ASN1Util.getTagText(aSN1TaggedObject));
        }
        return aSN1TaggedObject;
    }

    public static ASN1TaggedObject getInstance(ASN1TaggedObject taggedObject, boolean declaredExplicit) {
        if (128 != taggedObject.getTagClass()) {
            throw new IllegalStateException("this method only valid for CONTEXT_SPECIFIC tags");
        }
        if (declaredExplicit) {
            return taggedObject.getExplicitBaseTagged();
        }
        throw new IllegalArgumentException("this method not valid for implicitly tagged tagged objects");
    }

    protected ASN1TaggedObject(boolean explicit, int tagNo, ASN1Encodable obj) {
        this(explicit, 128, tagNo, obj);
    }

    protected ASN1TaggedObject(boolean explicit, int tagClass, int tagNo, ASN1Encodable obj) {
        this(explicit ? 1 : 2, tagClass, tagNo, obj);
    }

    ASN1TaggedObject(int explicitness, int tagClass, int tagNo, ASN1Encodable obj) {
        if (null == obj) {
            throw new NullPointerException("'obj' cannot be null");
        }
        if (tagClass == 0 || (tagClass & 0xC0) != tagClass) {
            throw new IllegalArgumentException("invalid tag class: " + tagClass);
        }
        this.a = obj instanceof ASN1Choice ? 1 : explicitness;
        this.b = tagClass;
        this.c = tagNo;
        this.d = obj;
    }

    @Override
    final boolean a(ASN1Primitive aSN1Primitive) {
        ASN1Primitive aSN1Primitive2;
        if (!(aSN1Primitive instanceof ASN1TaggedObject)) {
            return false;
        }
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Primitive;
        if (this.c != aSN1TaggedObject.c || this.b != aSN1TaggedObject.b) {
            return false;
        }
        if (this.a != aSN1TaggedObject.a && this.isExplicit() != aSN1TaggedObject.isExplicit()) {
            return false;
        }
        ASN1Primitive aSN1Primitive3 = this.d.toASN1Primitive();
        if (aSN1Primitive3 == (aSN1Primitive2 = aSN1TaggedObject.d.toASN1Primitive())) {
            return true;
        }
        if (!this.isExplicit()) {
            try {
                byte[] byArray = this.getEncoded();
                byte[] byArray2 = aSN1TaggedObject.getEncoded();
                return Arrays.areEqual(byArray, byArray2);
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return aSN1Primitive3.a(aSN1Primitive2);
    }

    @Override
    public int hashCode() {
        return this.b * 7919 ^ this.c ^ (this.isExplicit() ? 15 : 240) ^ this.d.toASN1Primitive().hashCode();
    }

    @Override
    public int getTagClass() {
        return this.b;
    }

    @Override
    public int getTagNo() {
        return this.c;
    }

    @Override
    public boolean hasContextTag() {
        return this.b == 128;
    }

    @Override
    public boolean hasContextTag(int tagNo) {
        return this.b == 128 && this.c == tagNo;
    }

    @Override
    public boolean hasTag(int tagClass, int tagNo) {
        return this.b == tagClass && this.c == tagNo;
    }

    @Override
    public boolean hasTagClass(int tagClass) {
        return this.b == tagClass;
    }

    public boolean isExplicit() {
        switch (this.a) {
            case 1: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    boolean d() {
        switch (this.a) {
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public ASN1Object getBaseObject() {
        return this.d instanceof ASN1Object ? (ASN1Object)this.d : this.d.toASN1Primitive();
    }

    public ASN1Object getExplicitBaseObject() {
        if (!this.isExplicit()) {
            throw new IllegalStateException("object implicit - explicit expected.");
        }
        return this.d instanceof ASN1Object ? (ASN1Object)this.d : this.d.toASN1Primitive();
    }

    public ASN1TaggedObject getExplicitBaseTagged() {
        if (!this.isExplicit()) {
            throw new IllegalStateException("object implicit - explicit expected.");
        }
        return ASN1TaggedObject.c(this.d.toASN1Primitive());
    }

    public ASN1TaggedObject getImplicitBaseTagged(int baseTagClass, int baseTagNo) {
        if (baseTagClass == 0 || (baseTagClass & 0xC0) != baseTagClass) {
            throw new IllegalArgumentException("invalid base tag class: " + baseTagClass);
        }
        switch (this.a) {
            case 1: {
                throw new IllegalStateException("object explicit - implicit expected.");
            }
            case 2: {
                ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.c(this.d.toASN1Primitive());
                return ASN1Util.a(aSN1TaggedObject, baseTagClass, baseTagNo);
            }
        }
        return this.a(baseTagClass, baseTagNo);
    }

    public ASN1Primitive getBaseUniversal(boolean declaredExplicit, int tagNo) {
        c c2 = com.enterprisedt.bouncycastle.asn1.d.a(tagNo);
        if (null == c2) {
            throw new IllegalArgumentException("unsupported UNIVERSAL tag number: " + tagNo);
        }
        return this.a(declaredExplicit, c2);
    }

    ASN1Primitive a(boolean bl, c c2) {
        if (bl) {
            if (!this.isExplicit()) {
                throw new IllegalStateException("object explicit - implicit expected.");
            }
            return c2.a(this.d.toASN1Primitive());
        }
        if (1 == this.a) {
            throw new IllegalStateException("object explicit - implicit expected.");
        }
        ASN1Primitive aSN1Primitive = this.d.toASN1Primitive();
        switch (this.a) {
            case 3: {
                return c2.a(this.b(aSN1Primitive));
            }
            case 4: {
                if (aSN1Primitive instanceof ASN1Sequence) {
                    return c2.a((ASN1Sequence)aSN1Primitive);
                }
                return c2.a((DEROctetString)aSN1Primitive);
            }
        }
        return c2.a(aSN1Primitive);
    }

    @Override
    public ASN1Encodable parseBaseUniversal(boolean declaredExplicit, int baseTagNo) throws IOException {
        ASN1Primitive aSN1Primitive = this.getBaseUniversal(declaredExplicit, baseTagNo);
        switch (baseTagNo) {
            case 3: {
                return ((ASN1BitString)aSN1Primitive).parser();
            }
            case 4: {
                return ((ASN1OctetString)aSN1Primitive).parser();
            }
            case 16: {
                return ((ASN1Sequence)aSN1Primitive).parser();
            }
            case 17: {
                return ((ASN1Set)aSN1Primitive).parser();
            }
        }
        return aSN1Primitive;
    }

    @Override
    public ASN1Encodable parseExplicitBaseObject() throws IOException {
        return this.getExplicitBaseObject();
    }

    @Override
    public ASN1TaggedObjectParser parseExplicitBaseTagged() throws IOException {
        return this.getExplicitBaseTagged();
    }

    @Override
    public ASN1TaggedObjectParser parseImplicitBaseTagged(int baseTagClass, int baseTagNo) throws IOException {
        return this.getImplicitBaseTagged(baseTagClass, baseTagNo);
    }

    @Override
    public final ASN1Primitive getLoadedObject() {
        return this;
    }

    abstract ASN1Sequence b(ASN1Primitive var1);

    abstract ASN1TaggedObject a(int var1, int var2);

    @Override
    ASN1Primitive b() {
        return new DERTaggedObject(this.a, this.b, this.c, this.d);
    }

    @Override
    ASN1Primitive c() {
        return new DLTaggedObject(this.a, this.b, this.c, this.d);
    }

    public String toString() {
        return ASN1Util.getTagText(this.b, this.c) + this.d;
    }

    static ASN1Primitive a(int n2, int n3, ASN1EncodableVector aSN1EncodableVector) {
        boolean bl = aSN1EncodableVector.size() == 1;
        return bl ? new DLTaggedObject(3, n2, n3, aSN1EncodableVector.get(0)) : new DLTaggedObject(4, n2, n3, (ASN1Encodable)k.a(aSN1EncodableVector));
    }

    static ASN1Primitive b(int n2, int n3, ASN1EncodableVector aSN1EncodableVector) {
        boolean bl = aSN1EncodableVector.size() == 1;
        return bl ? new BERTaggedObject(3, n2, n3, aSN1EncodableVector.get(0)) : new BERTaggedObject(4, n2, n3, (ASN1Encodable)e.a(aSN1EncodableVector));
    }

    static ASN1Primitive a(int n2, int n3, byte[] byArray) {
        return new DLTaggedObject(4, n2, n3, (ASN1Encodable)new DEROctetString(byArray));
    }

    private static ASN1TaggedObject c(ASN1Primitive aSN1Primitive) {
        if (aSN1Primitive instanceof ASN1TaggedObject) {
            return (ASN1TaggedObject)aSN1Primitive;
        }
        throw new IllegalStateException("unexpected object: " + aSN1Primitive.getClass().getName());
    }
}

