/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.anssi;

import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.anssi.ANSSIObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.x9.X9ECParameters;
import com.enterprisedt.bouncycastle.asn1.x9.X9ECParametersHolder;
import com.enterprisedt.bouncycastle.asn1.x9.X9ECPoint;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.WNafUtil;
import com.enterprisedt.bouncycastle.util.Strings;
import com.enterprisedt.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Hashtable;

public class ANSSINamedCurves {
    static X9ECParametersHolder a = new X9ECParametersHolder(){

        @Override
        protected ECCurve createCurve() {
            BigInteger bigInteger = ANSSINamedCurves.b("F1FD178C0B3AD58F10126DE8CE42435B3961ADBCABC8CA6DE8FCF353D86E9C03");
            BigInteger bigInteger2 = ANSSINamedCurves.b("F1FD178C0B3AD58F10126DE8CE42435B3961ADBCABC8CA6DE8FCF353D86E9C00");
            BigInteger bigInteger3 = ANSSINamedCurves.b("EE353FCA5428A9300D4ABA754A44C00FDFEC0C9AE4B1A1803075ED967B7BB73F");
            BigInteger bigInteger4 = ANSSINamedCurves.b("F1FD178C0B3AD58F10126DE8CE42435B53DC67E140D2BF941FFDD459C6D655E1");
            BigInteger bigInteger5 = BigInteger.valueOf(1L);
            return ANSSINamedCurves.b(new ECCurve.Fp(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, true));
        }

        @Override
        protected X9ECParameters createParameters() {
            byte[] byArray = null;
            ECCurve eCCurve = this.createCurve();
            X9ECPoint x9ECPoint = ANSSINamedCurves.b(eCCurve, "04B6B3D4C356C139EB31183D4749D423958C27D2DCAF98B70164C97A2DD98F5CFF6142E0F7C8B204911F9271F0F3ECEF8C2701C307E8E4C9E183115A1554062CFB");
            return new X9ECParameters(eCCurve, x9ECPoint, eCCurve.getOrder(), eCCurve.getCofactor(), byArray);
        }
    };
    static final Hashtable b = new Hashtable();
    static final Hashtable c = new Hashtable();
    static final Hashtable d = new Hashtable();

    private static X9ECPoint b(ECCurve eCCurve, String string) {
        X9ECPoint x9ECPoint = new X9ECPoint(eCCurve, Hex.decodeStrict(string));
        WNafUtil.configureBasepoint(x9ECPoint.getPoint());
        return x9ECPoint;
    }

    private static ECCurve b(ECCurve eCCurve) {
        return eCCurve;
    }

    private static BigInteger b(String string) {
        return new BigInteger(1, Hex.decodeStrict(string));
    }

    static void a(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier, X9ECParametersHolder x9ECParametersHolder) {
        b.put(Strings.toLowerCase(string), aSN1ObjectIdentifier);
        d.put(aSN1ObjectIdentifier, string);
        c.put(aSN1ObjectIdentifier, x9ECParametersHolder);
    }

    public static X9ECParameters getByName(String name) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = ANSSINamedCurves.getOID(name);
        return aSN1ObjectIdentifier == null ? null : ANSSINamedCurves.getByOID(aSN1ObjectIdentifier);
    }

    public static X9ECParametersHolder getByNameLazy(String name) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = ANSSINamedCurves.getOID(name);
        return aSN1ObjectIdentifier == null ? null : ANSSINamedCurves.getByOIDLazy(aSN1ObjectIdentifier);
    }

    public static X9ECParameters getByOID(ASN1ObjectIdentifier oid) {
        X9ECParametersHolder x9ECParametersHolder = ANSSINamedCurves.getByOIDLazy(oid);
        return x9ECParametersHolder == null ? null : x9ECParametersHolder.getParameters();
    }

    public static X9ECParametersHolder getByOIDLazy(ASN1ObjectIdentifier oid) {
        return (X9ECParametersHolder)c.get(oid);
    }

    public static ASN1ObjectIdentifier getOID(String name) {
        return (ASN1ObjectIdentifier)b.get(Strings.toLowerCase(name));
    }

    public static String getName(ASN1ObjectIdentifier oid) {
        return (String)d.get(oid);
    }

    public static Enumeration getNames() {
        return d.elements();
    }

    static {
        ANSSINamedCurves.a("FRP256v1", ANSSIObjectIdentifiers.FRP256v1, a);
    }
}

