/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.bc;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.util.Arrays;

public class PbkdMacIntegrityCheck
extends ASN1Object {
    private final AlgorithmIdentifier a;
    private final KeyDerivationFunc b;
    private final ASN1OctetString c;

    public PbkdMacIntegrityCheck(AlgorithmIdentifier macAlgorithm, KeyDerivationFunc pbkdAlgorithm, byte[] mac) {
        this.a = macAlgorithm;
        this.b = pbkdAlgorithm;
        this.c = new DEROctetString(Arrays.clone(mac));
    }

    private PbkdMacIntegrityCheck(ASN1Sequence seq) {
        this.a = AlgorithmIdentifier.getInstance(seq.getObjectAt(0));
        this.b = KeyDerivationFunc.getInstance(seq.getObjectAt(1));
        this.c = ASN1OctetString.getInstance(seq.getObjectAt(2));
    }

    public static PbkdMacIntegrityCheck getInstance(Object o2) {
        if (o2 instanceof PbkdMacIntegrityCheck) {
            return (PbkdMacIntegrityCheck)o2;
        }
        if (o2 != null) {
            return new PbkdMacIntegrityCheck(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public AlgorithmIdentifier getMacAlgorithm() {
        return this.a;
    }

    public KeyDerivationFunc getPbkdAlgorithm() {
        return this.b;
    }

    public byte[] getMac() {
        return Arrays.clone(this.c.getOctets());
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(3);
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        return new DERSequence(aSN1EncodableVector);
    }
}

