/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cryptopro;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.util.Enumeration;

public class GOST28147Parameters
extends ASN1Object {
    private ASN1OctetString a;
    private ASN1ObjectIdentifier b;

    public static GOST28147Parameters getInstance(ASN1TaggedObject obj, boolean explicit) {
        return GOST28147Parameters.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static GOST28147Parameters getInstance(Object obj) {
        if (obj instanceof GOST28147Parameters) {
            return (GOST28147Parameters)obj;
        }
        if (obj != null) {
            return new GOST28147Parameters(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public GOST28147Parameters(byte[] iv, ASN1ObjectIdentifier paramSet) {
        this.a = new DEROctetString(Arrays.clone(iv));
        this.b = paramSet;
    }

    private GOST28147Parameters(ASN1Sequence seq) {
        Enumeration enumeration = seq.getObjects();
        this.a = (ASN1OctetString)enumeration.nextElement();
        this.b = (ASN1ObjectIdentifier)enumeration.nextElement();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        return new DERSequence(aSN1EncodableVector);
    }

    public ASN1ObjectIdentifier getEncryptionParamSet() {
        return this.b;
    }

    public byte[] getIV() {
        return Arrays.clone(this.a.getOctets());
    }
}

