/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.esf;

import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.esf.OtherHashAlgAndValue;
import com.enterprisedt.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class OtherHash
extends ASN1Object
implements ASN1Choice {
    private ASN1OctetString a;
    private OtherHashAlgAndValue b;

    public static OtherHash getInstance(Object obj) {
        if (obj instanceof OtherHash) {
            return (OtherHash)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new OtherHash((ASN1OctetString)obj);
        }
        return new OtherHash(OtherHashAlgAndValue.getInstance(obj));
    }

    private OtherHash(ASN1OctetString sha1Hash) {
        this.a = sha1Hash;
    }

    public OtherHash(OtherHashAlgAndValue otherHash) {
        this.b = otherHash;
    }

    public OtherHash(byte[] sha1Hash) {
        this.a = new DEROctetString(sha1Hash);
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        if (null == this.b) {
            return new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1);
        }
        return this.b.getHashAlgorithm();
    }

    public byte[] getHashValue() {
        if (null == this.b) {
            return this.a.getOctets();
        }
        return this.b.getHashValue().getOctets();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (null == this.b) {
            return this.a;
        }
        return this.b.toASN1Primitive();
    }
}

