/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.esf;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.ASN1UTF8String;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERUTF8String;
import com.enterprisedt.bouncycastle.asn1.x500.DirectoryString;
import java.util.Enumeration;

public class SignerLocation
extends ASN1Object {
    private DirectoryString a;
    private DirectoryString b;
    private ASN1Sequence c;

    private SignerLocation(ASN1Sequence seq) {
        Enumeration enumeration = seq.getObjects();
        block5: while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(enumeration.nextElement(), 128);
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    this.a = DirectoryString.getInstance(aSN1TaggedObject, true);
                    continue block5;
                }
                case 1: {
                    this.b = DirectoryString.getInstance(aSN1TaggedObject, true);
                    continue block5;
                }
                case 2: {
                    this.c = aSN1TaggedObject.isExplicit() ? ASN1Sequence.getInstance(aSN1TaggedObject, true) : ASN1Sequence.getInstance(aSN1TaggedObject, false);
                    if (this.c == null || this.c.size() <= 6) continue block5;
                    throw new IllegalArgumentException("postal address must contain less than 6 strings");
                }
            }
            throw new IllegalArgumentException("illegal tag");
        }
    }

    private SignerLocation(DirectoryString countryName, DirectoryString localityName, ASN1Sequence postalAddress) {
        if (postalAddress != null && postalAddress.size() > 6) {
            throw new IllegalArgumentException("postal address must contain less than 6 strings");
        }
        this.a = countryName;
        this.b = localityName;
        this.c = postalAddress;
    }

    public SignerLocation(DirectoryString countryName, DirectoryString localityName, DirectoryString[] postalAddress) {
        this(countryName, localityName, (ASN1Sequence)new DERSequence(postalAddress));
    }

    public SignerLocation(ASN1UTF8String countryName, ASN1UTF8String localityName, ASN1Sequence postalAddress) {
        this(DirectoryString.getInstance(countryName), DirectoryString.getInstance(localityName), postalAddress);
    }

    public static SignerLocation getInstance(Object obj) {
        if (obj == null || obj instanceof SignerLocation) {
            return (SignerLocation)obj;
        }
        return new SignerLocation(ASN1Sequence.getInstance(obj));
    }

    public DirectoryString getCountry() {
        return this.a;
    }

    public DirectoryString getLocality() {
        return this.b;
    }

    public DirectoryString[] getPostal() {
        if (this.c == null) {
            return null;
        }
        DirectoryString[] directoryStringArray = new DirectoryString[this.c.size()];
        for (int i2 = 0; i2 != directoryStringArray.length; ++i2) {
            directoryStringArray[i2] = DirectoryString.getInstance(this.c.getObjectAt(i2));
        }
        return directoryStringArray;
    }

    public DERUTF8String getCountryName() {
        if (this.a == null) {
            return null;
        }
        return new DERUTF8String(this.getCountry().getString());
    }

    public DERUTF8String getLocalityName() {
        if (this.b == null) {
            return null;
        }
        return new DERUTF8String(this.getLocality().getString());
    }

    public ASN1Sequence getPostalAddress() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(3);
        if (this.a != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, (ASN1Encodable)this.a));
        }
        if (this.b != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 1, (ASN1Encodable)this.b));
        }
        if (this.c != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 2, (ASN1Encodable)this.c));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

