/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.ocsp;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1GeneralizedTime;
import com.enterprisedt.bouncycastle.asn1.ASN1IA5String;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERIA5String;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import java.util.Enumeration;

public class CrlID
extends ASN1Object {
    private ASN1IA5String a;
    private ASN1Integer b;
    private ASN1GeneralizedTime c;

    private CrlID(ASN1Sequence seq) {
        Enumeration enumeration = seq.getObjects();
        block5: while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    this.a = ASN1IA5String.getInstance(aSN1TaggedObject, true);
                    continue block5;
                }
                case 1: {
                    this.b = ASN1Integer.getInstance(aSN1TaggedObject, true);
                    continue block5;
                }
                case 2: {
                    this.c = ASN1GeneralizedTime.getInstance(aSN1TaggedObject, true);
                    continue block5;
                }
            }
            throw new IllegalArgumentException("unknown tag number: " + aSN1TaggedObject.getTagNo());
        }
    }

    public static CrlID getInstance(Object obj) {
        if (obj instanceof CrlID) {
            return (CrlID)obj;
        }
        if (obj != null) {
            return new CrlID(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public DERIA5String getCrlUrl() {
        return null == this.a || this.a instanceof DERIA5String ? (DERIA5String)this.a : new DERIA5String(this.a.getString(), false);
    }

    public ASN1IA5String getCrlUrlIA5() {
        return this.a;
    }

    public ASN1Integer getCrlNum() {
        return this.b;
    }

    public ASN1GeneralizedTime getCrlTime() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(3);
        if (this.a != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, (ASN1Encodable)this.a));
        }
        if (this.b != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 1, (ASN1Encodable)this.b));
        }
        if (this.c != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 2, (ASN1Encodable)this.c));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

