/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.ocsp;

import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.x500.X500Name;

public class ResponderID
extends ASN1Object
implements ASN1Choice {
    private ASN1Encodable a;

    public ResponderID(ASN1OctetString value) {
        this.a = value;
    }

    public ResponderID(X500Name value) {
        this.a = value;
    }

    public static ResponderID getInstance(Object obj) {
        if (obj instanceof ResponderID) {
            return (ResponderID)obj;
        }
        if (obj instanceof DEROctetString) {
            return new ResponderID((DEROctetString)obj);
        }
        if (obj instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)obj;
            if (aSN1TaggedObject.getTagNo() == 1) {
                return new ResponderID(X500Name.getInstance(aSN1TaggedObject, true));
            }
            return new ResponderID(ASN1OctetString.getInstance(aSN1TaggedObject, true));
        }
        return new ResponderID(X500Name.getInstance(obj));
    }

    public static ResponderID getInstance(ASN1TaggedObject obj, boolean explicit) {
        if (!explicit) {
            throw new IllegalArgumentException("choice item must be explicitly tagged");
        }
        return ResponderID.getInstance(obj.getExplicitBaseObject());
    }

    public byte[] getKeyHash() {
        if (this.a instanceof ASN1OctetString) {
            ASN1OctetString aSN1OctetString = (ASN1OctetString)this.a;
            return aSN1OctetString.getOctets();
        }
        return null;
    }

    public X500Name getName() {
        if (this.a instanceof ASN1OctetString) {
            return null;
        }
        return X500Name.getInstance(this.a);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.a instanceof ASN1OctetString) {
            return new DERTaggedObject(true, 2, this.a);
        }
        return new DERTaggedObject(true, 1, this.a);
    }
}

